/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.encryption.configuration.kms;

import java.security.KeyStore;
import java.util.Objects;
import org.apache.nifi.repository.encryption.configuration.EncryptedRepositoryType;
import org.apache.nifi.repository.encryption.configuration.kms.EncryptedConfigurationException;
import org.apache.nifi.repository.encryption.configuration.kms.EncryptionKeyProvider;
import org.apache.nifi.repository.encryption.configuration.kms.RepositoryKeyProviderFactory;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.security.kms.KeyProviderFactory;
import org.apache.nifi.security.kms.configuration.KeyProviderConfiguration;
import org.apache.nifi.security.kms.configuration.KeyStoreKeyProviderConfiguration;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;

public class StandardRepositoryKeyProviderFactory
implements RepositoryKeyProviderFactory {
    @Override
    public KeyProvider getKeyProvider(EncryptedRepositoryType encryptedRepositoryType, NiFiProperties niFiProperties) {
        Objects.requireNonNull(encryptedRepositoryType, "Encrypted Repository Type required");
        Objects.requireNonNull(niFiProperties, "NiFi Properties required");
        EncryptionKeyProvider encryptionKeyProvider = this.getEncryptionKeyProvider(encryptedRepositoryType, niFiProperties);
        KeyProviderConfiguration<?> keyProviderConfiguration = this.getKeyProviderConfiguration(encryptionKeyProvider, niFiProperties);
        return KeyProviderFactory.getKeyProvider(keyProviderConfiguration);
    }

    private EncryptionKeyProvider getEncryptionKeyProvider(EncryptedRepositoryType encryptedRepositoryType, NiFiProperties niFiProperties) {
        String sharedKeyProvider = niFiProperties.getProperty("nifi.repository.encryption.key.provider");
        if (StringUtils.isBlank((String)sharedKeyProvider)) {
            String message = String.format("Key Provider [%s] not configured for Repository Type [%s] ", new Object[]{sharedKeyProvider, encryptedRepositoryType});
            throw new EncryptedConfigurationException(message);
        }
        try {
            return EncryptionKeyProvider.valueOf(sharedKeyProvider);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Key Provider [%s] not supported for Repository Type [%s] ", new Object[]{sharedKeyProvider, encryptedRepositoryType});
            throw new EncryptedConfigurationException(message);
        }
    }

    private KeyProviderConfiguration<?> getKeyProviderConfiguration(EncryptionKeyProvider encryptionKeyProvider, NiFiProperties niFiProperties) {
        if (EncryptionKeyProvider.KEYSTORE == encryptionKeyProvider) {
            String providerPassword = niFiProperties.getProperty("nifi.repository.encryption.key.provider.keystore.password");
            if (StringUtils.isBlank((String)providerPassword)) {
                throw new EncryptedConfigurationException("Key Provider Password not configured");
            }
            char[] keyStorePassword = providerPassword.toCharArray();
            String location = niFiProperties.getProperty("nifi.repository.encryption.key.provider.keystore.location");
            KeystoreType keystoreType = KeyStoreUtils.getKeystoreTypeFromExtension((String)location);
            try {
                KeyStore keyStore = KeyStoreUtils.loadSecretKeyStore((String)location, (char[])keyStorePassword, (String)keystoreType.getType());
                return new KeyStoreKeyProviderConfiguration(keyStore, keyStorePassword);
            }
            catch (TlsException e) {
                throw new EncryptedConfigurationException("Key Store Provider loading failed", e);
            }
        }
        throw new UnsupportedOperationException(String.format("Key Provider [%s] not supported", new Object[]{encryptionKeyProvider}));
    }
}

