/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.minifi.commons.utils.PropertyUtil;
import org.apache.nifi.util.NiFiProperties;

public class MultiSourceMinifiProperties
extends NiFiProperties {
    private final Properties properties = new Properties();

    public static MultiSourceMinifiProperties getInstance() {
        return new MultiSourceMinifiProperties();
    }

    private MultiSourceMinifiProperties() {
        this.readFromPropertiesFile();
    }

    public Set<String> getPropertyKeys() {
        return Stream.of(System.getProperties().stringPropertyNames(), System.getenv().keySet(), this.properties.stringPropertyNames()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public int size() {
        return this.getPropertyKeys().size();
    }

    public String getProperty(String key) {
        return PropertyUtil.resolvePropertyValue((String)key, (Map)System.getProperties()).or(() -> PropertyUtil.resolvePropertyValue((String)key, System.getenv())).orElseGet(() -> this.properties.getProperty(key));
    }

    private void readFromPropertiesFile() {
        String propertiesFilePath = System.getProperty("nifi.properties.file.path");
        if (propertiesFilePath != null) {
            File propertiesFile = new File(propertiesFilePath.trim());
            if (!propertiesFile.exists()) {
                throw new RuntimeException("Properties file doesn't exist '" + propertiesFile.getAbsolutePath() + "'");
            }
            if (!propertiesFile.canRead()) {
                throw new RuntimeException("Properties file exists but cannot be read '" + propertiesFile.getAbsolutePath() + "'");
            }
            try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(propertiesFile));){
                this.properties.load(inStream);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot load properties file due to " + ex.getLocalizedMessage(), ex);
            }
        }
    }
}

