/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.flow.Bundle;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.ControllerServiceAPI;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedReportingTask;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.minifi.commons.api.MiNiFiProperties;
import org.apache.nifi.properties.ReadableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowEnrichService {
    static final String DEFAULT_SSL_CONTEXT_SERVICE_NAME = "SSL Context Service";
    static final String COMMON_SSL_CONTEXT_SERVICE_NAME = "SSL-Context-Service";
    static final String COMMON_SSL_CONTEXT_SERVICE_ID = "generated-common-ssl-context";
    static final String SITE_TO_SITE_PROVENANCE_REPORTING_TASK_NAME = "Site-To-Site-Provenance-Reporting";
    static final String SITE_TO_SITE_PROVENANCE_REPORTING_TASK_ID = "generated-s2s-provenance-reporting-task";
    private static final Logger LOG = LoggerFactory.getLogger(FlowEnrichService.class);
    private static final String NIFI_BUNDLE_GROUP = "org.apache.nifi";
    private static final String STANDARD_RESTRICTED_SSL_CONTEXT_SERVICE = "org.apache.nifi.ssl.StandardRestrictedSSLContextService";
    private static final String RESTRICTED_SSL_CONTEXT_SERVICE_API = "org.apache.nifi.ssl.RestrictedSSLContextService";
    private static final String SSL_CONTEXT_SERVICE_API = "org.apache.nifi.ssl.SSLContextService";
    private static final String SSL_CONTEXT_SERVICE_NAR = "nifi-ssl-context-service-nar";
    private static final String STANDARD_SERVICES_API_NAR_ARTIFACT = "nifi-standard-services-api-nar";
    private static final String SITE_TO_SITE_PROVENANCE_REPORTING_TASK = "org.apache.nifi.reporting.SiteToSiteProvenanceReportingTask";
    private static final String SITE_TO_SITE_REPORTING_NAR_ARTIFACT = "nifi-site-to-site-reporting-nar";
    private static final String PROVENANCE_REPORTING_TASK_PROTOCOL = "HTTP";
    private static final String PROVENANCE_REPORTING_TASK_BEGINNING_OF_STREAM = "beginning-of-stream";
    private final ReadableProperties minifiProperties;

    public FlowEnrichService(ReadableProperties minifiProperties) {
        this.minifiProperties = minifiProperties;
    }

    public byte[] enrichFlow(byte[] flowCandidate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enriching flow with content: \n{}", (Object)new String(flowCandidate, StandardCharsets.UTF_8));
        }
        VersionedDataflow versionedDataflow = this.parseVersionedDataflow(flowCandidate);
        versionedDataflow.setReportingTasks(Optional.ofNullable(versionedDataflow.getReportingTasks()).orElseGet(ArrayList::new));
        versionedDataflow.setRegistries(Optional.ofNullable(versionedDataflow.getRegistries()).orElseGet(ArrayList::new));
        versionedDataflow.setControllerServices(Optional.ofNullable(versionedDataflow.getControllerServices()).orElseGet(ArrayList::new));
        Optional<Integer> maxConcurrentThreads = Optional.ofNullable(this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_FLOW_MAX_CONCURRENT_THREADS.getKey())).map(Integer::parseInt);
        maxConcurrentThreads.ifPresent(arg_0 -> ((VersionedDataflow)versionedDataflow).setMaxTimerDrivenThreadCount(arg_0));
        VersionedProcessGroup rootGroup = versionedDataflow.getRootGroup();
        if (rootGroup.getIdentifier() == null) {
            rootGroup.setIdentifier(UUID.randomUUID().toString());
        }
        if (rootGroup.getInstanceIdentifier() == null) {
            rootGroup.setInstanceIdentifier(UUID.randomUUID().toString());
        }
        rootGroup.getControllerServices().forEach(controllerService -> controllerService.setScheduledState(ScheduledState.ENABLED));
        Optional<VersionedControllerService> commonSslControllerService = this.createCommonSslControllerService();
        commonSslControllerService.ifPresent(versionedDataflow.getControllerServices()::add);
        commonSslControllerService.filter(__ -> Boolean.parseBoolean(this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_FLOW_USE_PARENT_SSL.getKey()))).map(VersionedComponent::getInstanceIdentifier).ifPresent(commonSslControllerServiceInstanceId -> this.overrideProcessorsSslControllerService(rootGroup, (String)commonSslControllerServiceInstanceId));
        this.createProvenanceReportingTask(commonSslControllerService.map(VersionedComponent::getInstanceIdentifier).orElse("")).ifPresent(versionedDataflow.getReportingTasks()::add);
        byte[] enrichedFlow = this.toByteArray(versionedDataflow);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enriched flow with content: \n{}", (Object)new String(enrichedFlow, StandardCharsets.UTF_8));
        }
        return enrichedFlow;
    }

    private VersionedDataflow parseVersionedDataflow(byte[] flow) {
        try {
            ObjectMapper objectMapper = this.deserializationObjectMapper();
            return (VersionedDataflow)objectMapper.readValue(flow, VersionedDataflow.class);
        }
        catch (Exception e) {
            throw new FlowSerializationException("Could not parse flow as a VersionedDataflow", (Throwable)e);
        }
    }

    private ObjectMapper deserializationObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(objectMapper.getTypeFactory()));
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    private Optional<VersionedControllerService> createCommonSslControllerService() {
        if (!this.parentSslEnabled()) {
            LOG.debug("Parent SSL is disabled, skip creating parent SSL Controller Service");
            return Optional.empty();
        }
        LOG.debug("Parent SSL is enabled, creating parent SSL Controller Service");
        VersionedControllerService sslControllerService = new VersionedControllerService();
        sslControllerService.setIdentifier(UUID.randomUUID().toString());
        sslControllerService.setInstanceIdentifier(COMMON_SSL_CONTEXT_SERVICE_ID);
        sslControllerService.setName(COMMON_SSL_CONTEXT_SERVICE_NAME);
        sslControllerService.setComments("");
        sslControllerService.setType(STANDARD_RESTRICTED_SSL_CONTEXT_SERVICE);
        sslControllerService.setScheduledState(ScheduledState.ENABLED);
        sslControllerService.setBulletinLevel(LogLevel.WARN.name());
        sslControllerService.setComponentType(ComponentType.CONTROLLER_SERVICE);
        sslControllerService.setBundle(this.createBundle(SSL_CONTEXT_SERVICE_NAR));
        sslControllerService.setProperties(this.sslControllerServiceProperties());
        sslControllerService.setControllerServiceApis(List.of(this.controllerServiceAPI(SSL_CONTEXT_SERVICE_API, this.createBundle(STANDARD_SERVICES_API_NAR_ARTIFACT)), this.controllerServiceAPI(RESTRICTED_SSL_CONTEXT_SERVICE_API, this.createBundle(STANDARD_SERVICES_API_NAR_ARTIFACT))));
        sslControllerService.setPropertyDescriptors(Map.of());
        return Optional.of(sslControllerService);
    }

    private boolean parentSslEnabled() {
        return MiNiFiProperties.securityPropertyKeys().stream().map(arg_0 -> ((ReadableProperties)this.minifiProperties).getProperty(arg_0)).allMatch(StringUtils::isNotBlank);
    }

    private Map<String, String> sslControllerServiceProperties() {
        return Map.of("Keystore Filename", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_KEYSTORE.getKey()), "Keystore Password", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_KEYSTORE_PASSWD.getKey()), "key-password", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_KEY_PASSWD.getKey()), "Keystore Type", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_KEYSTORE_TYPE.getKey()), "Truststore Filename", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_TRUSTSTORE.getKey()), "Truststore Password", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_TRUSTSTORE_PASSWD.getKey()), "Truststore Type", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_TRUSTSTORE_TYPE.getKey()), "SSL Protocol", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SECURITY_SSL_PROTOCOL.getKey()));
    }

    private ControllerServiceAPI controllerServiceAPI(String type, Bundle bundle) {
        ControllerServiceAPI controllerServiceAPI = new ControllerServiceAPI();
        controllerServiceAPI.setType(type);
        controllerServiceAPI.setBundle(bundle);
        return controllerServiceAPI;
    }

    private void overrideProcessorsSslControllerService(VersionedProcessGroup processGroup, String commonSslControllerServiceInstanceId) {
        LOG.debug("Use parent SSL is enabled, overriding processors' SSL Controller service to {}", (Object)commonSslControllerServiceInstanceId);
        processGroup.getProcessors().forEach(processor -> processor.getProperties().replace(DEFAULT_SSL_CONTEXT_SERVICE_NAME, (String)processor.getProperties().get(DEFAULT_SSL_CONTEXT_SERVICE_NAME), commonSslControllerServiceInstanceId));
        processGroup.getProcessGroups().forEach(childProcessGroup -> this.overrideProcessorsSslControllerService((VersionedProcessGroup)childProcessGroup, commonSslControllerServiceInstanceId));
    }

    private Optional<VersionedReportingTask> createProvenanceReportingTask(String sslControllerServiceIdentifier) {
        if (!this.provenanceReportingEnabled()) {
            LOG.debug("Provenance reporting task is disabled, skip creating provenance reporting task");
            return Optional.empty();
        }
        LOG.debug("Provenance reporting task is enabled, creating provenance reporting task");
        VersionedReportingTask reportingTask = new VersionedReportingTask();
        reportingTask.setIdentifier(UUID.randomUUID().toString());
        reportingTask.setInstanceIdentifier(SITE_TO_SITE_PROVENANCE_REPORTING_TASK_ID);
        reportingTask.setName(SITE_TO_SITE_PROVENANCE_REPORTING_TASK_NAME);
        reportingTask.setComments(this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_COMMENT.getKey()));
        reportingTask.setType(SITE_TO_SITE_PROVENANCE_REPORTING_TASK);
        reportingTask.setBundle(this.createBundle(SITE_TO_SITE_REPORTING_NAR_ARTIFACT));
        reportingTask.setScheduledState(ScheduledState.RUNNING);
        reportingTask.setSchedulingStrategy(this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_SCHEDULING_STRATEGY.getKey()));
        reportingTask.setSchedulingPeriod(this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_SCHEDULING_PERIOD.getKey()));
        reportingTask.setComponentType(ComponentType.REPORTING_TASK);
        reportingTask.setProperties(this.provenanceReportingTaskProperties(sslControllerServiceIdentifier));
        reportingTask.setPropertyDescriptors(Map.of());
        return Optional.of(reportingTask);
    }

    private boolean provenanceReportingEnabled() {
        return MiNiFiProperties.provenanceReportingPropertyKeys().stream().map(arg_0 -> ((ReadableProperties)this.minifiProperties).getProperty(arg_0)).allMatch(StringUtils::isNotBlank);
    }

    private Bundle createBundle(String artifact) {
        Bundle bundle = new Bundle();
        bundle.setGroup(NIFI_BUNDLE_GROUP);
        bundle.setArtifact(artifact);
        bundle.setVersion("");
        return bundle;
    }

    private Map<String, String> provenanceReportingTaskProperties(String sslControllerServiceIdentifier) {
        return List.of(Map.entry("Input Port Name", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_INPUT_PORT_NAME.getKey())), Map.entry("s2s-transport-protocol", PROVENANCE_REPORTING_TASK_PROTOCOL), Map.entry("Platform", "nifi"), Map.entry("Destination URL", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_DESTINATION_URL.getKey())), Map.entry("include-null-values", Boolean.FALSE.toString()), Map.entry("Compress Events", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_COMPRESS_EVENTS.getKey())), Map.entry("Batch Size", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_BATCH_SIZE.getKey())), Map.entry("Communications Timeout", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_COMMUNICATIONS_TIMEOUT.getKey())), Map.entry("start-position", PROVENANCE_REPORTING_TASK_BEGINNING_OF_STREAM), Map.entry("Instance URL", this.minifiProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_PROVENANCE_REPORTING_INSTANCE_URL.getKey())), Map.entry(DEFAULT_SSL_CONTEXT_SERVICE_NAME, sslControllerServiceIdentifier)).stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private byte[] toByteArray(VersionedDataflow versionedDataflow) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            JsonFactory factory = new JsonFactory();
            JsonGenerator generator = factory.createGenerator((OutputStream)byteArrayOutputStream);
            generator.setCodec((ObjectCodec)this.serializationObjectMapper());
            generator.writeObject((Object)versionedDataflow);
            generator.flush();
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to convert flow to byte array", e);
            }
        }
        byteArrayOutputStream.close();
        return byArray;
    }

    private ObjectMapper serializationObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(objectMapper.getTypeFactory()));
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
}

