/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.FlowFileAccessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.provenance.ProvenanceReporter;

public interface ProcessSession {
    public void commit();

    public void commitAsync();

    default public void commitAsync(Runnable onSuccess) {
        this.commitAsync(onSuccess, null);
    }

    public void commitAsync(Runnable var1, Consumer<Throwable> var2);

    public void rollback();

    public void rollback(boolean var1);

    public void migrate(ProcessSession var1, Collection<FlowFile> var2);

    public void migrate(ProcessSession var1);

    public void adjustCounter(String var1, long var2, boolean var4);

    public FlowFile get();

    public List<FlowFile> get(int var1);

    public List<FlowFile> get(FlowFileFilter var1);

    public QueueSize getQueueSize();

    public FlowFile create();

    public FlowFile create(FlowFile var1);

    public FlowFile create(Collection<FlowFile> var1);

    public FlowFile clone(FlowFile var1);

    public FlowFile clone(FlowFile var1, long var2, long var4);

    public FlowFile penalize(FlowFile var1);

    public FlowFile putAttribute(FlowFile var1, String var2, String var3);

    public FlowFile putAllAttributes(FlowFile var1, Map<String, String> var2);

    public FlowFile removeAttribute(FlowFile var1, String var2);

    public FlowFile removeAllAttributes(FlowFile var1, Set<String> var2);

    public FlowFile removeAllAttributes(FlowFile var1, Pattern var2);

    public void transfer(FlowFile var1, Relationship var2);

    public void transfer(FlowFile var1);

    public void transfer(Collection<FlowFile> var1);

    public void transfer(Collection<FlowFile> var1, Relationship var2);

    public void remove(FlowFile var1);

    public void remove(Collection<FlowFile> var1);

    public void read(FlowFile var1, InputStreamCallback var2) throws FlowFileAccessException;

    public InputStream read(FlowFile var1);

    public FlowFile merge(Collection<FlowFile> var1, FlowFile var2);

    public FlowFile merge(Collection<FlowFile> var1, FlowFile var2, byte[] var3, byte[] var4, byte[] var5);

    public FlowFile write(FlowFile var1, OutputStreamCallback var2) throws FlowFileAccessException;

    public OutputStream write(FlowFile var1);

    public FlowFile write(FlowFile var1, StreamCallback var2) throws FlowFileAccessException;

    public FlowFile append(FlowFile var1, OutputStreamCallback var2) throws FlowFileAccessException;

    public FlowFile importFrom(Path var1, boolean var2, FlowFile var3);

    public FlowFile importFrom(InputStream var1, FlowFile var2);

    public void exportTo(FlowFile var1, Path var2, boolean var3);

    public void exportTo(FlowFile var1, OutputStream var2);

    public ProvenanceReporter getProvenanceReporter();

    public void setState(Map<String, String> var1, Scope var2) throws IOException;

    public StateMap getState(Scope var1) throws IOException;

    public boolean replaceState(StateMap var1, Map<String, String> var2, Scope var3) throws IOException;

    public void clearState(Scope var1) throws IOException;
}

