/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.ParameterStatusDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ParameterGroupConfigurationEntity;
import org.apache.nifi.web.api.entity.ParameterProviderReferencingComponentEntity;

@XmlType(name="parameterProvider")
public class ParameterProviderDTO
extends ComponentDTO {
    public static final String VALID = "VALID";
    public static final String INVALID = "INVALID";
    public static final String VALIDATING = "VALIDATING";
    private String name;
    private String type;
    private BundleDTO bundle;
    private String comments;
    private Boolean persistsState;
    private Boolean restricted;
    private Boolean deprecated;
    private Boolean isExtensionMissing;
    private Boolean multipleVersionsAvailable;
    private Map<String, String> properties;
    private Map<String, PropertyDescriptorDTO> descriptors;
    private Collection<ParameterGroupConfigurationEntity> parameterGroupConfigurations;
    private Set<AffectedComponentEntity> affectedComponents;
    private Set<ParameterStatusDTO> parameterStatus;
    private Set<ParameterProviderReferencingComponentEntity> referencingParameterContexts;
    private String customUiUrl;
    private String annotationData;
    private Collection<String> validationErrors;
    private String validationStatus;

    @ApiModelProperty(value="The name of the parameter provider.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The set of all components in the flow that are referencing Parameters provided by this provider")
    public Set<AffectedComponentEntity> getAffectedComponents() {
        return this.affectedComponents;
    }

    public void setAffectedComponents(Set<AffectedComponentEntity> affectedComponents) {
        this.affectedComponents = affectedComponents;
    }

    public void setReferencingParameterContexts(Set<ParameterProviderReferencingComponentEntity> referencingParameterContexts) {
        this.referencingParameterContexts = referencingParameterContexts;
    }

    @ApiModelProperty(value="The status of all provided parameters for this parameter provider")
    public Set<ParameterStatusDTO> getParameterStatus() {
        return this.parameterStatus;
    }

    public void setParameterStatus(Set<ParameterStatusDTO> parameterStatus) {
        this.parameterStatus = parameterStatus;
    }

    @ApiModelProperty(value="The Parameter Contexts that reference this Parameter Provider", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public Set<ParameterProviderReferencingComponentEntity> getReferencingParameterContexts() {
        return this.referencingParameterContexts;
    }

    @ApiModelProperty(value="Configuration for any fetched parameter groups.")
    public Collection<ParameterGroupConfigurationEntity> getParameterGroupConfigurations() {
        return this.parameterGroupConfigurations;
    }

    public void setParameterGroupConfigurations(Collection<ParameterGroupConfigurationEntity> parameterGroupConfigurations) {
        this.parameterGroupConfigurations = parameterGroupConfigurations;
    }

    @ApiModelProperty(value="The comments of the parameter provider.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @ApiModelProperty(value="The fully qualified type of the parameter provider.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ApiModelProperty(value="The details of the artifact that bundled this parameter provider type.")
    public BundleDTO getBundle() {
        return this.bundle;
    }

    public void setBundle(BundleDTO bundle) {
        this.bundle = bundle;
    }

    @ApiModelProperty(value="Whether the parameter provider persists state.")
    public Boolean getPersistsState() {
        return this.persistsState;
    }

    public void setPersistsState(Boolean persistsState) {
        this.persistsState = persistsState;
    }

    @ApiModelProperty(value="Whether the parameter provider requires elevated privileges.")
    public Boolean getRestricted() {
        return this.restricted;
    }

    public void setRestricted(Boolean restricted) {
        this.restricted = restricted;
    }

    @ApiModelProperty(value="Whether the parameter provider has been deprecated.")
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @ApiModelProperty(value="Whether the underlying extension is missing.")
    public Boolean getExtensionMissing() {
        return this.isExtensionMissing;
    }

    public void setExtensionMissing(Boolean extensionMissing) {
        this.isExtensionMissing = extensionMissing;
    }

    @ApiModelProperty(value="Whether the parameter provider has multiple versions available.")
    public Boolean getMultipleVersionsAvailable() {
        return this.multipleVersionsAvailable;
    }

    public void setMultipleVersionsAvailable(Boolean multipleVersionsAvailable) {
        this.multipleVersionsAvailable = multipleVersionsAvailable;
    }

    @ApiModelProperty(value="The properties of the parameter provider.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @ApiModelProperty(value="The descriptors for the parameter providers properties.")
    public Map<String, PropertyDescriptorDTO> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(Map<String, PropertyDescriptorDTO> descriptors) {
        this.descriptors = descriptors;
    }

    @ApiModelProperty(value="The URL for the custom configuration UI for the parameter provider.")
    public String getCustomUiUrl() {
        return this.customUiUrl;
    }

    public void setCustomUiUrl(String customUiUrl) {
        this.customUiUrl = customUiUrl;
    }

    @ApiModelProperty(value="The annotation data for the parameter provider. This is how the custom UI relays configuration to the parameter provider.")
    public String getAnnotationData() {
        return this.annotationData;
    }

    public void setAnnotationData(String annotationData) {
        this.annotationData = annotationData;
    }

    @ApiModelProperty(value="Gets the validation errors from the parameter provider. These validation errors represent the problems with the parameter provider that must be resolved before it can be scheduled to run.")
    public Collection<String> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(Collection<String> validationErrors) {
        this.validationErrors = validationErrors;
    }

    @ApiModelProperty(value="Indicates whether the Parameter Provider is valid, invalid, or still in the process of validating (i.e., it is unknown whether or not the Parameter Provider is valid)", accessMode=ApiModelProperty.AccessMode.READ_ONLY, allowableValues="VALID, INVALID, VALIDATING")
    public String getValidationStatus() {
        return this.validationStatus;
    }

    public void setValidationStatus(String validationStatus) {
        this.validationStatus = validationStatus;
    }
}

