/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="affectedComponent")
public class AffectedComponentDTO {
    public static final String COMPONENT_TYPE_PROCESSOR = "PROCESSOR";
    public static final String COMPONENT_TYPE_CONTROLLER_SERVICE = "CONTROLLER_SERVICE";
    public static final String COMPONENT_TYPE_INPUT_PORT = "INPUT_PORT";
    public static final String COMPONENT_TYPE_OUTPUT_PORT = "OUTPUT_PORT";
    public static final String COMPONENT_TYPE_REMOTE_INPUT_PORT = "REMOTE_INPUT_PORT";
    public static final String COMPONENT_TYPE_REMOTE_OUTPUT_PORT = "REMOTE_OUTPUT_PORT";
    public static final String COMPONENT_TYPE_STATELESS_GROUP = "STATELESS_GROUP";
    private String processGroupId;
    private String id;
    private String referenceType;
    private String name;
    private String state;
    private Integer activeThreadCount;
    private Collection<String> validationErrors;

    @ApiModelProperty(value="The UUID of the Process Group that this component is in")
    public String getProcessGroupId() {
        return this.processGroupId;
    }

    public void setProcessGroupId(String processGroupId) {
        this.processGroupId = processGroupId;
    }

    @ApiModelProperty(value="The UUID of this component")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The type of this component", allowableValues="PROCESSOR,CONTROLLER_SERVICE, INPUT_PORT, OUTPUT_PORT, REMOTE_INPUT_PORT, REMOTE_OUTPUT_PORT, STATELESS_GROUP")
    public String getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    @ApiModelProperty(value="The name of this component.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The number of active threads for the referencing component.")
    public Integer getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public void setActiveThreadCount(Integer activeThreadCount) {
        this.activeThreadCount = activeThreadCount;
    }

    @ApiModelProperty(value="The validation errors for the component.")
    public Collection<String> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(Collection<String> validationErrors) {
        this.validationErrors = validationErrors;
    }

    @ApiModelProperty(value="The scheduled state of a processor or reporting task referencing a controller service. If this component is another controller service, this field represents the controller service state.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String toString() {
        return "AffectedComponent[type=" + this.referenceType + ", id=" + this.id + ", name=" + this.name + ", processGroup=" + this.processGroupId + "]";
    }
}

