/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.nifi.c2.protocol.api.C2Operation;
import org.apache.nifi.c2.protocol.api.OperationState;

@ApiModel
public class Operation
extends C2Operation {
    private static final long serialVersionUID = 1L;
    private String targetAgentId;
    private OperationState state = OperationState.NEW;
    private String details;
    private String bulkOperationId;
    private String createdBy;
    private Long created;
    private Long updated;

    @ApiModelProperty(value="The identifier of the agent to which the operation applies")
    public String getTargetAgentId() {
        return this.targetAgentId;
    }

    public void setTargetAgentId(String targetAgentId) {
        this.targetAgentId = targetAgentId;
    }

    @ApiModelProperty(value="The current state of the operation", accessMode=ApiModelProperty.AccessMode.READ_ONLY)
    public OperationState getState() {
        return this.state;
    }

    public void setState(OperationState state) {
        this.state = state;
    }

    @ApiModelProperty(hidden=true)
    public String getBulkOperationId() {
        return this.bulkOperationId;
    }

    public void setBulkOperationId(String bulkOperationId) {
        this.bulkOperationId = bulkOperationId;
    }

    @ApiModelProperty(value="The verified identity of the C2 client that created the operation", accessMode=ApiModelProperty.AccessMode.READ_ONLY, notes="This field is set by the server when an operation request is submitted to identify the origin. When the C2 instance is secured, this is the client principal identity (e.g., certificate DN). When the C2 instances is unsecured, this will be 'anonymous' as client identity can not be authenticated.")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @ApiModelProperty(value="The time (in milliseconds since Epoch) that this operation was created")
    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    @ApiModelProperty(value="The time (in milliseconds since Epoch) that this operation was last updated")
    public Long getUpdated() {
        return this.updated;
    }

    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @ApiModelProperty(value="Additional details about the state of this operation (such as an error message).")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }
}

