/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel
public class C2OperationState
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="State of the operation performed", required=true, example="FULLY_APPLIED")
    private OperationState state;
    @ApiModelProperty(value="Additional details about the state", example="Operation failed due to missing processor(s)")
    private String details;

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public OperationState getState() {
        return this.state;
    }

    public void setState(OperationState state) {
        this.state = state;
    }

    public void setStateFromOrdinal(int state) {
        this.state = OperationState.fromOrdinal(state);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        C2OperationState that = (C2OperationState)o;
        return this.state == that.state && Objects.equals(this.details, that.details);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.details});
    }

    public String toString() {
        return "C2OperationState{state=" + String.valueOf((Object)this.state) + ", details='" + this.details + "'}";
    }

    public static enum OperationState {
        FULLY_APPLIED,
        PARTIALLY_APPLIED,
        OPERATION_NOT_UNDERSTOOD,
        NO_OPERATION,
        NOT_APPLIED;


        public static OperationState fromOrdinal(int state) {
            switch (state) {
                case 0: {
                    return FULLY_APPLIED;
                }
                case 1: {
                    return PARTIALLY_APPLIED;
                }
                case 2: {
                    return OPERATION_NOT_UNDERSTOOD;
                }
                case 3: {
                    return NO_OPERATION;
                }
            }
            return NOT_APPLIED;
        }

        public static int toOrdinal(OperationState state) {
            switch (state.ordinal()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            return 4;
        }
    }
}

