/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.Properties;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeException;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiPropertiesGenerator;
import org.apache.nifi.minifi.commons.api.MiNiFiCommandState;
import org.slf4j.Logger;

public class UpdatePropertiesService {
    private final RunMiNiFi runner;
    private final Logger logger;
    private final BootstrapFileProvider bootstrapFileProvider;
    private final MiNiFiPropertiesGenerator miNiFiPropertiesGenerator;

    public UpdatePropertiesService(RunMiNiFi runner, Logger logger, BootstrapFileProvider bootstrapFileProvider) {
        this.runner = runner;
        this.logger = logger;
        this.bootstrapFileProvider = bootstrapFileProvider;
        this.miNiFiPropertiesGenerator = new MiNiFiPropertiesGenerator();
    }

    public Optional<MiNiFiCommandState> handleUpdate() {
        Optional<MiNiFiCommandState> commandState;
        try {
            File bootstrapConfigFile = BootstrapFileProvider.getBootstrapConfFile();
            File bootstrapSwapConfigFile = this.bootstrapFileProvider.getBootstrapConfSwapFile();
            this.logger.info("Persisting old bootstrap configuration to {}", (Object)bootstrapSwapConfigFile.getAbsolutePath());
            try (FileInputStream configFileInputStream = new FileInputStream(bootstrapConfigFile);){
                Files.copy(configFileInputStream, bootstrapSwapConfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            Files.copy(this.bootstrapFileProvider.getBootstrapConfNewFile().toPath(), bootstrapConfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            commandState = this.generateConfigfilesBasedOnNewProperties(bootstrapConfigFile, bootstrapSwapConfigFile, this.bootstrapFileProvider.getBootstrapProperties());
        }
        catch (Exception e) {
            commandState = Optional.of(MiNiFiCommandState.NOT_APPLIED_WITHOUT_RESTART);
            this.logger.error("Failed to load new bootstrap properties", (Throwable)e);
        }
        return commandState;
    }

    private Optional<MiNiFiCommandState> generateConfigfilesBasedOnNewProperties(File bootstrapConfigFile, File bootstrapSwapConfigFile, Properties bootstrapProperties) throws IOException, ConfigurationChangeException {
        Optional<MiNiFiCommandState> commandState;
        block8: {
            commandState = Optional.empty();
            try {
                this.miNiFiPropertiesGenerator.generateMinifiProperties(bootstrapProperties.getProperty("conf.dir"), bootstrapProperties);
                this.restartInstance();
            }
            catch (Exception e) {
                commandState = Optional.of(MiNiFiCommandState.NOT_APPLIED_WITHOUT_RESTART);
                try (FileInputStream swapConfigFileStream = new FileInputStream(bootstrapSwapConfigFile);){
                    Files.copy(swapConfigFileStream, bootstrapConfigFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                bootstrapProperties = this.bootstrapFileProvider.getBootstrapProperties();
                this.miNiFiPropertiesGenerator.generateMinifiProperties(bootstrapProperties.getProperty("conf.dir"), bootstrapProperties);
                this.logger.debug("Transformation of new config file failed after swap file was created, deleting it.");
                if (bootstrapSwapConfigFile.delete()) break block8;
                this.logger.warn("The swap file ({}) failed to delete after a failed handling of a change. It should be cleaned up manually.", (Object)bootstrapSwapConfigFile);
            }
        }
        return commandState;
    }

    private void restartInstance() throws IOException {
        try {
            this.runner.reload();
        }
        catch (IOException e) {
            throw new IOException("Unable to successfully restart MiNiFi instance after configuration change.", e);
        }
    }
}

