/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.minifi.bootstrap.MiNiFiParameters;
import org.apache.nifi.minifi.bootstrap.MiNiFiStatus;
import org.apache.nifi.minifi.bootstrap.QueryableStatusAggregator;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiCommandSender;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiStatusProvider;
import org.apache.nifi.minifi.bootstrap.status.PeriodicStatusReporter;
import org.apache.nifi.minifi.commons.api.MiNiFiProperties;
import org.apache.nifi.minifi.commons.status.FlowStatusReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicStatusReporterManager
implements QueryableStatusAggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodicStatusReporterManager.class);
    private static final String FLOW_STATUS_REPORT_CMD = "FLOW_STATUS_REPORT";
    private final Properties bootstrapProperties;
    private final MiNiFiStatusProvider miNiFiStatusProvider;
    private final MiNiFiCommandSender miNiFiCommandSender;
    private final MiNiFiParameters miNiFiParameters;
    private Set<PeriodicStatusReporter> periodicStatusReporters = Collections.emptySet();

    public PeriodicStatusReporterManager(Properties bootstrapProperties, MiNiFiStatusProvider miNiFiStatusProvider, MiNiFiCommandSender miNiFiCommandSender, MiNiFiParameters miNiFiParameters) {
        this.bootstrapProperties = bootstrapProperties;
        this.miNiFiStatusProvider = miNiFiStatusProvider;
        this.miNiFiCommandSender = miNiFiCommandSender;
        this.miNiFiParameters = miNiFiParameters;
    }

    public void startPeriodicNotifiers() {
        this.periodicStatusReporters = this.initializePeriodicNotifiers();
        for (PeriodicStatusReporter periodicStatusReporter : this.periodicStatusReporters) {
            periodicStatusReporter.start();
            LOGGER.debug("Started {} notifier", (Object)periodicStatusReporter.getClass().getCanonicalName());
        }
    }

    public void shutdownPeriodicStatusReporters() {
        LOGGER.debug("Initiating shutdown of bootstrap periodic status reporters...");
        for (PeriodicStatusReporter periodicStatusReporter : this.periodicStatusReporters) {
            try {
                periodicStatusReporter.stop();
            }
            catch (Exception exception) {
                LOGGER.error("Could not successfully stop periodic status reporter " + String.valueOf(periodicStatusReporter.getClass()) + " due to ", (Throwable)exception);
            }
        }
    }

    @Override
    public FlowStatusReport statusReport(String statusRequest) {
        MiNiFiStatus status = this.miNiFiStatusProvider.getStatus(this.miNiFiParameters.getMiNiFiPort(), this.miNiFiParameters.getMinifiPid());
        LinkedList<String> problemsGeneratingReport = new LinkedList<String>();
        if (!status.isProcessRunning()) {
            problemsGeneratingReport.add("MiNiFi process is not running");
        }
        if (!status.isRespondingToPing()) {
            problemsGeneratingReport.add("MiNiFi process is not responding to pings");
        }
        if (!problemsGeneratingReport.isEmpty()) {
            FlowStatusReport flowStatusReport = new FlowStatusReport();
            flowStatusReport.setErrorsGeneratingReport(problemsGeneratingReport);
            return flowStatusReport;
        }
        return this.getFlowStatusReport(statusRequest, status.getPort());
    }

    private Set<PeriodicStatusReporter> initializePeriodicNotifiers() {
        LOGGER.debug("Initiating bootstrap periodic status reporters...");
        HashSet<PeriodicStatusReporter> statusReporters = new HashSet<PeriodicStatusReporter>();
        String reportersCsv = this.bootstrapProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_STATUS_REPORTER_COMPONENTS.getKey());
        if (reportersCsv != null && !reportersCsv.isEmpty()) {
            for (String reporterClassname : reportersCsv.split(",")) {
                try {
                    Class<?> reporterClass = Class.forName(reporterClassname);
                    PeriodicStatusReporter reporter = (PeriodicStatusReporter)reporterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    reporter.initialize(this.bootstrapProperties, this);
                    statusReporters.add(reporter);
                    LOGGER.debug("Initialized {} notifier", (Object)reporterClass.getCanonicalName());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("Issue instantiating notifier " + reporterClassname, e);
                }
            }
        }
        return statusReporters;
    }

    private FlowStatusReport getFlowStatusReport(String statusRequest, int port) {
        FlowStatusReport flowStatusReport;
        try {
            flowStatusReport = this.miNiFiCommandSender.sendCommandForObject(FLOW_STATUS_REPORT_CMD, port, FlowStatusReport.class, statusRequest);
        }
        catch (Exception e) {
            flowStatusReport = new FlowStatusReport();
            String message = "Failed to get status report from MiNiFi due to:" + e.getMessage();
            flowStatusReport.setErrorsGeneratingReport(Collections.singletonList(message));
            LOGGER.error(message, (Throwable)e);
        }
        return flowStatusReport;
    }
}

