/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;

public class MiNiFiExecCommandProvider {
    public static final String LOG_DIR = "org.apache.nifi.minifi.bootstrap.config.log.dir";
    public static final String DEFAULT_LOG_DIR = "./logs";
    public static final String APP_LOG_FILE_NAME = "org.apache.nifi.minifi.bootstrap.config.log.app.file.name";
    public static final String APP_LOG_FILE_EXTENSION = "org.apache.nifi.minifi.bootstrap.config.log.app.file.extension";
    public static final String BOOTSTRAP_LOG_FILE_NAME = "org.apache.nifi.minifi.bootstrap.config.log.bootstrap.file.name";
    public static final String BOOTSTRAP_LOG_FILE_EXTENSION = "org.apache.nifi.minifi.bootstrap.config.log.bootstrap.file.extension";
    public static final String DEFAULT_APP_LOG_FILE_NAME = "minifi-app";
    public static final String DEFAULT_BOOTSTRAP_LOG_FILE_NAME = "minifi-bootstrap";
    public static final String DEFAULT_LOG_FILE_EXTENSION = "log";
    private static final String PROPERTIES_FILE_KEY = "props.file";
    private static final String LIB_DIR_KEY = "lib.dir";
    private static final String JAVA_COMMAND_KEY = "java";
    private static final String JAVA_ARG_KEY_PREFIX = "java.arg";
    private static final String DEFAULT_JAVA_CMD = "java";
    private static final String DEFAULT_LIB_DIR = "./lib";
    private static final String DEFAULT_CONF_DIR = "./conf";
    private static final String DEFAULT_MINIFI_PROPERTIES_FILE = "minifi.properties";
    private static final String WINDOWS_FILE_EXTENSION = ".exe";
    private static final String LINUX_FILE_EXTENSION = "";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String JAVA_HOME_ENVIRONMENT_VARIABLE = "JAVA_HOME";
    private static final String MINIFI_CLASS_NAME = "MiNiFi";
    private static final String MINIFI_FULLY_QUALIFIED_CLASS_NAME = "org.apache.nifi.minifi.MiNiFi";
    private static final String SYSTEM_PROPERTY_TEMPLATE = "-D%s=%s";
    private static final String NIFI_BOOTSTRAP_LISTEN_PORT = "nifi.bootstrap.listen.port";
    private static final String APP = "app";
    private static final String CLASSPATH = "-classpath";
    private static final String BIN_DIRECTORY = "bin";
    private final BootstrapFileProvider bootstrapFileProvider;

    public MiNiFiExecCommandProvider(BootstrapFileProvider bootstrapFileProvider) {
        this.bootstrapFileProvider = bootstrapFileProvider;
    }

    public static String getMiNiFiPropertiesPath(Properties props, File confDir) {
        return Optional.ofNullable(props.getProperty(PROPERTIES_FILE_KEY)).orElseGet(() -> Optional.ofNullable(confDir).filter(File::exists).map(File::getAbsolutePath).map(parent -> Path.of(parent, DEFAULT_MINIFI_PROPERTIES_FILE).toAbsolutePath().toString()).orElseGet(() -> Path.of(DEFAULT_CONF_DIR, DEFAULT_MINIFI_PROPERTIES_FILE).toAbsolutePath().toString())).trim();
    }

    public List<String> getMiNiFiExecCommand(int listenPort, File workingDir) throws IOException {
        Properties bootstrapProperties = this.bootstrapFileProvider.getBootstrapProperties();
        File confDir = this.getFile(bootstrapProperties.getProperty("conf.dir", DEFAULT_CONF_DIR).trim(), workingDir);
        File libDir = this.getFile(bootstrapProperties.getProperty(LIB_DIR_KEY, DEFAULT_LIB_DIR).trim(), workingDir);
        String minifiLogDir = System.getProperty(LOG_DIR, DEFAULT_LOG_DIR).trim();
        String minifiAppLogFileName = System.getProperty(APP_LOG_FILE_NAME, DEFAULT_APP_LOG_FILE_NAME).trim();
        String minifiAppLogFileExtension = System.getProperty(APP_LOG_FILE_EXTENSION, DEFAULT_LOG_FILE_EXTENSION).trim();
        String minifiBootstrapLogFileName = System.getProperty(BOOTSTRAP_LOG_FILE_NAME, DEFAULT_BOOTSTRAP_LOG_FILE_NAME).trim();
        String minifiBootstrapLogFileExtension = System.getProperty(BOOTSTRAP_LOG_FILE_EXTENSION, DEFAULT_LOG_FILE_EXTENSION).trim();
        List<String> javaCommand = List.of(this.getJavaCommand(bootstrapProperties), CLASSPATH, this.buildClassPath(confDir, libDir));
        List<String> javaAdditionalArgs = this.getJavaAdditionalArgs(bootstrapProperties);
        List<String> systemProperties = List.of(this.systemProperty("nifi.properties.file.path", MiNiFiExecCommandProvider.getMiNiFiPropertiesPath(bootstrapProperties, confDir)), this.systemProperty(NIFI_BOOTSTRAP_LISTEN_PORT, listenPort), this.systemProperty(APP, MINIFI_CLASS_NAME), this.systemProperty(LOG_DIR, minifiLogDir), this.systemProperty(APP_LOG_FILE_NAME, minifiAppLogFileName), this.systemProperty(APP_LOG_FILE_EXTENSION, minifiAppLogFileExtension), this.systemProperty(BOOTSTRAP_LOG_FILE_NAME, minifiBootstrapLogFileName), this.systemProperty(BOOTSTRAP_LOG_FILE_EXTENSION, minifiBootstrapLogFileExtension));
        return List.of(javaCommand, javaAdditionalArgs, systemProperties, List.of(MINIFI_FULLY_QUALIFIED_CLASS_NAME)).stream().flatMap(Collection::stream).toList();
    }

    private File getFile(String filename, File workingDir) {
        File file = new File(filename);
        return file.isAbsolute() ? file : new File(workingDir, filename).getAbsoluteFile();
    }

    private String getJavaCommand(Properties bootstrapProperties) {
        String javaCommand = bootstrapProperties.getProperty("java", "java");
        return javaCommand.equals("java") ? Optional.ofNullable(System.getenv(JAVA_HOME_ENVIRONMENT_VARIABLE)).flatMap(javaHome -> this.getJavaCommandBasedOnExtension((String)javaHome, javaCommand, WINDOWS_FILE_EXTENSION).or(() -> this.getJavaCommandBasedOnExtension((String)javaHome, javaCommand, LINUX_FILE_EXTENSION))).orElse("java") : javaCommand;
    }

    private Optional<String> getJavaCommandBasedOnExtension(String javaHome, String javaCommand, String extension) {
        return Optional.of(new File(String.join((CharSequence)File.separator, javaHome, BIN_DIRECTORY, javaCommand + extension))).filter(File::exists).filter(File::canExecute).map(File::getAbsolutePath);
    }

    private String buildClassPath(File confDir, File libDir) {
        File[] libFiles = Optional.ofNullable(libDir.listFiles((dir, filename) -> filename.toLowerCase().endsWith(JAR_FILE_EXTENSION))).filter(files -> ((File[])files).length > 0).orElseThrow(() -> new RuntimeException("Could not find lib directory at " + libDir.getAbsolutePath()));
        Optional.ofNullable(confDir.listFiles()).filter(files -> ((File[])files).length > 0).orElseThrow(() -> new RuntimeException("Could not find conf directory at " + confDir.getAbsolutePath()));
        return Stream.concat(Stream.of(confDir), Stream.of(libFiles)).map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
    }

    private List<String> getJavaAdditionalArgs(Properties props) {
        return props.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(JAVA_ARG_KEY_PREFIX)).map(entry -> (String)entry.getValue()).toList();
    }

    private String systemProperty(String key, Object value) {
        return String.format(SYSTEM_PROPERTY_TEMPLATE, key, value);
    }
}

