/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.configuration.ingestors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.Provider;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.jetty.configuration.connector.StandardServerConnectorFactory;
import org.apache.nifi.minifi.bootstrap.ConfigurationFileHolder;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeNotifier;
import org.apache.nifi.minifi.bootstrap.configuration.ListenerHandleResult;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.Differentiator;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.WholeConfigDifferentiator;
import org.apache.nifi.minifi.bootstrap.configuration.ingestors.interfaces.ChangeIngestor;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardSslContextBuilder;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.security.util.TlsPlatform;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestChangeIngestor
implements ChangeIngestor {
    public static final String GET_TEXT = "This is a config change listener for an Apache NiFi - MiNiFi instance.\nUse this rest server to upload a flow.json to configure the MiNiFi instance.\nSend a POST http request to '/' to upload the file.";
    public static final String OTHER_TEXT = "This is not a supported HTTP operation. Please use GET to get more information or POST to upload a new flow.json file.\n";
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String RECEIVE_HTTP_BASE_KEY = "nifi.minifi.notifier.ingestors.receive.http";
    public static final String PORT_KEY = "nifi.minifi.notifier.ingestors.receive.http.port";
    public static final String HOST_KEY = "nifi.minifi.notifier.ingestors.receive.http.host";
    public static final String TRUSTSTORE_LOCATION_KEY = "nifi.minifi.notifier.ingestors.receive.http.truststore.location";
    public static final String TRUSTSTORE_PASSWORD_KEY = "nifi.minifi.notifier.ingestors.receive.http.truststore.password";
    public static final String TRUSTSTORE_TYPE_KEY = "nifi.minifi.notifier.ingestors.receive.http.truststore.type";
    public static final String KEYSTORE_LOCATION_KEY = "nifi.minifi.notifier.ingestors.receive.http.keystore.location";
    public static final String KEYSTORE_PASSWORD_KEY = "nifi.minifi.notifier.ingestors.receive.http.keystore.password";
    public static final String KEYSTORE_TYPE_KEY = "nifi.minifi.notifier.ingestors.receive.http.keystore.type";
    public static final String NEED_CLIENT_AUTH_KEY = "nifi.minifi.notifier.ingestors.receive.http.need.client.auth";
    public static final String DIFFERENTIATOR_KEY = "nifi.minifi.notifier.ingestors.receive.http.differentiator";
    private static final Logger logger = LoggerFactory.getLogger(RestChangeIngestor.class);
    private static final BouncyCastleProvider BOUNCY_CASTLE_PROVIDER = new BouncyCastleProvider();
    private static final Map<String, Supplier<Differentiator<ByteBuffer>>> DIFFERENTIATOR_CONSTRUCTOR_MAP = Map.of("Whole Config", WholeConfigDifferentiator::getByteBufferDifferentiator);
    private final Server jetty;
    private volatile Differentiator<ByteBuffer> differentiator;
    private volatile ConfigurationChangeNotifier configurationChangeNotifier;

    public RestChangeIngestor() {
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool();
        queuedThreadPool.setDaemon(true);
        this.jetty = new Server((ThreadPool)queuedThreadPool);
    }

    @Override
    public void initialize(Properties properties, ConfigurationFileHolder configurationFileHolder, ConfigurationChangeNotifier configurationChangeNotifier) {
        logger.info("Initializing RestChangeIngestor");
        this.differentiator = Optional.ofNullable(properties.getProperty(DIFFERENTIATOR_KEY)).filter(Predicate.not(String::isBlank)).map(differentiator -> Optional.ofNullable(DIFFERENTIATOR_CONSTRUCTOR_MAP.get(differentiator)).map(Supplier::get).orElseThrow(this.unableToFindDifferentiatorExceptionSupplier((String)differentiator))).orElseGet(WholeConfigDifferentiator::getByteBufferDifferentiator);
        this.differentiator.initialize(configurationFileHolder);
        Optional.ofNullable(properties.getProperty(KEYSTORE_LOCATION_KEY)).ifPresentOrElse(keyStoreLocation -> this.createSecureConnector(properties), () -> this.createConnector(properties));
        this.configurationChangeNotifier = configurationChangeNotifier;
        HandlerCollection handlerCollection = new HandlerCollection(true, new Handler[0]);
        handlerCollection.addHandler((Handler)new JettyHandler());
        this.jetty.setHandler((Handler)handlerCollection);
    }

    @Override
    public void start() {
        try {
            this.jetty.start();
            logger.info("RestChangeIngester has started and is listening on port {}.", (Object)this.getPort());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() throws IOException {
        logger.warn("Shutting down the jetty server");
        try {
            this.jetty.stop();
            this.jetty.destroy();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        logger.warn("Done shutting down the jetty server");
    }

    public URI getURI() {
        return this.jetty.getURI();
    }

    public int getPort() {
        if (!this.jetty.isStarted()) {
            throw new IllegalStateException("Jetty server not started");
        }
        return ((ServerConnector)this.jetty.getConnectors()[0]).getLocalPort();
    }

    private void createConnector(Properties properties) {
        ServerConnector http = new ServerConnector(this.jetty);
        http.setPort(Integer.parseInt(properties.getProperty(PORT_KEY, "0")));
        http.setHost(properties.getProperty(HOST_KEY, "localhost"));
        http.setIdleTimeout(30000L);
        this.jetty.addConnector((Connector)http);
        logger.info("Added an http connector on the host '{}' and port '{}'", (Object)http.getHost(), (Object)http.getPort());
    }

    private void createSecureConnector(Properties properties) {
        KeyStore keyStore;
        StandardKeyStoreBuilder builder;
        KeyStore trustStore = null;
        try (FileInputStream keyStoreStream = new FileInputStream(properties.getProperty(KEYSTORE_LOCATION_KEY));){
            String keyStoreType = properties.getProperty(KEYSTORE_TYPE_KEY);
            builder = new StandardKeyStoreBuilder().type(keyStoreType).inputStream((InputStream)keyStoreStream).password(properties.getProperty(KEYSTORE_PASSWORD_KEY).toCharArray());
            if (KeystoreType.BCFKS.getType().equals(keyStoreType)) {
                builder.provider((Provider)BOUNCY_CASTLE_PROVIDER);
            }
            keyStore = builder.build();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Key Store loading failed", ioe);
        }
        if (properties.getProperty(TRUSTSTORE_LOCATION_KEY) != null) {
            String trustStoreType = properties.getProperty(TRUSTSTORE_TYPE_KEY);
            try (FileInputStream trustStoreStream = new FileInputStream(properties.getProperty(TRUSTSTORE_LOCATION_KEY));){
                builder = new StandardKeyStoreBuilder().type(trustStoreType).inputStream((InputStream)trustStoreStream).password(properties.getProperty(TRUSTSTORE_PASSWORD_KEY).toCharArray());
                if (KeystoreType.BCFKS.getType().equals(trustStoreType)) {
                    builder.provider((Provider)BOUNCY_CASTLE_PROVIDER);
                }
                trustStore = builder.build();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("Trust Store loading failed", ioe);
            }
        }
        SSLContext sslContext = new StandardSslContextBuilder().keyStore(keyStore).keyPassword(properties.getProperty(KEYSTORE_PASSWORD_KEY).toCharArray()).trustStore(trustStore).build();
        StandardServerConnectorFactory serverConnectorFactory = new StandardServerConnectorFactory(this.jetty, Integer.parseInt(properties.getProperty(PORT_KEY, "0")));
        serverConnectorFactory.setNeedClientAuth(Boolean.parseBoolean(properties.getProperty(NEED_CLIENT_AUTH_KEY, "true")));
        serverConnectorFactory.setSslContext(sslContext);
        serverConnectorFactory.setIncludeSecurityProtocols(TlsPlatform.getPreferredProtocols().toArray(new String[0]));
        ServerConnector https = serverConnectorFactory.getServerConnector();
        https.setHost(properties.getProperty(HOST_KEY, "localhost"));
        this.jetty.addConnector((Connector)https);
        logger.info("HTTPS Connector added for Host [{}] and Port [{}]", (Object)https.getHost(), (Object)https.getPort());
    }

    private Supplier<IllegalArgumentException> unableToFindDifferentiatorExceptionSupplier(String differentiator) {
        return () -> new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.receive.http.differentiator, has value " + differentiator + " which does not correspond to any in the FileChangeIngestor Map:" + String.valueOf(DIFFERENTIATOR_CONSTRUCTOR_MAP.keySet()));
    }

    void setDifferentiator(Differentiator<ByteBuffer> differentiator) {
        this.differentiator = differentiator;
    }

    private class JettyHandler
    extends AbstractHandler {
        private JettyHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.logRequest(request);
            baseRequest.setHandled(true);
            if (RestChangeIngestor.POST.equals(request.getMethod())) {
                String responseText;
                int statusCode;
                try {
                    ByteBuffer newFlowConfig = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)request.getInputStream())).duplicate();
                    if (RestChangeIngestor.this.differentiator.isNew(newFlowConfig)) {
                        Collection<ListenerHandleResult> listenerHandleResults = RestChangeIngestor.this.configurationChangeNotifier.notifyListeners(newFlowConfig);
                        statusCode = 200;
                        for (ListenerHandleResult result : listenerHandleResults) {
                            if (result.succeeded()) continue;
                            statusCode = 500;
                            break;
                        }
                        responseText = this.getPostText(listenerHandleResults);
                    } else {
                        statusCode = 409;
                        responseText = "Request received but instance is already running this config.";
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to override config file", (Throwable)e);
                    statusCode = 500;
                    responseText = "Failed to override config file";
                }
                this.writeOutput(response, responseText, statusCode);
            } else if (RestChangeIngestor.GET.equals(request.getMethod())) {
                this.writeOutput(response, RestChangeIngestor.GET_TEXT, 200);
            } else {
                this.writeOutput(response, RestChangeIngestor.OTHER_TEXT, 404);
            }
        }

        private String getPostText(Collection<ListenerHandleResult> listenerHandleResults) {
            StringBuilder postResult = new StringBuilder("The result of notifying listeners:\n");
            for (ListenerHandleResult result : listenerHandleResults) {
                postResult.append(result.toString());
                postResult.append("\n");
            }
            return postResult.toString();
        }

        private void writeOutput(HttpServletResponse response, String responseText, int responseCode) throws IOException {
            response.setStatus(responseCode);
            response.setContentType("text/plain");
            response.setContentLength(responseText.length());
            try (PrintWriter writer = response.getWriter();){
                writer.print(responseText);
                writer.flush();
            }
        }

        private void logRequest(HttpServletRequest request) {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.info("request method = " + request.getMethod());
            logger.info("request url = " + String.valueOf(request.getRequestURL()));
            logger.info("context path = " + request.getContextPath());
            logger.info("request content type = " + request.getContentType());
            logger.info("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        }
    }
}

