/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.configuration.ingestors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.minifi.bootstrap.ConfigurationFileHolder;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeNotifier;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.Differentiator;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.WholeConfigDifferentiator;
import org.apache.nifi.minifi.bootstrap.configuration.ingestors.AbstractPullChangeIngestor;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardSslContextBuilder;
import org.apache.nifi.security.ssl.StandardTrustManagerBuilder;
import org.eclipse.jetty.http.HttpScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullHttpChangeIngestor
extends AbstractPullChangeIngestor {
    public static final String PULL_HTTP_BASE_KEY = "nifi.minifi.notifier.ingestors.pull.http";
    public static final String PULL_HTTP_POLLING_PERIOD_KEY = "nifi.minifi.notifier.ingestors.pull.http.period.ms";
    public static final String PORT_KEY = "nifi.minifi.notifier.ingestors.pull.http.port";
    public static final String HOST_KEY = "nifi.minifi.notifier.ingestors.pull.http.hostname";
    public static final String PATH_KEY = "nifi.minifi.notifier.ingestors.pull.http.path";
    public static final String QUERY_KEY = "nifi.minifi.notifier.ingestors.pull.http.query";
    public static final String PROXY_HOST_KEY = "nifi.minifi.notifier.ingestors.pull.http.proxy.hostname";
    public static final String PROXY_PORT_KEY = "nifi.minifi.notifier.ingestors.pull.http.proxy.port";
    public static final String PROXY_USERNAME = "nifi.minifi.notifier.ingestors.pull.http.proxy.username";
    public static final String PROXY_PASSWORD = "nifi.minifi.notifier.ingestors.pull.http.proxy.password";
    public static final String TRUSTSTORE_LOCATION_KEY = "nifi.minifi.notifier.ingestors.pull.http.truststore.location";
    public static final String TRUSTSTORE_PASSWORD_KEY = "nifi.minifi.notifier.ingestors.pull.http.truststore.password";
    public static final String TRUSTSTORE_TYPE_KEY = "nifi.minifi.notifier.ingestors.pull.http.truststore.type";
    public static final String KEYSTORE_LOCATION_KEY = "nifi.minifi.notifier.ingestors.pull.http.keystore.location";
    public static final String KEYSTORE_PASSWORD_KEY = "nifi.minifi.notifier.ingestors.pull.http.keystore.password";
    public static final String KEYSTORE_TYPE_KEY = "nifi.minifi.notifier.ingestors.pull.http.keystore.type";
    public static final String CONNECT_TIMEOUT_KEY = "nifi.minifi.notifier.ingestors.pull.http.connect.timeout.ms";
    public static final String READ_TIMEOUT_KEY = "nifi.minifi.notifier.ingestors.pull.http.read.timeout.ms";
    public static final String DIFFERENTIATOR_KEY = "nifi.minifi.notifier.ingestors.pull.http.differentiator";
    public static final String USE_ETAG_KEY = "nifi.minifi.notifier.ingestors.pull.http.use.etag";
    public static final String OVERRIDE_SECURITY = "nifi.minifi.notifier.ingestors.pull.http.override.security";
    public static final String HTTP_HEADERS = "nifi.minifi.notifier.ingestors.pull.http.headers";
    private static final Logger logger = LoggerFactory.getLogger(PullHttpChangeIngestor.class);
    private static final Map<String, Supplier<Differentiator<ByteBuffer>>> DIFFERENTIATOR_CONSTRUCTOR_MAP = Map.of("Whole Config", WholeConfigDifferentiator::getByteBufferDifferentiator);
    private static final int NOT_MODIFIED_STATUS_CODE = 304;
    private static final String DEFAULT_CONNECT_TIMEOUT_MS = "5000";
    private static final String DEFAULT_READ_TIMEOUT_MS = "15000";
    private static final String DOUBLE_QUOTES = "\"";
    private static final String ETAG_HEADER = "ETag";
    private static final String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";
    private static final String DEFAULT_PATH = "/";
    private static final int BAD_REQUEST_STATUS_CODE = 400;
    private static final String IF_NONE_MATCH_HEADER_KEY = "If-None-Match";
    private static final String HTTP_HEADERS_SEPARATOR = ",";
    private static final String HTTP_HEADER_KEY_VALUE_SEPARATOR = ":";
    private final AtomicReference<OkHttpClient> httpClientReference = new AtomicReference();
    private final AtomicReference<Integer> portReference = new AtomicReference();
    private final AtomicReference<String> hostReference = new AtomicReference();
    private final AtomicReference<String> pathReference = new AtomicReference();
    private final AtomicReference<String> queryReference = new AtomicReference();
    private final AtomicReference<Map<String, String>> httpHeadersReference = new AtomicReference();
    private volatile Differentiator<ByteBuffer> differentiator;
    private volatile String connectionScheme;
    private volatile String lastEtag = "";
    private volatile boolean useEtag = false;

    @Override
    public void initialize(Properties properties, ConfigurationFileHolder configurationFileHolder, ConfigurationChangeNotifier configurationChangeNotifier) {
        super.initialize(properties, configurationFileHolder, configurationChangeNotifier);
        this.pollingPeriodMS.set(Integer.parseInt(properties.getProperty(PULL_HTTP_POLLING_PERIOD_KEY, "300000")));
        if (this.pollingPeriodMS.get() < 1) {
            throw new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.pull.http.period.ms, for the polling period ms must be set with a positive integer");
        }
        String host = Optional.ofNullable(properties.getProperty(HOST_KEY)).filter(StringUtils::isNotBlank).orElseThrow(() -> new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.pull.http.hostname, for the hostname to pull configurations from must be specified"));
        String path = properties.getProperty(PATH_KEY, DEFAULT_PATH);
        String query = properties.getProperty(QUERY_KEY, "");
        Map<String, String> httpHeaders = Optional.ofNullable(properties.getProperty(HTTP_HEADERS)).filter(StringUtils::isNotBlank).map(headers -> headers.split(HTTP_HEADERS_SEPARATOR)).stream().flatMap(Arrays::stream).map(String::trim).map(header -> header.split(HTTP_HEADER_KEY_VALUE_SEPARATOR)).filter(split -> ((String[])split).length == 2).collect(Collectors.toMap(split -> Optional.ofNullable(split[0]).map(String::trim).orElse(""), split -> Optional.ofNullable(split[1]).map(String::trim).orElse("")));
        logger.debug("Configured HTTP headers: {}", httpHeaders);
        Optional.ofNullable(properties.get(PORT_KEY)).map(String.class::cast).map(Integer::parseInt).ifPresentOrElse(this.portReference::set, () -> {
            throw new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.pull.http.port, for the hostname to pull configurations from must be specified");
        });
        this.hostReference.set(host);
        this.pathReference.set(path);
        this.queryReference.set(query);
        this.httpHeadersReference.set(httpHeaders);
        this.useEtag = Boolean.parseBoolean((String)properties.getOrDefault((Object)USE_ETAG_KEY, Boolean.FALSE.toString()));
        this.httpClientReference.set(null);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().connectTimeout(Long.parseLong(properties.getProperty(CONNECT_TIMEOUT_KEY, DEFAULT_CONNECT_TIMEOUT_MS)), TimeUnit.MILLISECONDS).readTimeout(Long.parseLong(properties.getProperty(READ_TIMEOUT_KEY, DEFAULT_READ_TIMEOUT_MS)), TimeUnit.MILLISECONDS).followRedirects(true);
        String proxyHost = properties.getProperty(PROXY_HOST_KEY);
        if (StringUtils.isNotBlank((CharSequence)proxyHost)) {
            Optional.ofNullable(properties.getProperty(PROXY_PORT_KEY)).filter(StringUtils::isNotBlank).map(Integer::parseInt).map(port -> new InetSocketAddress(proxyHost, (int)port)).map(inetSocketAddress -> new Proxy(Proxy.Type.HTTP, (SocketAddress)inetSocketAddress)).ifPresentOrElse(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).proxy(arg_0), () -> {
                throw new IllegalArgumentException("Proxy port required if proxy specified");
            });
            Optional.ofNullable(properties.getProperty(PROXY_USERNAME)).filter(StringUtils::isNotBlank).ifPresent(proxyUserName -> Optional.ofNullable(properties.getProperty(PROXY_PASSWORD)).map(proxyPassword -> Credentials.basic((String)proxyUserName, (String)proxyPassword)).map(credentials -> (route, response) -> response.request().newBuilder().addHeader(PROXY_AUTHORIZATION_HEADER, credentials).build()).ifPresentOrElse(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).proxyAuthenticator(arg_0), () -> {
                throw new IllegalArgumentException("Must specify proxy password with proxy username");
            }));
        }
        if (properties.containsKey(KEYSTORE_LOCATION_KEY)) {
            this.connectionScheme = HttpScheme.HTTPS.toString();
            this.setSslSocketFactory(okHttpClientBuilder, properties);
        } else {
            this.connectionScheme = HttpScheme.HTTP.toString();
        }
        this.httpClientReference.set(okHttpClientBuilder.build());
        this.differentiator = Optional.ofNullable(properties.getProperty(DIFFERENTIATOR_KEY)).filter(Predicate.not(String::isBlank)).map(differentiator -> Optional.ofNullable(DIFFERENTIATOR_CONSTRUCTOR_MAP.get(differentiator)).map(Supplier::get).orElseThrow(this.unableToFindDifferentiatorExceptionSupplier((String)differentiator))).orElseGet(WholeConfigDifferentiator::getByteBufferDifferentiator);
        this.differentiator.initialize(configurationFileHolder);
    }

    @Override
    public void run() {
        logger.debug("Attempting to pull new config");
        HttpUrl.Builder builder = new HttpUrl.Builder().host(this.hostReference.get()).port(this.portReference.get().intValue()).encodedPath(this.pathReference.get());
        Optional.ofNullable(this.queryReference.get()).filter(StringUtils::isNotBlank).ifPresent(arg_0 -> ((HttpUrl.Builder)builder).encodedQuery(arg_0));
        HttpUrl url = builder.scheme(this.connectionScheme).build();
        Request.Builder requestBuilder = new Request.Builder().get().url(url);
        if (this.useEtag) {
            requestBuilder.addHeader(IF_NONE_MATCH_HEADER_KEY, this.lastEtag);
        }
        this.httpHeadersReference.get().forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        Request request = requestBuilder.build();
        logger.debug("Sending request: {}", (Object)request);
        try (Response response = this.httpClientReference.get().newCall(request).execute();){
            logger.debug("Response received: {}", (Object)response);
            int code = response.code();
            if (code == 304) {
                return;
            }
            if (code >= 400) {
                throw new IOException("Got response code " + code + " while trying to pull configuration: " + response.body().string());
            }
            ResponseBody body = response.body();
            if (body == null) {
                logger.warn("No body returned when pulling a new configuration");
                return;
            }
            ByteBuffer newFlowConfig = ByteBuffer.wrap(body.bytes()).duplicate();
            if (this.differentiator.isNew(newFlowConfig)) {
                logger.debug("New change received, notifying listener");
                this.configurationChangeNotifier.notifyListeners(newFlowConfig);
                logger.debug("Listeners notified");
            } else {
                logger.debug("Pulled config same as currently running");
            }
            if (this.useEtag) {
                this.lastEtag = Stream.of(DOUBLE_QUOTES, response.header(ETAG_HEADER).trim(), DOUBLE_QUOTES).collect(Collectors.joining());
            }
        }
        catch (Exception e) {
            logger.warn("Hit an exception while trying to pull", (Throwable)e);
        }
    }

    private void setSslSocketFactory(OkHttpClient.Builder okHttpClientBuilder, Properties properties) {
        String keystorePass = properties.getProperty(KEYSTORE_PASSWORD_KEY);
        KeyStore keyStore = this.buildKeyStore(properties, KEYSTORE_LOCATION_KEY, KEYSTORE_PASSWORD_KEY, KEYSTORE_TYPE_KEY);
        KeyStore truststore = this.buildKeyStore(properties, TRUSTSTORE_LOCATION_KEY, TRUSTSTORE_PASSWORD_KEY, TRUSTSTORE_TYPE_KEY);
        SSLSocketFactory sslSocketFactory = new StandardSslContextBuilder().keyStore(keyStore).keyPassword(keystorePass.toCharArray()).trustStore(truststore).build().getSocketFactory();
        X509TrustManager trustManager = new StandardTrustManagerBuilder().trustStore(truststore).build();
        okHttpClientBuilder.sslSocketFactory(sslSocketFactory, trustManager);
    }

    private KeyStore buildKeyStore(Properties properties, String locationKey, String passKey, String typeKey) {
        KeyStore keyStore;
        String keystoreLocation = Optional.ofNullable(properties.getProperty(locationKey)).filter(StringUtils::isNotBlank).orElseThrow(() -> new IllegalArgumentException(locationKey + " is null or empty"));
        String keystorePass = Optional.ofNullable(properties.getProperty(passKey)).filter(StringUtils::isNotBlank).orElseThrow(() -> new IllegalArgumentException(passKey + " is null or empty"));
        String keystoreType = Optional.ofNullable(properties.getProperty(typeKey)).filter(StringUtils::isNotBlank).orElseThrow(() -> new IllegalArgumentException(typeKey + " is null or empty"));
        FileInputStream keyStoreStream = new FileInputStream(keystoreLocation);
        try {
            keyStore = new StandardKeyStoreBuilder().type(keystoreType).inputStream((InputStream)keyStoreStream).password(keystorePass.toCharArray()).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    keyStoreStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create keyStore", e);
            }
        }
        keyStoreStream.close();
        return keyStore;
    }

    private Supplier<IllegalArgumentException> unableToFindDifferentiatorExceptionSupplier(String differentiator) {
        return () -> new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.pull.http.differentiator, has value " + differentiator + " which does not correspond to any in the FileChangeIngestor Map:" + String.valueOf(DIFFERENTIATOR_CONSTRUCTOR_MAP.keySet()));
    }

    void setDifferentiator(Differentiator<ByteBuffer> differentiator) {
        this.differentiator = differentiator;
    }

    void setLastEtag(String lastEtag) {
        this.lastEtag = lastEtag;
    }

    void setUseEtag(boolean useEtag) {
        this.useEtag = useEtag;
    }
}

