/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.configuration.ingestors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.minifi.bootstrap.ConfigurationFileHolder;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeNotifier;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.Differentiator;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.WholeConfigDifferentiator;
import org.apache.nifi.minifi.bootstrap.configuration.ingestors.interfaces.ChangeIngestor;
import org.apache.nifi.minifi.commons.api.MiNiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangeIngestor
implements Runnable,
ChangeIngestor {
    private static final Map<String, Supplier<Differentiator<ByteBuffer>>> DIFFERENTIATOR_CONSTRUCTOR_MAP = Map.of("Whole Config", WholeConfigDifferentiator::getByteBufferDifferentiator);
    static final String CONFIG_FILE_BASE_KEY = "nifi.minifi.notifier.ingestors.file";
    static final String CONFIG_FILE_PATH_KEY = "nifi.minifi.notifier.ingestors.file.config.path";
    static final String POLLING_PERIOD_INTERVAL_KEY = "nifi.minifi.notifier.ingestors.file.polling.period.seconds";
    static final int DEFAULT_POLLING_PERIOD_INTERVAL = 15;
    private static final Logger logger = LoggerFactory.getLogger(FileChangeIngestor.class);
    private static final TimeUnit DEFAULT_POLLING_PERIOD_UNIT = TimeUnit.SECONDS;
    private static final String DIFFERENTIATOR_KEY = "nifi.minifi.notifier.ingestors.file.differentiator";
    private volatile Differentiator<ByteBuffer> differentiator;
    private volatile ConfigurationChangeNotifier configurationChangeNotifier;
    private ScheduledExecutorService executorService;
    private Path configFilePath;
    private WatchService watchService;
    private long pollingSeconds;

    @Override
    public void initialize(Properties properties, ConfigurationFileHolder configurationFileHolder, ConfigurationChangeNotifier configurationChangeNotifier) {
        Path configFile = Optional.ofNullable(properties.getProperty(CONFIG_FILE_PATH_KEY)).filter(Predicate.not(String::isBlank)).map(x$0 -> Path.of(x$0, new String[0])).map(Path::toAbsolutePath).orElseThrow(() -> new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.file.config.path, for the path of the config file must be specified"));
        try {
            this.configurationChangeNotifier = configurationChangeNotifier;
            this.configFilePath = configFile;
            this.pollingSeconds = Optional.ofNullable(properties.getProperty(POLLING_PERIOD_INTERVAL_KEY, Long.toString(15L))).map(Long::parseLong).filter(duration -> duration > 0L).map(duration -> TimeUnit.SECONDS.convert((long)duration, DEFAULT_POLLING_PERIOD_UNIT)).orElseThrow(() -> new IllegalArgumentException("Cannot specify a polling period with duration <=0"));
            this.watchService = this.initializeWatcher(configFile);
            this.differentiator = Optional.ofNullable(properties.getProperty(DIFFERENTIATOR_KEY)).filter(Predicate.not(String::isBlank)).map(differentiator -> Optional.ofNullable(DIFFERENTIATOR_CONSTRUCTOR_MAP.get(differentiator)).map(Supplier::get).orElseThrow(this.unableToFindDifferentiatorExceptionSupplier((String)differentiator))).orElseGet(WholeConfigDifferentiator::getByteBufferDifferentiator);
            this.differentiator.initialize(configurationFileHolder);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not successfully initialize file change notifier", e);
        }
        this.checkConfigFileLocationCorrectness(properties, configFile);
    }

    @Override
    public void start() {
        this.executorService = Executors.newScheduledThreadPool(1, runnable -> {
            Thread notifierThread = Executors.defaultThreadFactory().newThread(runnable);
            notifierThread.setName("File Change Notifier Thread");
            notifierThread.setDaemon(true);
            return notifierThread;
        });
        this.executorService.scheduleWithFixedDelay(this, 0L, this.pollingSeconds, DEFAULT_POLLING_PERIOD_UNIT);
    }

    @Override
    public void run() {
        logger.debug("Checking for a change in {}", (Object)this.configFilePath);
        if (this.targetFileChanged()) {
            logger.debug("Target file changed, checking if it's different than current flow");
            try (FileInputStream flowCandidateInputStream = new FileInputStream(this.configFilePath.toFile());){
                ByteBuffer newFlowConfig = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)flowCandidateInputStream));
                if (this.differentiator.isNew(newFlowConfig)) {
                    logger.debug("Current flow and new flow is different, notifying listener");
                    this.configurationChangeNotifier.notifyListeners(newFlowConfig);
                    logger.debug("Listeners have been notified");
                }
            }
            catch (Exception e) {
                logger.error("Could not successfully notify listeners.", (Throwable)e);
            }
        } else {
            logger.debug("No change detected in {}", (Object)this.configFilePath);
        }
    }

    @Override
    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    boolean targetFileChanged() {
        logger.trace("Attempting to acquire watch key");
        Optional<WatchKey> watchKey = Optional.ofNullable(this.watchService.poll());
        logger.trace("Watch key acquire with value {}", watchKey);
        boolean targetChanged = watchKey.map(WatchKey::pollEvents).orElse(Collections.emptyList()).stream().anyMatch(watchEvent -> StandardWatchEventKinds.ENTRY_MODIFY == watchEvent.kind() && ((Path)watchEvent.context()).equals(this.configFilePath.getName(this.configFilePath.getNameCount() - 1)));
        logger.debug("Target file changed: {}", (Object)targetChanged);
        watchKey.map(WatchKey::reset).filter(valid -> valid == false).ifPresent(valid -> {
            logger.error("Unable to reinitialize file system watcher.");
            throw new IllegalStateException("Unable to reinitialize file system watcher.");
        });
        logger.trace("Watch key has been reset successfully");
        return targetChanged;
    }

    private WatchService initializeWatcher(Path filePath) {
        try {
            WatchService fileSystemWatcher = FileSystems.getDefault().newWatchService();
            Path watchDirectory = filePath.getParent();
            watchDirectory.register(fileSystemWatcher, StandardWatchEventKinds.ENTRY_MODIFY);
            logger.trace("Watch service registered for {}", (Object)watchDirectory);
            return fileSystemWatcher;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to initialize a file system watcher for the path " + String.valueOf(filePath), ioe);
        }
    }

    private Supplier<IllegalArgumentException> unableToFindDifferentiatorExceptionSupplier(String differentiator) {
        return () -> new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.file.differentiator, has value " + differentiator + " which does not correspond to any in the FileChangeIngestor Map:" + String.valueOf(DIFFERENTIATOR_CONSTRUCTOR_MAP.keySet()));
    }

    private void checkConfigFileLocationCorrectness(Properties properties, Path configFile) {
        Path flowConfigFile = Path.of(properties.getProperty(MiNiFiProperties.NIFI_MINIFI_FLOW_CONFIG.getKey()), new String[0]).toAbsolutePath();
        Path rawFlowConfigFile = flowConfigFile.getParent().resolve(FilenameUtils.getBaseName((String)flowConfigFile.toString()) + ".raw");
        if (flowConfigFile.equals(configFile) || rawFlowConfigFile.equals(configFile)) {
            throw new IllegalStateException("File ingestor config file (nifi.minifi.notifier.ingestors.file.config.path) must point to a different file than MiNiFi flow config file and raw flow config file");
        }
    }

    void setConfigFilePath(Path configFilePath) {
        this.configFilePath = configFilePath;
    }

    void setWatchService(WatchService watchService) {
        this.watchService = watchService;
    }

    void setConfigurationChangeNotifier(ConfigurationChangeNotifier configurationChangeNotifier) {
        this.configurationChangeNotifier = configurationChangeNotifier;
    }

    void setDifferentiator(Differentiator<ByteBuffer> differentiator) {
        this.differentiator = differentiator;
    }
}

