/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDescendingRecordListCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntList;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;

class LatestByAllRecordCursor
extends AbstractDescendingRecordListCursor
implements Plannable {
    private final Map map;
    private final RecordSink recordSink;

    public LatestByAllRecordCursor(Map map, DirectLongList rows, RecordSink recordSink, @NotNull IntList columnIndexes) {
        super(rows, columnIndexes);
        this.map = map;
        this.recordSink = recordSink;
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.map.close();
            super.close();
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Row backward scan");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void buildTreeMap(SqlExecutionContext executionContext) {
        SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
        if (!this.isOpen()) {
            this.map.reopen();
        }
        try {
            DataFrame frame;
            while ((frame = this.dataFrameCursor.next()) != null) {
                int partitionIndex = frame.getPartitionIndex();
                long rowLo = frame.getRowLo();
                long rowHi = frame.getRowHi() - 1L;
                this.recordA.jumpTo(frame.getPartitionIndex(), rowHi);
                for (long row = rowHi; row >= rowLo; --row) {
                    circuitBreaker.statefulThrowExceptionIfTripped();
                    this.recordA.setRecordIndex(row);
                    MapKey key = this.map.withKey();
                    key.put(this.recordA, this.recordSink);
                    if (!key.create()) continue;
                    this.rows.add(Rows.toRowID(partitionIndex, row));
                }
            }
        }
        finally {
            this.map.clear();
        }
    }
}

