/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.swap;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.swap.SwapSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SimpleSwapSerializer
implements SwapSerializer {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSwapSerializer.class);
    public static final int SWAP_ENCODING_VERSION = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeFlowFiles(List<FlowFileRecord> toSwap, FlowFileQueue queue, String swapLocation, OutputStream destination) throws IOException {
        if (toSwap == null || toSwap.isEmpty()) {
            return;
        }
        long contentSize = 0L;
        for (FlowFileRecord record : toSwap) {
            contentSize += record.getSize();
        }
        DataOutputStream out = new DataOutputStream(destination);
        try {
            out.writeInt(10);
            out.writeUTF(queue.getIdentifier());
            out.writeInt(toSwap.size());
            out.writeLong(contentSize);
            long maxRecordId = 0L;
            for (FlowFileRecord flowFile : toSwap) {
                if (flowFile.getId() <= maxRecordId) continue;
                maxRecordId = flowFile.getId();
            }
            out.writeLong(maxRecordId);
            for (FlowFileRecord flowFile : toSwap) {
                out.writeLong(flowFile.getId());
                out.writeLong(flowFile.getEntryDate());
                out.writeLong(flowFile.getLineageStartDate());
                out.writeLong(flowFile.getLineageStartIndex());
                out.writeLong(flowFile.getLastQueueDate());
                out.writeLong(flowFile.getQueueDateIndex());
                out.writeLong(flowFile.getSize());
                ContentClaim claim = flowFile.getContentClaim();
                if (claim == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    ResourceClaim resourceClaim = claim.getResourceClaim();
                    out.writeUTF(resourceClaim.getId());
                    out.writeUTF(resourceClaim.getContainer());
                    out.writeUTF(resourceClaim.getSection());
                    out.writeLong(claim.getOffset());
                    out.writeLong(claim.getLength());
                    out.writeLong(flowFile.getContentClaimOffset());
                    out.writeBoolean(resourceClaim.isLossTolerant());
                }
                Map attributes = flowFile.getAttributes();
                out.writeInt(attributes.size());
                for (Map.Entry entry : attributes.entrySet()) {
                    this.writeString((String)entry.getKey(), out);
                    this.writeString((String)entry.getValue(), out);
                }
            }
        }
        finally {
            out.flush();
        }
        logger.info("Successfully swapped out {} FlowFiles from {} to Swap File {}", new Object[]{toSwap.size(), queue, swapLocation});
    }

    private void writeString(String toWrite, OutputStream out) throws IOException {
        byte[] bytes = toWrite.getBytes(StandardCharsets.UTF_8);
        int utflen = bytes.length;
        if (utflen < 65535) {
            out.write(utflen >>> 8);
            out.write(utflen);
            out.write(bytes);
        } else {
            out.write(255);
            out.write(255);
            out.write(utflen >>> 24);
            out.write(utflen >>> 16);
            out.write(utflen >>> 8);
            out.write(utflen);
            out.write(bytes);
        }
    }

    @Override
    public String getSerializationName() {
        return "Simple Swap Serializer";
    }
}

