/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupBox;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientsEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;

public class PGImport
extends AbstractNiFiCommand<StringResult> {
    public PGImport() {
        super("pg-import", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates a new process group by importing a versioned flow from a registry. If no process group id is specified, then the created process group will be placed in the root group. If only one registry client exists in NiFi, then it does not need to be specified and will be automatically selected. The x and y coordinates for the position of the imported process group may be optionally specified. If left blank, the position will automatically be selected to avoid overlapping with existing process groups.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.REGISTRY_CLIENT_ID.createOption());
        this.addOption(CommandOption.BUCKET_ID.createOption());
        this.addOption(CommandOption.FLOW_ID.createOption());
        this.addOption(CommandOption.FLOW_VERSION.createOption());
        this.addOption(CommandOption.POS_X.createOption());
        this.addOption(CommandOption.POS_Y.createOption());
        this.addOption(CommandOption.KEEP_EXISTING_PARAMETER_CONTEXT.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String parentPgId;
        String registryId;
        String bucketId = this.getRequiredArg(properties, CommandOption.BUCKET_ID);
        String flowId = this.getRequiredArg(properties, CommandOption.FLOW_ID);
        Integer flowVersion = this.getRequiredIntArg(properties, CommandOption.FLOW_VERSION);
        String posXStr = this.getArg(properties, CommandOption.POS_X);
        String posYStr = this.getArg(properties, CommandOption.POS_Y);
        String keepExistingPC = this.getArg(properties, CommandOption.KEEP_EXISTING_PARAMETER_CONTEXT);
        boolean posXExists = StringUtils.isNotBlank((CharSequence)posXStr);
        boolean posYExists = StringUtils.isNotBlank((CharSequence)posYStr);
        if (posXExists && !posYExists) {
            throw new IllegalArgumentException("Missing Y position - Please specify both X and Y, or specify neither");
        }
        if (posYExists && !posXExists) {
            throw new IllegalArgumentException("Missing X position - Please specify both X and Y, or specify neither");
        }
        if (StringUtils.isNotBlank((CharSequence)keepExistingPC) && !keepExistingPC.equals("true") && !keepExistingPC.equals("false")) {
            throw new IllegalArgumentException("Keep Existing Parameter Context must be either true or false");
        }
        if (StringUtils.isBlank((CharSequence)keepExistingPC)) {
            keepExistingPC = "true";
        }
        if (StringUtils.isBlank((CharSequence)(registryId = this.getArg(properties, CommandOption.REGISTRY_CLIENT_ID)))) {
            FlowRegistryClientsEntity registries = client.getControllerClient().getRegistryClients();
            Set entities = registries.getRegistries();
            if (entities == null || entities.isEmpty()) {
                throw new NiFiClientException("No registry clients available");
            }
            if (entities.size() == 1) {
                registryId = ((FlowRegistryClientEntity)entities.stream().findFirst().get()).getId();
            } else {
                throw new MissingOptionException(CommandOption.REGISTRY_CLIENT_ID.getLongName() + " must be provided when there is more than one available");
            }
        }
        if (StringUtils.isBlank((CharSequence)(parentPgId = this.getArg(properties, CommandOption.PG_ID)))) {
            FlowClient flowClient = client.getFlowClient();
            parentPgId = flowClient.getRootGroupId();
        }
        VersionControlInformationDTO versionControlInfo = new VersionControlInformationDTO();
        versionControlInfo.setRegistryId(registryId);
        versionControlInfo.setBucketId(bucketId);
        versionControlInfo.setFlowId(flowId);
        versionControlInfo.setVersion(flowVersion);
        PositionDTO posDto = new PositionDTO();
        if (posXExists && posYExists) {
            posDto.setX(Double.valueOf(Double.parseDouble(posXStr)));
            posDto.setY(Double.valueOf(Double.parseDouble(posYStr)));
        } else {
            ProcessGroupBox pgBox = client.getFlowClient().getSuggestedProcessGroupCoordinates(parentPgId);
            posDto.setX(Double.valueOf(Integer.valueOf(pgBox.getX()).doubleValue()));
            posDto.setY(Double.valueOf(Integer.valueOf(pgBox.getY()).doubleValue()));
        }
        ProcessGroupDTO pgDto = new ProcessGroupDTO();
        pgDto.setVersionControlInformation(versionControlInfo);
        pgDto.setPosition(posDto);
        ProcessGroupEntity pgEntity = new ProcessGroupEntity();
        pgEntity.setComponent(pgDto);
        pgEntity.setRevision(this.getInitialRevisionDTO());
        ProcessGroupClient pgClient = client.getProcessGroupClient();
        ProcessGroupEntity createdEntity = pgClient.createProcessGroup(parentPgId, pgEntity, Boolean.parseBoolean(keepExistingPC));
        return new StringResult(createdEntity.getId(), this.getContext().isInteractive());
    }
}

