/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.jws;

import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.web.security.jwt.jws.JwsSignerContainer;
import org.apache.nifi.web.security.jwt.jws.JwsSignerProvider;
import org.apache.nifi.web.security.jwt.jws.SignerListener;
import org.apache.nifi.web.security.jwt.jws.SigningKeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardJwsSignerProvider
implements JwsSignerProvider,
SignerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardJwsSignerProvider.class);
    private final AtomicReference<JwsSignerContainer> currentSigner = new AtomicReference();
    private final SigningKeyListener signingKeyListener;

    public StandardJwsSignerProvider(SigningKeyListener signingKeyListener) {
        this.signingKeyListener = signingKeyListener;
    }

    @Override
    public JwsSignerContainer getJwsSignerContainer(Instant expiration) {
        JwsSignerContainer jwsSignerContainer = this.currentSigner.get();
        if (jwsSignerContainer == null) {
            throw new IllegalStateException("JSON Web Signature Signer not configured");
        }
        String keyIdentifier = jwsSignerContainer.getKeyIdentifier();
        LOGGER.debug("Signer Used with Key Identifier [{}]", (Object)keyIdentifier);
        this.signingKeyListener.onSigningKeyUsed(keyIdentifier, expiration);
        return jwsSignerContainer;
    }

    @Override
    public void onSignerUpdated(JwsSignerContainer jwsSignerContainer) {
        LOGGER.debug("Signer Updated with Key Identifier [{}]", (Object)jwsSignerContainer.getKeyIdentifier());
        this.currentSigner.set(jwsSignerContainer);
    }
}

