/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env.management;

import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.EnvironmentStatistics;
import jetbrains.exodus.env.management.EnvironmentStatisticsMBean;
import jetbrains.exodus.management.MBeanBase;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010?\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020AH\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0014\u0010\u001a\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\rR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\rR\u0014\u0010$\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0011R\u0014\u0010&\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\rR\u0014\u0010(\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0011R\u0014\u0010*\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\rR\u0014\u0010,\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0011R\u0014\u0010.\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\rR\u0014\u00100\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0011R\u0014\u00102\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\rR\u0013\u00104\u001a\u000705\u00a2\u0006\u0002\b6X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010!R\u0014\u00109\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\tR\u0014\u0010;\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\rR\u0014\u0010=\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\t\u00a8\u0006D"}, d2={"Ljetbrains/exodus/env/management/EnvironmentStatistics;", "Ljetbrains/exodus/management/MBeanBase;", "Ljetbrains/exodus/env/management/EnvironmentStatisticsMBean;", "env", "Ljetbrains/exodus/env/EnvironmentImpl;", "(Ljetbrains/exodus/env/EnvironmentImpl;)V", "activeTransactions", "", "getActiveTransactions", "()I", "bytesMovedByGC", "", "getBytesMovedByGC", "()J", "bytesMovedByGCPerSecond", "", "getBytesMovedByGCPerSecond", "()D", "bytesRead", "getBytesRead", "bytesReadPerSecond", "getBytesReadPerSecond", "bytesWritten", "getBytesWritten", "bytesWrittenPerSecond", "getBytesWrittenPerSecond", "diskUsage", "getDiskUsage", "gcTransactionsDuration", "getGcTransactionsDuration", "logCacheHitRate", "", "getLogCacheHitRate", "()F", "numberOfFlushedTransactions", "getNumberOfFlushedTransactions", "numberOfFlushedTransactionsPerSecond", "getNumberOfFlushedTransactionsPerSecond", "numberOfGCTransactions", "getNumberOfGCTransactions", "numberOfGCTransactionsPerSecond", "getNumberOfGCTransactionsPerSecond", "numberOfReadonlyTransactions", "getNumberOfReadonlyTransactions", "numberOfReadonlyTransactionsPerSecond", "getNumberOfReadonlyTransactionsPerSecond", "numberOfTransactions", "getNumberOfTransactions", "numberOfTransactionsPerSecond", "getNumberOfTransactionsPerSecond", "readonlyTransactionsDuration", "getReadonlyTransactionsDuration", "statistics", "Ljetbrains/exodus/env/EnvironmentStatistics;", "Lorg/jetbrains/annotations/NotNull;", "storeGetCacheHitRate", "getStoreGetCacheHitRate", "stuckTransactionCount", "getStuckTransactionCount", "transactionsDuration", "getTransactionsDuration", "utilizationPercent", "getUtilizationPercent", "getMean", "statisticsName", "Ljetbrains/exodus/env/EnvironmentStatistics$Type;", "getTotal", "Companion", "xodus-environment"})
public final class EnvironmentStatistics
extends MBeanBase
implements EnvironmentStatisticsMBean {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnvironmentImpl env;
    @NotNull
    private final jetbrains.exodus.env.EnvironmentStatistics statistics;

    public EnvironmentStatistics(@NotNull EnvironmentImpl env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        super(Companion.getObjectName$xodus_environment(env));
        this.env = env;
        jetbrains.exodus.env.EnvironmentStatistics environmentStatistics = this.env.getStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)environmentStatistics), (String)"env.statistics");
        this.statistics = environmentStatistics;
    }

    @Override
    public long getBytesWritten() {
        return this.getTotal(EnvironmentStatistics.Type.BYTES_WRITTEN);
    }

    @Override
    public double getBytesWrittenPerSecond() {
        return this.getMean(EnvironmentStatistics.Type.BYTES_WRITTEN);
    }

    @Override
    public long getBytesRead() {
        return this.getTotal(EnvironmentStatistics.Type.BYTES_READ);
    }

    @Override
    public double getBytesReadPerSecond() {
        return this.getMean(EnvironmentStatistics.Type.BYTES_READ);
    }

    @Override
    public long getBytesMovedByGC() {
        return this.getTotal(EnvironmentStatistics.Type.BYTES_MOVED_BY_GC);
    }

    @Override
    public double getBytesMovedByGCPerSecond() {
        return this.getMean(EnvironmentStatistics.Type.BYTES_MOVED_BY_GC);
    }

    @Override
    public float getLogCacheHitRate() {
        return this.env.getLog().getCacheHitRate();
    }

    @Override
    public long getNumberOfTransactions() {
        return this.getTotal(EnvironmentStatistics.Type.TRANSACTIONS);
    }

    @Override
    public double getNumberOfTransactionsPerSecond() {
        return this.getMean(EnvironmentStatistics.Type.TRANSACTIONS);
    }

    @Override
    public long getNumberOfReadonlyTransactions() {
        return this.getTotal(EnvironmentStatistics.Type.READONLY_TRANSACTIONS);
    }

    @Override
    public double getNumberOfReadonlyTransactionsPerSecond() {
        return this.getMean(EnvironmentStatistics.Type.READONLY_TRANSACTIONS);
    }

    @Override
    public long getNumberOfGCTransactions() {
        return this.getTotal(EnvironmentStatistics.Type.GC_TRANSACTIONS);
    }

    @Override
    public double getNumberOfGCTransactionsPerSecond() {
        return this.getMean(EnvironmentStatistics.Type.GC_TRANSACTIONS);
    }

    @Override
    public int getActiveTransactions() {
        return (int)this.getTotal(EnvironmentStatistics.Type.ACTIVE_TRANSACTIONS);
    }

    @Override
    public long getNumberOfFlushedTransactions() {
        return this.getTotal(EnvironmentStatistics.Type.FLUSHED_TRANSACTIONS);
    }

    @Override
    public double getNumberOfFlushedTransactionsPerSecond() {
        return this.getMean(EnvironmentStatistics.Type.FLUSHED_TRANSACTIONS);
    }

    @Override
    public long getTransactionsDuration() {
        return this.getTotal(EnvironmentStatistics.Type.TRANSACTIONS_DURATION);
    }

    @Override
    public long getReadonlyTransactionsDuration() {
        return this.getTotal(EnvironmentStatistics.Type.READONLY_TRANSACTIONS_DURATION);
    }

    @Override
    public long getGcTransactionsDuration() {
        return this.getTotal(EnvironmentStatistics.Type.GC_TRANSACTIONS_DURATION);
    }

    @Override
    public long getDiskUsage() {
        return this.getTotal(EnvironmentStatistics.Type.DISK_USAGE);
    }

    @Override
    public int getUtilizationPercent() {
        return (int)this.getTotal(EnvironmentStatistics.Type.UTILIZATION_PERCENT);
    }

    @Override
    public float getStoreGetCacheHitRate() {
        return this.env.getStoreGetCacheHitRate();
    }

    @Override
    public int getStuckTransactionCount() {
        return this.env.getStuckTransactionCount();
    }

    private final long getTotal(EnvironmentStatistics.Type statisticsName) {
        return this.statistics.getStatisticsItem(statisticsName).getTotal();
    }

    private final double getMean(EnvironmentStatistics.Type statisticsName) {
        return this.statistics.getStatisticsItem(statisticsName).getMean();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/exodus/env/management/EnvironmentStatistics$Companion;", "", "()V", "getObjectName", "", "env", "Ljetbrains/exodus/env/Environment;", "getObjectName$xodus_environment", "xodus-environment"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getObjectName$xodus_environment(@NotNull Environment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            return Intrinsics.stringPlus((String)"jetbrains.exodus.env: type=EnvironmentStatistics, location=", (Object)MBeanBase.escapeLocation((String)env.getLocation()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

