/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.FunctionBasedRowCursorFactory;

public class DeferredSymbolIndexRowCursorFactory
implements FunctionBasedRowCursorFactory {
    private final boolean cachedIndexReaderCursor;
    private final int columnIndex;
    private final int indexDirection;
    private final Function symbol;
    private int symbolKey;

    public DeferredSymbolIndexRowCursorFactory(int columnIndex, Function symbol, boolean cachedIndexReaderCursor, int indexDirection) {
        this.columnIndex = columnIndex;
        this.symbolKey = -2;
        this.symbol = symbol;
        this.cachedIndexReaderCursor = cachedIndexReaderCursor;
        this.indexDirection = indexDirection;
    }

    @Override
    public RowCursor getCursor(DataFrame dataFrame) {
        if (this.symbolKey == -2) {
            return EmptyRowCursor.INSTANCE;
        }
        return dataFrame.getBitmapIndexReader(this.columnIndex, this.indexDirection).getCursor(this.cachedIndexReaderCursor, this.symbolKey, dataFrame.getRowLo(), dataFrame.getRowHi() - 1L);
    }

    @Override
    public Function getFunction() {
        return this.symbol;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isUsingIndex() {
        return true;
    }

    @Override
    public void prepareCursor(TableReader tableReader, SqlExecutionContext sqlExecutionContext) throws SqlException {
        this.symbol.init(tableReader, sqlExecutionContext);
        int symbolKey = tableReader.getSymbolMapReader(this.columnIndex).keyOf(this.symbol.getSymbol(null));
        if (symbolKey != -2) {
            this.symbolKey = TableUtils.toIndexKey(symbolKey);
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index ").type(BitmapIndexReader.nameOf(this.indexDirection)).type(" scan").meta("on").putBaseColumnName(this.columnIndex);
        sink.meta("deferred").val("true");
        sink.attr("filter").putBaseColumnName(this.columnIndex).val('=').val(this.symbol);
    }
}

