/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.leader.election;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.nifi.controller.cluster.ZooKeeperClientConfig;
import org.apache.nifi.controller.leader.election.CuratorACLProviderFactory;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.leader.election.LeaderElectionStateChangeListener;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.timebuffer.CountSumMinMaxAccess;
import org.apache.nifi.util.timebuffer.EntityAccess;
import org.apache.nifi.util.timebuffer.LongEntityAccess;
import org.apache.nifi.util.timebuffer.TimedBuffer;
import org.apache.nifi.util.timebuffer.TimestampedLong;
import org.apache.nifi.util.timebuffer.TimestampedLongAggregation;
import org.apache.zookeeper.ClientCnxnSocketNetty;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.common.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorLeaderElectionManager
implements LeaderElectionManager {
    private static final Logger logger = LoggerFactory.getLogger(CuratorLeaderElectionManager.class);
    private final FlowEngine leaderElectionMonitorEngine;
    private final ZooKeeperClientConfig zkConfig;
    private CuratorFramework curatorClient;
    private volatile boolean stopped = true;
    private final ConcurrentMap<String, LeaderRole> leaderRoles = new ConcurrentHashMap<String, LeaderRole>();
    private final ConcurrentMap<String, RegisteredRole> registeredRoles = new ConcurrentHashMap<String, RegisteredRole>();
    private final ConcurrentMap<String, TimedBuffer<TimestampedLong>> leaderChanges = new ConcurrentHashMap<String, TimedBuffer<TimestampedLong>>();
    private final TimedBuffer<TimestampedLongAggregation> pollTimes = new TimedBuffer(TimeUnit.SECONDS, 300, (EntityAccess)new CountSumMinMaxAccess());
    private final ConcurrentMap<String, String> lastKnownLeader = new ConcurrentHashMap<String, String>();

    public CuratorLeaderElectionManager(int threadPoolSize, NiFiProperties properties) {
        this.leaderElectionMonitorEngine = new FlowEngine(threadPoolSize, "Leader Election Notification", true);
        this.zkConfig = ZooKeeperClientConfig.createConfig(properties);
    }

    @Override
    public synchronized void start() {
        if (!this.stopped) {
            return;
        }
        this.stopped = false;
        this.curatorClient = this.createClient();
        for (Map.Entry entry : this.registeredRoles.entrySet()) {
            RegisteredRole role = (RegisteredRole)entry.getValue();
            this.register((String)entry.getKey(), role.getListener(), role.getParticipantId());
        }
        logger.info("{} started", (Object)this);
    }

    @Override
    public boolean isActiveParticipant(String roleName) {
        RegisteredRole role = (RegisteredRole)this.registeredRoles.get(roleName);
        if (role == null) {
            return false;
        }
        String participantId = role.getParticipantId();
        return participantId != null;
    }

    @Override
    public void register(String roleName, LeaderElectionStateChangeListener listener) {
        this.register(roleName, listener, null);
    }

    private String getElectionPath(String roleName) {
        String rootPath = this.zkConfig.getRootPath();
        String leaderPath = rootPath + (rootPath.endsWith("/") ? "" : "/") + "leaders/" + roleName;
        return leaderPath;
    }

    @Override
    public synchronized void register(String roleName, LeaderElectionStateChangeListener listener, String participantId) {
        boolean isParticipant;
        logger.debug("{} Registering new Leader Selector for role {}", (Object)this, (Object)roleName);
        LeaderRole currentRole = (LeaderRole)this.leaderRoles.get(roleName);
        if (currentRole != null && (currentRole.isParticipant() || participantId == null)) {
            logger.info("{} Attempted to register Leader Election for role '{}' but this role is already registered", (Object)this, (Object)roleName);
            return;
        }
        String leaderPath = this.getElectionPath(roleName);
        try {
            PathUtils.validatePath((String)leaderPath);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Cannot register leader election for role '" + roleName + "' because this is not a valid role name");
        }
        this.registeredRoles.put(roleName, new RegisteredRole(participantId, listener));
        boolean bl = isParticipant = participantId != null && !participantId.trim().isEmpty();
        if (!this.isStopped()) {
            ElectionListener electionListener = new ElectionListener(roleName, listener, participantId);
            LeaderSelector leaderSelector = new LeaderSelector(this.curatorClient, leaderPath, (ExecutorService)this.leaderElectionMonitorEngine, (LeaderSelectorListener)electionListener);
            if (isParticipant) {
                leaderSelector.autoRequeue();
                leaderSelector.setId(participantId);
                leaderSelector.start();
            }
            LeaderRole leaderRole = new LeaderRole(leaderSelector, electionListener, isParticipant);
            this.leaderRoles.put(roleName, leaderRole);
        }
        if (isParticipant) {
            logger.info("{} Registered new Leader Selector for role {}; this node is an active participant in the election.", (Object)this, (Object)roleName);
        } else {
            logger.info("{} Registered new Leader Selector for role {}; this node is a silent observer in the election.", (Object)this, (Object)roleName);
        }
    }

    @Override
    public synchronized void unregister(String roleName) {
        this.registeredRoles.remove(roleName);
        LeaderRole leaderRole = (LeaderRole)this.leaderRoles.remove(roleName);
        if (leaderRole == null) {
            logger.info("Cannot unregister Leader Election Role '{}' because that role is not registered", (Object)roleName);
            return;
        }
        LeaderSelector leaderSelector = leaderRole.getLeaderSelector();
        if (leaderSelector == null) {
            logger.info("Cannot unregister Leader Election Role '{}' because that role is not registered", (Object)roleName);
            return;
        }
        leaderRole.getElectionListener().disable();
        leaderSelector.close();
        logger.info("This node is no longer registered to be elected as the Leader for Role '{}'", (Object)roleName);
    }

    @Override
    public synchronized void stop() {
        this.stopped = true;
        for (Map.Entry entry : this.leaderRoles.entrySet()) {
            LeaderRole role = (LeaderRole)entry.getValue();
            LeaderSelector selector = role.getLeaderSelector();
            try {
                selector.close();
            }
            catch (Exception e) {
                logger.warn("Failed to close Leader Selector for {}", entry.getKey(), (Object)e);
            }
        }
        this.leaderRoles.clear();
        if (this.curatorClient != null) {
            this.curatorClient.close();
            this.curatorClient = null;
        }
        logger.info("{} stopped and closed", (Object)this);
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public String toString() {
        return "CuratorLeaderElectionManager[stopped=" + this.isStopped() + "]";
    }

    private LeaderRole getLeaderRole(String roleName) {
        return (LeaderRole)this.leaderRoles.get(roleName);
    }

    private void onLeaderChanged(String roleName) {
        TimedBuffer buffer = this.leaderChanges.computeIfAbsent(roleName, key -> new TimedBuffer(TimeUnit.HOURS, 24, (EntityAccess)new LongEntityAccess()));
        buffer.add((Object)new TimestampedLong(Long.valueOf(1L)));
    }

    @Override
    public Map<String, Integer> getLeadershipChangeCount(long duration, TimeUnit unit) {
        HashMap<String, Integer> leadershipChangesPerRole = new HashMap<String, Integer>();
        for (Map.Entry entry : this.leaderChanges.entrySet()) {
            String roleName = (String)entry.getKey();
            TimedBuffer buffer = (TimedBuffer)entry.getValue();
            TimestampedLong aggregateValue = (TimestampedLong)buffer.getAggregateValue(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(duration, unit));
            int leadershipChanges = aggregateValue == null ? 0 : aggregateValue.getValue().intValue();
            leadershipChangesPerRole.put(roleName, leadershipChanges);
        }
        return leadershipChangesPerRole;
    }

    @Override
    public boolean isLeader(String roleName) {
        boolean activeParticipant = this.isActiveParticipant(roleName);
        if (!activeParticipant) {
            logger.debug("Node is not an active participant in election for role {} so cannot be leader", (Object)roleName);
            return false;
        }
        LeaderRole role = this.getLeaderRole(roleName);
        if (role == null) {
            logger.debug("Node is an active participant in election for role {} but there is no LeaderRole registered so this node cannot be leader", (Object)roleName);
            return false;
        }
        return role.isLeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLeader(String roleName) {
        if (this.isStopped()) {
            return this.determineLeaderExternal(roleName);
        }
        LeaderRole role = this.getLeaderRole(roleName);
        if (role == null) {
            return this.determineLeaderExternal(roleName);
        }
        long startNanos = System.nanoTime();
        try {
            Participant participant;
            try {
                participant = role.getLeaderSelector().getLeader();
            }
            catch (Exception e) {
                logger.warn("Unable to determine leader for role '{}'; returning null", (Object)roleName, (Object)e);
                String string = null;
                this.registerPollTime(System.nanoTime() - startNanos);
                return string;
            }
            if (participant == null) {
                logger.debug("There is currently no elected leader for the {} role", (Object)roleName);
                String e = null;
                return e;
            }
            String participantId = participant.getId();
            if (StringUtils.isEmpty((CharSequence)participantId)) {
                logger.debug("Found leader participant for role {} but the participantId was empty", (Object)roleName);
                String string = null;
                return string;
            }
            String previousLeader = this.lastKnownLeader.put(roleName, participantId);
            if (previousLeader != null && !previousLeader.equals(participantId)) {
                this.onLeaderChanged(roleName);
            }
            String string = participantId;
            return string;
        }
        finally {
            this.registerPollTime(System.nanoTime() - startNanos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPollTime(long nanos) {
        TimedBuffer<TimestampedLongAggregation> timedBuffer = this.pollTimes;
        synchronized (timedBuffer) {
            this.pollTimes.add((Object)TimestampedLongAggregation.newValue((long)nanos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAveragePollTime(TimeUnit timeUnit) {
        long averageNanos;
        TimedBuffer<TimestampedLongAggregation> timedBuffer = this.pollTimes;
        synchronized (timedBuffer) {
            TimestampedLongAggregation.TimestampedAggregation aggregation = ((TimestampedLongAggregation)this.pollTimes.getAggregateValue(0L)).getAggregation();
            if (aggregation == null || aggregation.getCount() == 0L) {
                return 0L;
            }
            averageNanos = aggregation.getSum() / aggregation.getCount();
        }
        return timeUnit.convert(averageNanos, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinPollTime(TimeUnit timeUnit) {
        long minNanos;
        TimedBuffer<TimestampedLongAggregation> timedBuffer = this.pollTimes;
        synchronized (timedBuffer) {
            TimestampedLongAggregation.TimestampedAggregation aggregation = ((TimestampedLongAggregation)this.pollTimes.getAggregateValue(0L)).getAggregation();
            if (aggregation == null) {
                return 0L;
            }
            minNanos = aggregation.getMin();
        }
        return timeUnit.convert(minNanos, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxPollTime(TimeUnit timeUnit) {
        long maxNanos;
        TimedBuffer<TimestampedLongAggregation> timedBuffer = this.pollTimes;
        synchronized (timedBuffer) {
            TimestampedLongAggregation.TimestampedAggregation aggregation = ((TimestampedLongAggregation)this.pollTimes.getAggregateValue(0L)).getAggregation();
            if (aggregation == null) {
                return 0L;
            }
            maxNanos = aggregation.getMax();
        }
        return timeUnit.convert(maxNanos, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPollCount() {
        TimedBuffer<TimestampedLongAggregation> timedBuffer = this.pollTimes;
        synchronized (timedBuffer) {
            TimestampedLongAggregation.TimestampedAggregation aggregation = ((TimestampedLongAggregation)this.pollTimes.getAggregateValue(0L)).getAggregation();
            if (aggregation == null) {
                return 0L;
            }
            return aggregation.getCount();
        }
    }

    @Override
    public boolean isLeaderElected(String roleName) {
        String leaderAddress = this.determineLeaderExternal(roleName);
        return !StringUtils.isEmpty((CharSequence)leaderAddress);
    }

    /*
     * Exception decompiling
     */
    private String determineLeaderExternal(String roleName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CuratorFramework createClient() {
        RetryNTimes retryPolicy = new RetryNTimes(1, 100);
        CuratorACLProviderFactory aclProviderFactory = new CuratorACLProviderFactory();
        CuratorFrameworkFactory.Builder clientBuilder = CuratorFrameworkFactory.builder().connectString(this.zkConfig.getConnectString()).sessionTimeoutMs(this.zkConfig.getSessionTimeoutMillis()).connectionTimeoutMs(this.zkConfig.getConnectionTimeoutMillis()).ensembleTracker(this.zkConfig.isWithEnsembleTracker()).retryPolicy((RetryPolicy)retryPolicy).aclProvider(aclProviderFactory.create(this.zkConfig)).defaultData(new byte[0]);
        if (this.zkConfig.isClientSecure()) {
            clientBuilder.zookeeperFactory((ZookeeperFactory)new SecureClientZooKeeperFactory(this.zkConfig));
        }
        CuratorFramework client = clientBuilder.build();
        client.start();
        return client;
    }

    public static class SecureClientZooKeeperFactory
    implements ZookeeperFactory {
        public static final String NETTY_CLIENT_CNXN_SOCKET = ClientCnxnSocketNetty.class.getName();
        private final ZKClientConfig zkSecureClientConfig = new ZKClientConfig();

        public SecureClientZooKeeperFactory(ZooKeeperClientConfig zkConfig) {
            String cnxnSocket = zkConfig.getConnectionSocket();
            if (!NETTY_CLIENT_CNXN_SOCKET.equals(cnxnSocket)) {
                throw new IllegalArgumentException(String.format("connection factory set to '%s', %s required", cnxnSocket, NETTY_CLIENT_CNXN_SOCKET));
            }
            this.zkSecureClientConfig.setProperty("zookeeper.clientCnxnSocket", cnxnSocket);
            boolean clientSecure = zkConfig.isClientSecure();
            if (!clientSecure) {
                throw new IllegalStateException(String.format("%s set to '%b', expected true", "zookeeper.client.secure", clientSecure));
            }
            this.zkSecureClientConfig.setProperty("zookeeper.client.secure", String.valueOf(clientSecure));
            ClientX509Util clientX509util = new ClientX509Util();
            this.zkSecureClientConfig.setProperty(clientX509util.getSslKeystoreLocationProperty(), zkConfig.getKeyStore());
            this.zkSecureClientConfig.setProperty(clientX509util.getSslKeystoreTypeProperty(), zkConfig.getKeyStoreType());
            this.zkSecureClientConfig.setProperty(clientX509util.getSslKeystorePasswdProperty(), zkConfig.getKeyStorePassword());
            this.zkSecureClientConfig.setProperty(clientX509util.getSslTruststoreLocationProperty(), zkConfig.getTrustStore());
            this.zkSecureClientConfig.setProperty(clientX509util.getSslTruststoreTypeProperty(), zkConfig.getTrustStoreType());
            this.zkSecureClientConfig.setProperty(clientX509util.getSslTruststorePasswdProperty(), zkConfig.getTrustStorePassword());
            this.zkSecureClientConfig.setProperty("jute.maxbuffer", Integer.toString(zkConfig.getJuteMaxbuffer()));
        }

        public ZooKeeper newZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly) throws Exception {
            return new ZooKeeperAdmin(connectString, sessionTimeout, watcher, this.zkSecureClientConfig);
        }
    }

    private class ElectionListener
    extends LeaderSelectorListenerAdapter
    implements LeaderSelectorListener {
        private final String roleName;
        private final LeaderElectionStateChangeListener listener;
        private final String participantId;
        private volatile boolean leader;
        private volatile Thread leaderThread;
        private long leaderUpdateTimestamp = 0L;
        private final long MAX_CACHE_MILLIS = TimeUnit.SECONDS.toMillis(5L);

        public ElectionListener(String roleName, LeaderElectionStateChangeListener listener, String participantId) {
            this.roleName = roleName;
            this.listener = listener;
            this.participantId = participantId;
        }

        public void disable() {
            logger.info("Election Listener for Role {} disabled", (Object)this.roleName);
            this.setLeader(false);
            if (this.leaderThread == null) {
                logger.debug("Election Listener for Role {} disabled but there is no leader thread. Will not interrupt any threads.", (Object)this.roleName);
            } else {
                this.leaderThread.interrupt();
            }
        }

        public synchronized boolean isLeader() {
            if (this.leaderUpdateTimestamp < System.currentTimeMillis() - this.MAX_CACHE_MILLIS) {
                try {
                    long start = System.nanoTime();
                    boolean zkLeader = this.verifyLeader();
                    long nanos = System.nanoTime() - start;
                    this.setLeader(zkLeader);
                    logger.debug("Took {} nanoseconds to reach out to ZooKeeper in order to check whether or not this node is currently the leader for Role '{}'. ZooKeeper reported {}", new Object[]{nanos, this.roleName, zkLeader});
                }
                catch (Exception e) {
                    logger.warn("Attempted to reach out to ZooKeeper to determine whether or not this node is the elected leader for Role '{}' but failed to communicate with ZooKeeper. Assuming that this node is not the leader.", (Object)this.roleName, (Object)e);
                    return false;
                }
            } else {
                logger.debug("Checking if this node is leader for role {}: using cached response, returning {}", (Object)this.roleName, (Object)this.leader);
            }
            return this.leader;
        }

        private synchronized void setLeader(boolean leader) {
            this.leader = leader;
            this.leaderUpdateTimestamp = System.currentTimeMillis();
        }

        public synchronized void stateChanged(CuratorFramework client, ConnectionState newState) {
            logger.info("{} Connection State changed to {}", (Object)this, (Object)newState.name());
            if (newState == ConnectionState.SUSPENDED || newState == ConnectionState.LOST) {
                if (this.leader) {
                    logger.info("Because Connection State was changed to {}, will relinquish leadership for role '{}'", (Object)newState, (Object)this.roleName);
                }
                this.setLeader(false);
            }
            super.stateChanged(client, newState);
        }

        private boolean verifyLeader() {
            String leader = CuratorLeaderElectionManager.this.getLeader(this.roleName);
            if (leader == null) {
                logger.debug("Reached out to ZooKeeper to determine which node is the elected leader for Role '{}' but found that there is no leader.", (Object)this.roleName);
                this.setLeader(false);
                return false;
            }
            boolean match = leader.equals(this.participantId);
            logger.debug("Reached out to ZooKeeper to determine which node is the elected leader for Role '{}'. Elected Leader = '{}', Participant ID = '{}', This Node Elected = {}", new Object[]{this.roleName, leader, this.participantId, match});
            this.setLeader(match);
            return match;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void takeLeadership(CuratorFramework client) throws Exception {
            this.leaderThread = Thread.currentThread();
            this.setLeader(true);
            logger.info("{} This node has been elected Leader for Role '{}'", (Object)this, (Object)this.roleName);
            if (this.listener != null) {
                try {
                    this.listener.onLeaderElection();
                }
                catch (Exception e) {
                    logger.error("This node was elected Leader for Role '{}' but failed to take leadership. Will relinquish leadership role. Failure was due to: {}", (Object)this.roleName, (Object)e);
                    this.setLeader(false);
                    Thread.sleep(1000L);
                    return;
                }
            }
            try {
                int failureCount = 0;
                int loopCount = 0;
                while (!CuratorLeaderElectionManager.this.isStopped() && this.leader) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        block21: {
                            logger.info("{} has been interrupted; no longer leader for role '{}'", (Object)this, (Object)this.roleName);
                            Thread.currentThread().interrupt();
                            this.setLeader(false);
                            logger.info("{} This node is no longer leader for role '{}'", (Object)this, (Object)this.roleName);
                            if (this.listener != null) {
                                try {
                                    this.listener.onLeaderRelinquish();
                                }
                                catch (Exception e) {
                                    logger.error("This node is no longer leader for role '{}' but failed to shutdown leadership responsibilities properly due to: {}", (Object)this.roleName, (Object)e.toString());
                                    if (!logger.isDebugEnabled()) break block21;
                                    logger.error("", (Throwable)e);
                                }
                            }
                        }
                        return;
                    }
                    if (!this.leader || ++loopCount % 50 != 0) continue;
                    try {
                        boolean stillLeader = this.verifyLeader();
                        failureCount = 0;
                        if (stillLeader) continue;
                        logger.info("According to ZooKeeper, this node is no longer the leader for Role '{}'. Will relinquish leadership.", (Object)this.roleName);
                        break;
                    }
                    catch (Exception e) {
                        if (++failureCount > 1) {
                            logger.warn("Attempted to reach out to ZooKeeper to verify that this node still is the elected leader for Role '{}' but failed to communicate with ZooKeeper. This is the second failed attempt, so will relinquish leadership of this role.", (Object)this.roleName, (Object)e);
                            continue;
                        }
                        logger.warn("Attempted to reach out to ZooKeeper to verify that this node still is the elected leader for Role '{}' but failed to communicate with ZooKeeper. Will wait a bit and attempt to communicate with ZooKeeper again before relinquishing this role.", (Object)this.roleName, (Object)e);
                    }
                }
            }
            finally {
                block23: {
                    this.setLeader(false);
                    logger.info("{} This node is no longer leader for role '{}'", (Object)this, (Object)this.roleName);
                    if (this.listener != null) {
                        try {
                            this.listener.onLeaderRelinquish();
                        }
                        catch (Exception e) {
                            logger.error("This node is no longer leader for role '{}' but failed to shutdown leadership responsibilities properly due to: {}", (Object)this.roleName, (Object)e.toString());
                            if (!logger.isDebugEnabled()) break block23;
                            logger.error("", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private static class RegisteredRole {
        private final LeaderElectionStateChangeListener listener;
        private final String participantId;

        public RegisteredRole(String participantId, LeaderElectionStateChangeListener listener) {
            this.participantId = participantId;
            this.listener = listener;
        }

        public LeaderElectionStateChangeListener getListener() {
            return this.listener;
        }

        public String getParticipantId() {
            return this.participantId;
        }
    }

    private static class LeaderRole {
        private final LeaderSelector leaderSelector;
        private final ElectionListener electionListener;
        private final boolean participant;

        public LeaderRole(LeaderSelector leaderSelector, ElectionListener electionListener, boolean participant) {
            this.leaderSelector = leaderSelector;
            this.electionListener = electionListener;
            this.participant = participant;
        }

        public LeaderSelector getLeaderSelector() {
            return this.leaderSelector;
        }

        public ElectionListener getElectionListener() {
            return this.electionListener;
        }

        public boolean isLeader() {
            return this.electionListener.isLeader();
        }

        public boolean isParticipant() {
            return this.participant;
        }
    }
}

