/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.inheritance;

import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.inheritance.FlowInheritability;
import org.apache.nifi.controller.inheritance.FlowInheritabilityCheck;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.encrypt.SensitiveValueEncoder;
import org.apache.nifi.fingerprint.FingerprintFactory;
import org.apache.nifi.nar.ExtensionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowFingerprintCheck
implements FlowInheritabilityCheck {
    private static final Logger logger = LoggerFactory.getLogger(FlowFingerprintCheck.class);

    @Override
    public FlowInheritability checkInheritability(DataFlow existingFlow, DataFlow proposedFlow, FlowController flowController) {
        boolean inheritable;
        SensitiveValueEncoder sensitiveValueEncoder;
        ExtensionManager extensionManager;
        if (existingFlow == null) {
            return FlowInheritability.inheritable();
        }
        byte[] existingFlowBytes = existingFlow.getFlow();
        byte[] proposedFlowBytes = proposedFlow.getFlow();
        PropertyEncryptor encryptor = flowController.getEncryptor();
        FingerprintFactory fingerprintFactory = new FingerprintFactory(encryptor, extensionManager = flowController.getExtensionManager(), sensitiveValueEncoder = flowController.getSensitiveValueEncoder());
        String existingFlowFingerprintBeforeHash = fingerprintFactory.createFingerprint(existingFlowBytes, flowController);
        if (existingFlowFingerprintBeforeHash.trim().isEmpty()) {
            return null;
        }
        if (proposedFlow == null || proposedFlowBytes.length == 0) {
            return FlowInheritability.notInheritable("Proposed Flow was empty but Current Flow is not");
        }
        String proposedFlowFingerprintBeforeHash = fingerprintFactory.createFingerprint(proposedFlow.getFlowDocument(), flowController);
        if (proposedFlowFingerprintBeforeHash.trim().isEmpty()) {
            return FlowInheritability.notInheritable("Proposed Flow was empty but Current Flow is not");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Local Fingerprint Before Hash = {}", new Object[]{existingFlowFingerprintBeforeHash});
            logger.trace("Proposed Fingerprint Before Hash = {}", new Object[]{proposedFlowFingerprintBeforeHash});
        }
        if (!(inheritable = existingFlowFingerprintBeforeHash.equals(proposedFlowFingerprintBeforeHash))) {
            String discrepancy = this.findFirstDiscrepancy(existingFlowFingerprintBeforeHash, proposedFlowFingerprintBeforeHash, "Flows");
            return FlowInheritability.notInheritable(discrepancy);
        }
        return FlowInheritability.inheritable();
    }

    private String findFirstDiscrepancy(String existing, String proposed, String comparisonDescription) {
        int shortestFileLength = Math.min(existing.length(), proposed.length());
        for (int i = 0; i < shortestFileLength; ++i) {
            if (existing.charAt(i) == proposed.charAt(i)) continue;
            String formattedExistingDelta = this.formatFlowDiscrepancy(existing, i, 100);
            String formattedProposedDelta = this.formatFlowDiscrepancy(proposed, i, 100);
            return String.format("Found difference in %s:\nLocal Fingerprint:   %s\nCluster Fingerprint: %s", comparisonDescription, formattedExistingDelta, formattedProposedDelta);
        }
        if (existing.length() > proposed.length()) {
            String formattedExistingDelta = existing.substring(proposed.length(), Math.min(existing.length(), proposed.length() + 200));
            return String.format("Found difference in %s:\nLocal Fingerprint contains additional configuration from Cluster Fingerprint: %s", comparisonDescription, formattedExistingDelta);
        }
        if (proposed.length() > existing.length()) {
            String formattedProposedDelta = proposed.substring(existing.length(), Math.min(proposed.length(), existing.length() + 200));
            return String.format("Found difference in %s:\nCluster Fingerprint contains additional configuration from Local Fingerprint: %s", comparisonDescription, formattedProposedDelta);
        }
        return "Unable to find any discrepancies between fingerprints. Please contact the NiFi support team";
    }

    private String formatFlowDiscrepancy(String flowFingerprint, int deltaIndex, int deltaPad) {
        return flowFingerprint.substring(Math.max(0, deltaIndex - deltaPad), Math.min(flowFingerprint.length(), deltaIndex + deltaPad));
    }
}

