/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.cluster;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.zookeeper.ClientCnxnSocketNIO;
import org.apache.zookeeper.ClientCnxnSocketNetty;
import org.apache.zookeeper.common.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperClientConfig {
    public static final String NETTY_CLIENT_CNXN_SOCKET = ClientCnxnSocketNetty.class.getName();
    public static final String NIO_CLIENT_CNXN_SOCKET = ClientCnxnSocketNIO.class.getName();
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperClientConfig.class);
    private static final Pattern PORT_PATTERN = Pattern.compile("[0-9]{1,5}");
    private final String connectString;
    private final int sessionTimeoutMillis;
    private final int connectionTimeoutMillis;
    private final String rootPath;
    private final boolean clientSecure;
    private final boolean withEnsembleTracker;
    private final String keyStore;
    private final String keyStoreType;
    private final String keyStorePassword;
    private final String trustStore;
    private final String trustStoreType;
    private final String trustStorePassword;
    private final String authType;
    private final String authPrincipal;
    private final String removeHostFromPrincipal;
    private final String removeRealmFromPrincipal;
    private final int juteMaxbuffer;

    private ZooKeeperClientConfig(String connectString, int sessionTimeoutMillis, int connectionTimeoutMillis, String rootPath, String authType, String authPrincipal, String removeHostFromPrincipal, String removeRealmFromPrincipal, boolean clientSecure, String keyStore, String keyStoreType, String keyStorePassword, String trustStore, String trustStoreType, String trustStorePassword, int juteMaxbuffer, boolean withEnsembleTracker) {
        this.connectString = connectString;
        this.sessionTimeoutMillis = sessionTimeoutMillis;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.rootPath = rootPath.endsWith("/") ? rootPath.substring(0, rootPath.length() - 1) : rootPath;
        this.clientSecure = clientSecure;
        this.keyStore = keyStore;
        this.keyStoreType = keyStoreType;
        this.keyStorePassword = keyStorePassword;
        this.trustStore = trustStore;
        this.trustStoreType = trustStoreType;
        this.trustStorePassword = trustStorePassword;
        this.authType = authType;
        this.authPrincipal = authPrincipal;
        this.removeHostFromPrincipal = removeHostFromPrincipal;
        this.removeRealmFromPrincipal = removeRealmFromPrincipal;
        this.juteMaxbuffer = juteMaxbuffer;
        this.withEnsembleTracker = withEnsembleTracker;
    }

    public String getConnectString() {
        return this.connectString;
    }

    public int getSessionTimeoutMillis() {
        return this.sessionTimeoutMillis;
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public boolean isClientSecure() {
        return this.clientSecure;
    }

    public boolean isWithEnsembleTracker() {
        return this.withEnsembleTracker;
    }

    public String getConnectionSocket() {
        return this.isClientSecure() ? NETTY_CLIENT_CNXN_SOCKET : NIO_CLIENT_CNXN_SOCKET;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getAuthPrincipal() {
        return this.authPrincipal;
    }

    public String getRemoveHostFromPrincipal() {
        return this.removeHostFromPrincipal;
    }

    public String getRemoveRealmFromPrincipal() {
        return this.removeRealmFromPrincipal;
    }

    public int getJuteMaxbuffer() {
        return this.juteMaxbuffer;
    }

    public String resolvePath(String path) {
        if (path.startsWith("/")) {
            return this.rootPath + path;
        }
        return this.rootPath + "/" + path;
    }

    public static ZooKeeperClientConfig createConfig(NiFiProperties nifiProperties) {
        String connectString = nifiProperties.getProperty("nifi.zookeeper.connect.string");
        if (connectString == null || connectString.trim().isEmpty()) {
            throw new IllegalStateException("The 'nifi.zookeeper.connect.string' property is not set in nifi.properties");
        }
        String cleanedConnectString = ZooKeeperClientConfig.cleanConnectString(connectString);
        if (cleanedConnectString.isEmpty()) {
            throw new IllegalStateException("The 'nifi.zookeeper.connect.string' property is set in nifi.properties but needs to be in pairs of host:port separated by commas");
        }
        long sessionTimeoutMs = ZooKeeperClientConfig.getTimePeriod(nifiProperties, "nifi.zookeeper.session.timeout", "3 secs");
        long connectionTimeoutMs = ZooKeeperClientConfig.getTimePeriod(nifiProperties, "nifi.zookeeper.connect.timeout", "3 secs");
        String rootPath = nifiProperties.getProperty("nifi.zookeeper.root.node", "/nifi");
        boolean clientSecure = nifiProperties.isZooKeeperClientSecure();
        boolean withEnsembleTracker = nifiProperties.isZookeeperClientWithEnsembleTracker();
        String keyStore = ZooKeeperClientConfig.getPreferredProperty(nifiProperties, "nifi.zookeeper.security.keystore", "nifi.security.keystore");
        String keyStoreType = StringUtils.stripToNull((String)ZooKeeperClientConfig.getPreferredProperty(nifiProperties, "nifi.zookeeper.security.keystoreType", "nifi.security.keystoreType"));
        String keyStorePassword = ZooKeeperClientConfig.getPreferredProperty(nifiProperties, "nifi.zookeeper.security.keystorePasswd", "nifi.security.keystorePasswd");
        String trustStore = ZooKeeperClientConfig.getPreferredProperty(nifiProperties, "nifi.zookeeper.security.truststore", "nifi.security.truststore");
        String trustStoreType = StringUtils.stripToNull((String)ZooKeeperClientConfig.getPreferredProperty(nifiProperties, "nifi.zookeeper.security.truststoreType", "nifi.security.truststoreType"));
        String trustStorePassword = ZooKeeperClientConfig.getPreferredProperty(nifiProperties, "nifi.zookeeper.security.truststorePasswd", "nifi.security.truststorePasswd");
        String authType = nifiProperties.getProperty("nifi.zookeeper.auth.type", "default");
        String authPrincipal = nifiProperties.getKerberosServicePrincipal();
        String removeHostFromPrincipal = nifiProperties.getProperty("nifi.zookeeper.kerberos.removeHostFromPrincipal", "true");
        String removeRealmFromPrincipal = nifiProperties.getProperty("nifi.zookeeper.kerberos.removeRealmFromPrincipal", "true");
        int juteMaxbuffer = nifiProperties.getIntegerProperty("nifi.zookeeper.jute.maxbuffer", Integer.valueOf(1048575));
        try {
            PathUtils.validatePath((String)rootPath);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The 'nifi.zookeeper.root.node' property in nifi.properties is set to an illegal value: " + rootPath);
        }
        return new ZooKeeperClientConfig(cleanedConnectString, (int)sessionTimeoutMs, (int)connectionTimeoutMs, rootPath, authType, authPrincipal, removeHostFromPrincipal, removeRealmFromPrincipal, clientSecure, keyStore, keyStoreType, keyStorePassword, trustStore, trustStoreType, trustStorePassword, juteMaxbuffer, withEnsembleTracker);
    }

    private static int getTimePeriod(NiFiProperties nifiProperties, String propertyName, String defaultValue) {
        String timeout = nifiProperties.getProperty(propertyName, defaultValue);
        try {
            return (int)FormatUtils.getTimeDuration((String)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn("Value of '" + propertyName + "' property is set to '" + timeout + "', which is not a valid time period. Using default of " + defaultValue);
            return (int)FormatUtils.getTimeDuration((String)defaultValue, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public static String getPreferredProperty(NiFiProperties properties, String preferredPropertyName, String defaultPropertyName) {
        String retrievedProperty = properties.getProperty(preferredPropertyName);
        if (StringUtils.isBlank((CharSequence)retrievedProperty)) {
            retrievedProperty = properties.getProperty(defaultPropertyName);
        }
        return retrievedProperty;
    }

    public static String cleanConnectString(String connectString) {
        String nospaces = StringUtils.deleteWhitespace((String)connectString);
        String[] hostPortPairs = StringUtils.split((String)nospaces, (String)",", (int)100);
        ArrayList<String> cleanedEntries = new ArrayList<String>(hostPortPairs.length);
        for (String pair : hostPortPairs) {
            String[] pairSplits = StringUtils.split((String)pair, (String)":", (int)3);
            if (pairSplits.length > 2 || pairSplits[0].isEmpty()) {
                throw new IllegalStateException("Invalid host:port pair entry '" + pair + "' in nifi.properties " + "nifi.zookeeper.connect.string" + "' property");
            }
            if (pairSplits.length == 1) {
                cleanedEntries.add(pairSplits[0] + ":2181");
                continue;
            }
            if (PORT_PATTERN.matcher(pairSplits[1]).matches()) {
                cleanedEntries.add(pairSplits[0] + ":" + pairSplits[1]);
                continue;
            }
            throw new IllegalStateException("The port specified in this pair must be 1 to 5 digits only but was '" + pair + "' in nifi.properties " + "nifi.zookeeper.connect.string" + "' property");
        }
        return StringUtils.join(cleanedEntries, (String)",");
    }
}

