/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientImpl;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.implementation.CryptographyService;
import com.azure.security.keyvault.keys.cryptography.models.DecryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CryptographyClientBuilder.class, isAsync=true, serviceInterfaces={CryptographyService.class})
public class CryptographyAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(CryptographyAsyncClient.class);
    private final String keyCollection;
    private final HttpPipeline pipeline;
    private volatile boolean localOperationNotSupported = false;
    private LocalKeyCryptographyClient localKeyCryptographyClient;
    final CryptographyClientImpl implClient;
    final String keyId;
    volatile JsonWebKey key;

    CryptographyAsyncClient(String keyId, HttpPipeline pipeline, CryptographyServiceVersion version) {
        this.keyCollection = CryptographyClientImpl.unpackAndValidateId(keyId);
        this.keyId = keyId;
        this.pipeline = pipeline;
        this.implClient = new CryptographyClientImpl(keyId, pipeline, version);
        this.key = null;
    }

    CryptographyAsyncClient(JsonWebKey jsonWebKey) {
        Objects.requireNonNull(jsonWebKey, "The JSON Web Key is required.");
        if (!jsonWebKey.isValid()) {
            throw new IllegalArgumentException("The JSON Web Key is not valid.");
        }
        if (jsonWebKey.getKeyOps() == null) {
            throw new IllegalArgumentException("The JSON Web Key's key operations property is not configured.");
        }
        if (jsonWebKey.getKeyType() == null) {
            throw new IllegalArgumentException("The JSON Web Key's key type property is not configured.");
        }
        this.keyCollection = null;
        this.key = jsonWebKey;
        this.keyId = jsonWebKey.getId();
        this.pipeline = null;
        this.implClient = null;
        this.localKeyCryptographyClient = CryptographyClientImpl.initializeCryptoClient(this.key, null);
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> getKey() {
        try {
            return this.getKeyWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> getKeyWithResponse() {
        try {
            return FluxUtil.withContext(this::getKeyWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> getKeyWithResponse(Context context) {
        if (this.implClient != null) {
            return this.implClient.getKeyAsync(context);
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Operation not supported when in operating local-only mode"));
    }

    Mono<JsonWebKey> getSecretKey() {
        try {
            return FluxUtil.withContext(this.implClient::getSecretKeyAsync).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EncryptResult> encrypt(EncryptionAlgorithm algorithm, byte[] plaintext) {
        return this.encrypt(algorithm, plaintext, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EncryptResult> encrypt(EncryptParameters encryptParameters) {
        try {
            return FluxUtil.withContext(context -> this.encrypt(encryptParameters, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<EncryptResult> encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, Context context) {
        return this.isValidKeyLocallyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.implClient.encryptAsync(algorithm, plaintext, context);
            }
            if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.ENCRYPT)) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Encrypt operation is missing permission/not supported for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.encryptAsync(algorithm, plaintext, this.key, context);
        });
    }

    Mono<EncryptResult> encrypt(EncryptParameters encryptParameters, Context context) {
        return this.isValidKeyLocallyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.implClient.encryptAsync(encryptParameters, context);
            }
            if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.ENCRYPT)) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Encrypt operation is missing permission/not supported for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.encryptAsync(encryptParameters, this.key, context);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DecryptResult> decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext) {
        return this.decrypt(algorithm, ciphertext, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DecryptResult> decrypt(DecryptParameters decryptParameters) {
        try {
            return FluxUtil.withContext(context -> this.decrypt(decryptParameters, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<DecryptResult> decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext, Context context) {
        return this.isValidKeyLocallyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.implClient.decryptAsync(algorithm, ciphertext, context);
            }
            if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.DECRYPT)) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Decrypt operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.decryptAsync(algorithm, ciphertext, this.key, context);
        });
    }

    Mono<DecryptResult> decrypt(DecryptParameters decryptParameters, Context context) {
        return this.isValidKeyLocallyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.implClient.decryptAsync(decryptParameters, context);
            }
            if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.DECRYPT)) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Decrypt operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.decryptAsync(decryptParameters, this.key, context);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SignResult> sign(SignatureAlgorithm algorithm, byte[] digest) {
        try {
            return FluxUtil.withContext(context -> this.sign(algorithm, digest, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<SignResult> sign(SignatureAlgorithm algorithm, byte[] digest, Context context) {
        return this.isValidKeyLocallyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.implClient.signAsync(algorithm, digest, context);
            }
            if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.SIGN)) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Sign operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.signAsync(algorithm, digest, this.key, context);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VerifyResult> verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        try {
            return FluxUtil.withContext(context -> this.verify(algorithm, digest, signature, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<VerifyResult> verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        return this.isValidKeyLocallyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.implClient.verifyAsync(algorithm, digest, signature, context);
            }
            if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.VERIFY)) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Verify operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.verifyAsync(algorithm, digest, signature, this.key, context);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WrapResult> wrapKey(KeyWrapAlgorithm algorithm, byte[] key) {
        try {
            return FluxUtil.withContext(context -> this.wrapKey(algorithm, key, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<WrapResult> wrapKey(KeyWrapAlgorithm algorithm, byte[] key, Context context) {
        return this.isValidKeyLocallyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.implClient.wrapKeyAsync(algorithm, key, context);
            }
            if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.WRAP_KEY)) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Wrap kKey operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.wrapKeyAsync(algorithm, key, this.key, context);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UnwrapResult> unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey) {
        try {
            return FluxUtil.withContext(context -> this.unwrapKey(algorithm, encryptedKey, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<UnwrapResult> unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, Context context) {
        return this.isValidKeyLocallyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.implClient.unwrapKeyAsync(algorithm, encryptedKey, context);
            }
            if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.UNWRAP_KEY)) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Unwrap key operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.unwrapKeyAsync(algorithm, encryptedKey, this.key, context);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SignResult> signData(SignatureAlgorithm algorithm, byte[] data) {
        try {
            return FluxUtil.withContext(context -> this.signData(algorithm, data, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<SignResult> signData(SignatureAlgorithm algorithm, byte[] data, Context context) {
        return this.isValidKeyLocallyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.implClient.signDataAsync(algorithm, data, context);
            }
            if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.SIGN)) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Sign operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.signDataAsync(algorithm, data, this.key, context);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VerifyResult> verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature) {
        try {
            return FluxUtil.withContext(context -> this.verifyData(algorithm, data, signature, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<VerifyResult> verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, Context context) {
        return this.isValidKeyLocallyAvailable().flatMap(available -> {
            if (!available.booleanValue()) {
                return this.implClient.verifyDataAsync(algorithm, data, signature, context);
            }
            if (!CryptographyClientImpl.checkKeyPermissions(this.key.getKeyOps(), KeyOperation.VERIFY)) {
                return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Verify operation is not allowed for key with id: %s", this.key.getId()))));
            }
            return this.localKeyCryptographyClient.verifyDataAsync(algorithm, data, signature, this.key, context);
        });
    }

    private Mono<Boolean> isValidKeyLocallyAvailable() {
        boolean keyNotAvailable;
        if (this.localOperationNotSupported) {
            return Mono.just((Object)false);
        }
        boolean bl = keyNotAvailable = this.key == null && this.keyCollection != null;
        if (keyNotAvailable) {
            if (Objects.equals(this.keyCollection, "secrets")) {
                return this.getSecretKey().map(jsonWebKey -> {
                    this.key = jsonWebKey;
                    if (this.key.isValid()) {
                        if (this.localKeyCryptographyClient == null) {
                            try {
                                this.localKeyCryptographyClient = CryptographyClientImpl.initializeCryptoClient(this.key, this.implClient);
                            }
                            catch (RuntimeException e) {
                                this.localOperationNotSupported = true;
                                LOGGER.warning("Defaulting to service use for cryptographic operations.", new Object[]{e});
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                });
            }
            return this.getKey().map(keyVaultKey -> {
                this.key = keyVaultKey.getKey();
                if (this.key.isValid()) {
                    if (this.localKeyCryptographyClient == null) {
                        try {
                            this.localKeyCryptographyClient = CryptographyClientImpl.initializeCryptoClient(this.key, this.implClient);
                        }
                        catch (RuntimeException e) {
                            this.localOperationNotSupported = true;
                            LOGGER.warning("Defaulting to service use for cryptographic operations.", new Object[]{e});
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            });
        }
        return Mono.just((Object)true);
    }
}

