/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VfsSettings {
    static final String NEXT_FREE_PATH_ID = "jetbrains.exodus.vfs.settings.nextFreePathId";
    @NotNull
    private final Environment env;
    @NotNull
    private final Store settingStore;

    VfsSettings(@NotNull Environment env, @NotNull Store settingStore) {
        this.env = env;
        this.settingStore = settingStore;
    }

    ByteIterable get(@Nullable Transaction txn, @NotNull String settingName) {
        ArrayByteIterable key = StringBinding.stringToEntry((String)settingName);
        if (txn != null) {
            return this.settingStore.get(txn, (ByteIterable)key);
        }
        ByteIterable[] result = new ByteIterable[1];
        this.env.executeInTransaction(txn1 -> {
            result[0] = this.settingStore.get(txn1, (ByteIterable)key);
        });
        return result[0];
    }

    void put(@Nullable Transaction txn, @NotNull String settingName, @NotNull ByteIterable bi) {
        ArrayByteIterable key = StringBinding.stringToEntry((String)settingName);
        if (txn != null) {
            this.settingStore.put(txn, (ByteIterable)key, bi);
        } else {
            this.env.executeInTransaction(txn1 -> this.settingStore.put(txn1, (ByteIterable)key, bi));
        }
    }
}

