/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.AbstractMemoryCR;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;

public class MemoryCMRImpl
extends AbstractMemoryCR
implements MemoryCMR {
    private static final Log LOG = LogFactory.getLog(MemoryCMRImpl.class);
    protected int memoryTag = 0;
    private int madviseOpts = -1;

    public MemoryCMRImpl(FilesFacade ff, LPSZ name, long size, int memoryTag) {
        this.of(ff, name, 0L, size, memoryTag, 0L);
    }

    public MemoryCMRImpl() {
    }

    @Override
    public void close() {
        this.clear();
        if (this.pageAddress != 0L) {
            this.ff.munmap(this.pageAddress, this.size, this.memoryTag);
            LOG.debug().$("unmapped [pageAddress=").$(this.pageAddress).$(", size=").$(this.size).$(", tag=").$(this.memoryTag).I$();
            this.size = 0L;
            this.pageAddress = 0L;
        }
        if (this.ff != null && this.ff.close(this.fd)) {
            LOG.debug().$("closed [fd=").$(this.fd).I$();
            this.fd = -1;
        }
    }

    @Override
    public void extend(long newSize) {
        if (newSize > this.size) {
            this.setSize0(newSize);
        }
    }

    @Override
    public boolean isMapped(long offset, long len) {
        return offset + len <= this.size();
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long extendSegmentSize, long size, int memoryTag, long opts, int madviseOpts) {
        this.memoryTag = memoryTag;
        this.madviseOpts = madviseOpts;
        this.openFile(ff, name);
        if (size < 0L && (size = ff.length(this.fd)) < 0L) {
            this.close();
            throw CairoException.critical(ff.errno()).put("could not get length: ").put(name);
        }
        this.map(ff, name, size);
    }

    @Override
    public void smallFile(FilesFacade ff, LPSZ name, int memoryTag) {
        this.of(ff, name, ff.getPageSize(), -1L, memoryTag, 0L, -1);
    }

    @Override
    public void wholeFile(FilesFacade ff, LPSZ name, int memoryTag) {
        this.of(ff, name, ff.getMapPageSize(), -1L, memoryTag, 0L, -1);
    }

    private void openFile(FilesFacade ff, LPSZ name) {
        this.close();
        this.ff = ff;
        this.fd = TableUtils.openRO(ff, name, LOG);
    }

    private void setSize0(long newSize) {
        try {
            if (this.size > 0L) {
                this.pageAddress = TableUtils.mremap(this.ff, this.fd, this.pageAddress, this.size, newSize, 1, this.memoryTag);
            } else {
                assert (this.pageAddress == 0L);
                this.pageAddress = TableUtils.mapRO(this.ff, this.fd, newSize, this.memoryTag);
            }
            this.ff.madvise(this.pageAddress, newSize, this.madviseOpts);
            this.size = newSize;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    protected void map(FilesFacade ff, LPSZ name, long size) {
        this.size = size;
        if (size > 0L) {
            try {
                this.pageAddress = TableUtils.mapRO(ff, this.fd, size, this.memoryTag);
                ff.madvise(this.pageAddress, size, this.madviseOpts);
            }
            catch (Throwable e) {
                this.close();
                throw e;
            }
        } else {
            assert (size > -1L);
            this.pageAddress = 0L;
        }
        LOG.debug().$("map  [file=").$(name).$(", fd=").$(this.fd).$(", pageSize=").$(size).$(", size=").$(this.size).$(']').$();
    }
}

