/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mig;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.Path;

class MigrationContext {
    private final CairoEngine engine;
    private final MemoryMARW rwMemory;
    private final long tempMemory;
    private final int tempMemoryLen;
    private final MemoryARW tempVirtualMem;
    private int metadataFd;
    private Path tablePath;
    private Path tablePath2;

    public MigrationContext(CairoEngine engine, long mem, int tempMemSize, MemoryARW tempVirtualMem, MemoryMARW rwMemory) {
        this.engine = engine;
        this.tempMemory = mem;
        this.tempMemoryLen = tempMemSize;
        this.tempVirtualMem = tempVirtualMem;
        this.rwMemory = rwMemory;
    }

    public MemoryMARW createRwMemoryOf(FilesFacade ff, Path path) {
        this.rwMemory.smallFile(ff, path, 45);
        return this.rwMemory;
    }

    public CairoConfiguration getConfiguration() {
        return this.engine.getConfiguration();
    }

    public FilesFacade getFf() {
        return this.getConfiguration().getFilesFacade();
    }

    public int getMetadataFd() {
        return this.metadataFd;
    }

    public int getNextTableId() {
        return (int)this.engine.getTableIdGenerator().getNextId();
    }

    public MemoryMARW getRwMemory() {
        return this.rwMemory;
    }

    public Path getTablePath() {
        return this.tablePath;
    }

    public Path getTablePath2() {
        return this.tablePath2;
    }

    public long getTempMemory() {
        return this.tempMemory;
    }

    public long getTempMemory(int size) {
        if (size <= this.tempMemoryLen) {
            return this.tempMemory;
        }
        throw new UnsupportedOperationException("No temp memory of size " + size + " is allocate. Only " + this.tempMemoryLen + " is available");
    }

    public MemoryARW getTempVirtualMem() {
        return this.tempVirtualMem;
    }

    public void of(Path path, Path pathCopy, int metadataFd) {
        this.tablePath = path;
        this.tablePath2 = pathCopy;
        this.metadataFd = metadataFd;
    }
}

