/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.exception.ResourceNotFoundException;
import org.apache.nifi.registry.security.authorization.AuthorizableLookup;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.security.authorization.Resource;
import org.apache.nifi.registry.security.authorization.resource.Authorizable;
import org.apache.nifi.registry.security.authorization.resource.InheritingAuthorizable;
import org.apache.nifi.registry.security.authorization.resource.ProxyChainAuthorizable;
import org.apache.nifi.registry.security.authorization.resource.PublicCheckingAuthorizable;
import org.apache.nifi.registry.security.authorization.resource.ResourceFactory;
import org.apache.nifi.registry.security.authorization.resource.ResourceType;
import org.apache.nifi.registry.service.RegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StandardAuthorizableLookup
implements AuthorizableLookup {
    private static final Logger logger = LoggerFactory.getLogger(StandardAuthorizableLookup.class);
    private static final Authorizable TENANTS_AUTHORIZABLE = new Authorizable(){

        @Override
        public Authorizable getParentAuthorizable() {
            return null;
        }

        @Override
        public Resource getResource() {
            return ResourceFactory.getTenantsResource();
        }
    };
    private static final Authorizable POLICIES_AUTHORIZABLE = new Authorizable(){

        @Override
        public Authorizable getParentAuthorizable() {
            return null;
        }

        @Override
        public Resource getResource() {
            return ResourceFactory.getPoliciesResource();
        }
    };
    private static final Authorizable BUCKETS_AUTHORIZABLE = new Authorizable(){

        @Override
        public Authorizable getParentAuthorizable() {
            return null;
        }

        @Override
        public Resource getResource() {
            return ResourceFactory.getBucketsResource();
        }
    };
    private static final Authorizable PROXY_AUTHORIZABLE = new Authorizable(){

        @Override
        public Authorizable getParentAuthorizable() {
            return null;
        }

        @Override
        public Resource getResource() {
            return ResourceFactory.getProxyResource();
        }
    };
    private static final Authorizable ACTUATOR_AUTHORIZABLE = new Authorizable(){

        @Override
        public Authorizable getParentAuthorizable() {
            return null;
        }

        @Override
        public Resource getResource() {
            return ResourceFactory.getActuatorResource();
        }
    };
    private static final Authorizable SWAGGER_AUTHORIZABLE = new Authorizable(){

        @Override
        public Authorizable getParentAuthorizable() {
            return null;
        }

        @Override
        public Resource getResource() {
            return ResourceFactory.getSwaggerResource();
        }
    };
    private final RegistryService registryService;

    @Autowired
    public StandardAuthorizableLookup(RegistryService registryService) {
        this.registryService = Objects.requireNonNull(registryService);
    }

    @Override
    public Authorizable getActuatorAuthorizable() {
        return new ProxyChainAuthorizable(ACTUATOR_AUTHORIZABLE, PROXY_AUTHORIZABLE, this::isPublicAccessAllowed);
    }

    @Override
    public Authorizable getSwaggerAuthorizable() {
        return new ProxyChainAuthorizable(SWAGGER_AUTHORIZABLE, PROXY_AUTHORIZABLE, this::isPublicAccessAllowed);
    }

    @Override
    public Authorizable getProxyAuthorizable() {
        return PROXY_AUTHORIZABLE;
    }

    @Override
    public Authorizable getTenantsAuthorizable() {
        return new ProxyChainAuthorizable(TENANTS_AUTHORIZABLE, PROXY_AUTHORIZABLE, this::isPublicAccessAllowed);
    }

    @Override
    public Authorizable getPoliciesAuthorizable() {
        return new ProxyChainAuthorizable(POLICIES_AUTHORIZABLE, PROXY_AUTHORIZABLE, this::isPublicAccessAllowed);
    }

    @Override
    public Authorizable getBucketsAuthorizable() {
        return new ProxyChainAuthorizable(BUCKETS_AUTHORIZABLE, PROXY_AUTHORIZABLE, this::isPublicAccessAllowed);
    }

    @Override
    public Authorizable getBucketAuthorizable(final String bucketIdentifier) {
        InheritingAuthorizable inheritingAuthorizable = new InheritingAuthorizable(){

            @Override
            public Authorizable getParentAuthorizable() {
                return BUCKETS_AUTHORIZABLE;
            }

            @Override
            public Resource getResource() {
                return ResourceFactory.getBucketResource(bucketIdentifier, "Bucket with ID " + bucketIdentifier);
            }
        };
        PublicCheckingAuthorizable publicCheckingAuthorizable = new PublicCheckingAuthorizable(inheritingAuthorizable, this::isPublicAccessAllowed);
        return new ProxyChainAuthorizable(publicCheckingAuthorizable, PROXY_AUTHORIZABLE, this::isPublicAccessAllowed);
    }

    @Override
    public Authorizable getAuthorizableByResource(String resource) {
        ResourceType resourceType = ResourceType.mapFullResourcePathToResourceType(resource);
        if (resourceType == null) {
            throw new ResourceNotFoundException("Unrecognized resource: " + resource);
        }
        return this.getAuthorizableByResource(resourceType, resource);
    }

    private Authorizable getAuthorizableByResource(ResourceType resourceType, String resource) {
        Authorizable authorizable = null;
        switch (resourceType) {
            case Policy: {
                authorizable = this.getPoliciesAuthorizable();
                break;
            }
            case Tenant: {
                authorizable = this.getTenantsAuthorizable();
                break;
            }
            case Proxy: {
                authorizable = this.getProxyAuthorizable();
                break;
            }
            case Actuator: {
                authorizable = this.getActuatorAuthorizable();
                break;
            }
            case Swagger: {
                authorizable = this.getSwaggerAuthorizable();
                break;
            }
            case Bucket: {
                String childResourceId = StringUtils.substringAfter((String)resource, (String)resourceType.getValue());
                authorizable = childResourceId.startsWith("/") ? this.getAuthorizableByChildResource(resourceType, childResourceId) : this.getBucketsAuthorizable();
            }
        }
        if (authorizable == null) {
            logger.debug("Could not determine the Authorizable for resource type='{}', path='{}', ", (Object)resourceType.getValue(), (Object)resource);
            throw new IllegalArgumentException("This an unexpected type of authorizable resource: " + resourceType.getValue());
        }
        return authorizable;
    }

    private Authorizable getAuthorizableByChildResource(ResourceType baseResourceType, String childResourceId) {
        Authorizable authorizable;
        switch (baseResourceType) {
            case Bucket: {
                String[] childResourcePathParts = childResourceId.split("/");
                if (childResourcePathParts.length >= 1) {
                    String bucketId = childResourcePathParts[1];
                    authorizable = this.getBucketAuthorizable(bucketId);
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unexpected lookup for child resource authorizable for base resource type " + baseResourceType.getValue());
            }
        }
        return authorizable;
    }

    private boolean isPublicAccessAllowed(Resource resource, RequestAction action) {
        if (resource == null || action == null) {
            return false;
        }
        if (action != RequestAction.READ) {
            return false;
        }
        String resourceIdentifier = resource.getIdentifier();
        if (resourceIdentifier == null || !resourceIdentifier.startsWith(ResourceType.Bucket.getValue() + "/")) {
            return false;
        }
        int lastSlashIndex = resourceIdentifier.lastIndexOf("/");
        if (lastSlashIndex < 0 || lastSlashIndex >= resourceIdentifier.length() - 1) {
            return false;
        }
        String bucketId = resourceIdentifier.substring(lastSlashIndex + 1);
        try {
            Bucket bucket = this.registryService.getBucket(bucketId);
            return bucket.isAllowPublicRead();
        }
        catch (ResourceNotFoundException rnfe) {
            logger.debug("Cannot determine public access, bucket not found with id [{}]", new Object[]{bucketId});
            return false;
        }
        catch (Exception e) {
            logger.error("Error checking public access to bucket with id [{}]", (Object)new Object[]{bucketId}, (Object)e);
            return false;
        }
    }
}

