/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class SecretRestoreParameters
implements JsonSerializable<SecretRestoreParameters> {
    private Base64Url secretBundleBackup;

    public byte[] getSecretBundleBackup() {
        if (this.secretBundleBackup == null) {
            return new byte[0];
        }
        return this.secretBundleBackup.decodedBytes();
    }

    public SecretRestoreParameters setSecretBundleBackup(byte[] secretBundleBackup) {
        this.secretBundleBackup = secretBundleBackup == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])secretBundleBackup));
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", Objects.toString(this.secretBundleBackup, null));
        return jsonWriter.writeEndObject();
    }

    public static SecretRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SecretRestoreParameters)jsonReader.readObject(reader -> {
            SecretRestoreParameters deserializedSecretRestoreParameters = new SecretRestoreParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedSecretRestoreParameters.secretBundleBackup = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretRestoreParameters;
        });
    }
}

