/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.okhttp.implementation.OkHttpAsyncBufferedResponse;
import com.azure.core.http.okhttp.implementation.OkHttpAsyncResponse;
import com.azure.core.http.okhttp.implementation.OkHttpFileRequestBody;
import com.azure.core.http.okhttp.implementation.OkHttpFluxRequestBody;
import com.azure.core.http.okhttp.implementation.OkHttpInputStreamRequestBody;
import com.azure.core.http.okhttp.implementation.OkHttpProgressReportingRequestBody;
import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.implementation.util.ByteArrayContent;
import com.azure.core.implementation.util.ByteBufferContent;
import com.azure.core.implementation.util.FileContent;
import com.azure.core.implementation.util.InputStreamContent;
import com.azure.core.implementation.util.SerializableContent;
import com.azure.core.implementation.util.StringContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.Contexts;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.UncheckedIOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class OkHttpAsyncHttpClient
implements HttpClient {
    private static final ClientLogger LOGGER = new ClientLogger(OkHttpAsyncHttpClient.class);
    private static final byte[] EMPTY_BODY = new byte[0];
    private static final RequestBody EMPTY_REQUEST_BODY = RequestBody.create((byte[])EMPTY_BODY);
    private static final String AZURE_EAGERLY_READ_RESPONSE = "azure-eagerly-read-response";
    private static final String AZURE_IGNORE_RESPONSE_BODY = "azure-ignore-response-body";
    private static final String AZURE_EAGERLY_CONVERT_HEADERS = "azure-eagerly-convert-headers";
    final OkHttpClient httpClient;

    OkHttpAsyncHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        boolean eagerlyReadResponse = context.getData((Object)AZURE_EAGERLY_READ_RESPONSE).orElse(false);
        boolean ignoreResponseBody = context.getData((Object)AZURE_IGNORE_RESPONSE_BODY).orElse(false);
        boolean eagerlyConvertHeaders = context.getData((Object)AZURE_EAGERLY_CONVERT_HEADERS).orElse(false);
        ProgressReporter progressReporter = Contexts.with((Context)context).getHttpRequestProgressReporter();
        return Mono.create(sink -> sink.onRequest(value -> Mono.fromCallable(() -> this.toOkHttpRequest(request, progressReporter)).subscribe(okHttpRequest -> {
            try {
                Call call = this.httpClient.newCall(okHttpRequest);
                call.enqueue((Callback)new OkHttpCallback((MonoSink<HttpResponse>)sink, request, eagerlyReadResponse, ignoreResponseBody, eagerlyConvertHeaders));
                sink.onCancel(() -> ((Call)call).cancel());
            }
            catch (Exception ex) {
                sink.error((Throwable)ex);
            }
        }, arg_0 -> ((MonoSink)sink).error(arg_0))));
    }

    public HttpResponse sendSync(HttpRequest request, Context context) {
        boolean eagerlyReadResponse = context.getData((Object)AZURE_EAGERLY_READ_RESPONSE).orElse(false);
        boolean ignoreResponseBody = context.getData((Object)AZURE_IGNORE_RESPONSE_BODY).orElse(false);
        boolean eagerlyConvertHeaders = context.getData((Object)AZURE_EAGERLY_CONVERT_HEADERS).orElse(false);
        ProgressReporter progressReporter = Contexts.with((Context)context).getHttpRequestProgressReporter();
        Request okHttpRequest = this.toOkHttpRequest(request, progressReporter);
        try {
            Response okHttpResponse = this.httpClient.newCall(okHttpRequest).execute();
            return OkHttpAsyncHttpClient.toHttpResponse(request, okHttpResponse, eagerlyReadResponse, ignoreResponseBody, eagerlyConvertHeaders);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    private Request toOkHttpRequest(HttpRequest request, ProgressReporter progressReporter) {
        Request.Builder requestBuilder = new Request.Builder().url(request.getUrl());
        if (request.getHeaders() != null) {
            for (HttpHeader hdr : request.getHeaders()) {
                hdr.getValuesList().forEach(value -> requestBuilder.addHeader(hdr.getName(), value));
            }
        }
        if (request.getHttpMethod() == HttpMethod.GET) {
            return requestBuilder.get().build();
        }
        if (request.getHttpMethod() == HttpMethod.HEAD) {
            return requestBuilder.head().build();
        }
        RequestBody okHttpRequestBody = this.toOkHttpRequestBody(request.getBodyAsBinaryData(), request.getHeaders());
        if (progressReporter != null) {
            okHttpRequestBody = new OkHttpProgressReportingRequestBody(okHttpRequestBody, progressReporter);
        }
        return requestBuilder.method(request.getHttpMethod().toString(), okHttpRequestBody).build();
    }

    private RequestBody toOkHttpRequestBody(BinaryData bodyContent, HttpHeaders headers) {
        if (bodyContent == null) {
            return EMPTY_REQUEST_BODY;
        }
        String contentType = headers.getValue(HttpHeaderName.CONTENT_TYPE);
        MediaType mediaType = contentType == null ? null : MediaType.parse((String)contentType);
        BinaryDataContent content = BinaryDataHelper.getContent((BinaryData)bodyContent);
        if (content instanceof ByteArrayContent || content instanceof StringContent || content instanceof SerializableContent || content instanceof ByteBufferContent) {
            return RequestBody.create((byte[])content.toBytes(), (MediaType)mediaType);
        }
        long effectiveContentLength = OkHttpAsyncHttpClient.getRequestContentLength(content, headers);
        if (content instanceof InputStreamContent) {
            return new OkHttpInputStreamRequestBody((InputStreamContent)content, effectiveContentLength, mediaType);
        }
        if (content instanceof FileContent) {
            return new OkHttpFileRequestBody((FileContent)content, effectiveContentLength, mediaType);
        }
        return new OkHttpFluxRequestBody(content, effectiveContentLength, mediaType, this.httpClient.callTimeoutMillis());
    }

    private static long getRequestContentLength(BinaryDataContent content, HttpHeaders headers) {
        Long contentLength = content.getLength();
        if (contentLength == null) {
            String contentLengthHeaderValue = headers.getValue(HttpHeaderName.CONTENT_LENGTH);
            contentLength = contentLengthHeaderValue != null ? Long.valueOf(Long.parseLong(contentLengthHeaderValue)) : Long.valueOf(-1L);
        }
        return contentLength;
    }

    private static HttpResponse toHttpResponse(HttpRequest request, Response response, boolean eagerlyReadResponse, boolean ignoreResponseBody, boolean eagerlyConvertHeaders) throws IOException {
        if (eagerlyReadResponse || ignoreResponseBody) {
            try (ResponseBody body = response.body();){
                byte[] bytes = body != null ? body.bytes() : EMPTY_BODY;
                OkHttpAsyncBufferedResponse okHttpAsyncBufferedResponse = new OkHttpAsyncBufferedResponse(response, request, bytes, eagerlyConvertHeaders);
                return okHttpAsyncBufferedResponse;
            }
        }
        return new OkHttpAsyncResponse(response, request, eagerlyConvertHeaders);
    }

    private static class OkHttpCallback
    implements Callback {
        private final MonoSink<HttpResponse> sink;
        private final HttpRequest request;
        private final boolean eagerlyReadResponse;
        private final boolean ignoreResponseBody;
        private final boolean eagerlyConvertHeaders;

        OkHttpCallback(MonoSink<HttpResponse> sink, HttpRequest request, boolean eagerlyReadResponse, boolean ignoreResponseBody, boolean eagerlyConvertHeaders) {
            this.sink = sink;
            this.request = request;
            this.eagerlyReadResponse = eagerlyReadResponse;
            this.ignoreResponseBody = ignoreResponseBody;
            this.eagerlyConvertHeaders = eagerlyConvertHeaders;
        }

        public void onFailure(Call call, IOException e) {
            if (e.getSuppressed().length == 1) {
                this.sink.error(e.getSuppressed()[0]);
            } else {
                this.sink.error((Throwable)e);
            }
        }

        public void onResponse(Call call, Response response) {
            try {
                this.sink.success((Object)OkHttpAsyncHttpClient.toHttpResponse(this.request, response, this.eagerlyReadResponse, this.ignoreResponseBody, this.eagerlyConvertHeaders));
            }
            catch (IOException ex) {
                this.sink.error((Throwable)ex);
            }
        }
    }
}

