/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.remote.client.AbstractPeerPersistence;
import org.apache.nifi.remote.util.PeerStatusCache;

public class StatePeerPersistence
extends AbstractPeerPersistence {
    static final String STATE_KEY_PEERS = "peers";
    static final String STATE_KEY_TRANSPORT_PROTOCOL = "protocol";
    static final String STATE_KEY_PEERS_TIMESTAMP = "peers.ts";
    private final StateManager stateManager;

    public StatePeerPersistence(StateManager stateManager) {
        this.stateManager = stateManager;
    }

    @Override
    public void save(PeerStatusCache peerStatusCache) throws IOException {
        StateMap state = this.stateManager.getState(Scope.LOCAL);
        Map stateMap = state.toMap();
        HashMap<String, String> updatedStateMap = new HashMap<String, String>(stateMap);
        StringBuilder peers = new StringBuilder();
        this.write(peerStatusCache, peers::append);
        updatedStateMap.put(STATE_KEY_PEERS, peers.toString());
        updatedStateMap.put(STATE_KEY_PEERS_TIMESTAMP, String.valueOf(System.currentTimeMillis()));
        this.stateManager.setState(updatedStateMap, Scope.LOCAL);
    }

    @Override
    public PeerStatusCache restore() throws IOException {
        StateMap state = this.stateManager.getState(Scope.LOCAL);
        String storedPeers = state.get(STATE_KEY_PEERS);
        if (storedPeers != null && !storedPeers.isEmpty()) {
            try (BufferedReader reader = new BufferedReader(new StringReader(storedPeers));){
                PeerStatusCache peerStatusCache = this.restorePeerStatuses(reader, Long.parseLong(state.get(STATE_KEY_PEERS_TIMESTAMP)));
                return peerStatusCache;
            }
        }
        return null;
    }
}

