/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.tree.INode;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.ITreeCursor;
import jetbrains.exodus.tree.TreeTraverser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeCursor
implements ITreeCursor {
    @NotNull
    final TreeTraverser traverser;
    protected boolean canGoDown;
    boolean alreadyIn;
    boolean inited;

    public TreeCursor(@NotNull TreeTraverser traverser) {
        this(traverser, false);
    }

    public TreeCursor(@NotNull TreeTraverser traverser, boolean alreadyIn) {
        this.traverser = traverser;
        this.alreadyIn = alreadyIn;
        this.canGoDown = true;
        this.inited = false;
    }

    protected boolean hasNext() {
        if (this.inited) {
            return this.traverser.canMoveRight() || this.advance();
        }
        return this.traverser.isNotEmpty();
    }

    protected boolean hasPrev() {
        if (this.inited) {
            return this.traverser.canMoveLeft() || this.retreat();
        }
        return this.traverser.isNotEmpty();
    }

    public boolean getNext() {
        if (!this.inited) {
            this.traverser.init(true);
            this.inited = true;
        }
        if (this.alreadyIn) {
            this.alreadyIn = false;
            return true;
        }
        boolean result = this.moveToNext();
        if (!result) {
            this.traverser.init(false);
            this.canGoDown = true;
            this.moveToPrev();
        }
        return result;
    }

    public boolean getPrev() {
        if (!this.inited) {
            this.traverser.init(false);
            this.inited = true;
        }
        if (this.alreadyIn) {
            this.alreadyIn = false;
            return true;
        }
        boolean result = this.moveToPrev();
        if (!result) {
            this.traverser.init(true);
            this.canGoDown = true;
            this.moveToNext();
        }
        return result;
    }

    public boolean getLast() {
        while (this.traverser.canMoveUp()) {
            this.traverser.moveUp();
        }
        this.traverser.init(false);
        this.inited = true;
        this.alreadyIn = !this.traverser.isNotEmpty() && this.traverser.hasValue();
        return this.getPrev();
    }

    @NotNull
    public ByteIterable getKey() {
        return this.traverser.getKey();
    }

    @NotNull
    public ByteIterable getValue() {
        return this.traverser.getValue();
    }

    public boolean getNextDup() {
        return this.traverser.getKey() == ByteIterable.EMPTY && this.getNext();
    }

    public boolean getNextNoDup() {
        return this.getNext();
    }

    public boolean getPrevDup() {
        return this.getPrev();
    }

    public boolean getPrevNoDup() {
        return this.getPrev();
    }

    public ByteIterable getSearchKey(@NotNull ByteIterable key) {
        return this.moveTo(key, null, false);
    }

    public ByteIterable getSearchKeyRange(@NotNull ByteIterable key) {
        return this.moveTo(key, null, true);
    }

    public boolean getSearchBoth(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return this.moveTo(key, value, false) != null;
    }

    public ByteIterable getSearchBothRange(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return this.moveTo(key, value, true);
    }

    public int count() {
        return 1;
    }

    public void close() {
    }

    public boolean deleteCurrent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public ITree getTree() {
        return this.traverser.getTree();
    }

    @Nullable
    protected ByteIterable moveTo(@NotNull ByteIterable key, @Nullable ByteIterable value, boolean rangeSearch) {
        if (rangeSearch ? this.traverser.moveToRange(key, value) : this.traverser.moveTo(key, value)) {
            this.canGoDown = true;
            this.alreadyIn = false;
            this.inited = true;
            return this.traverser.getValue();
        }
        return null;
    }

    private boolean moveToNext() {
        while (true) {
            if (this.canGoDown) {
                if (this.traverser.canMoveDown()) {
                    if (!this.traverser.moveDown().hasValue()) continue;
                    return true;
                }
            } else {
                this.canGoDown = true;
            }
            if (this.traverser.canMoveRight()) {
                INode node = this.traverser.moveRight();
                if (this.traverser.canMoveDown() || !node.hasValue()) continue;
                return true;
            }
            if (!this.advance()) break;
        }
        return false;
    }

    private boolean moveToPrev() {
        while (true) {
            if (this.canGoDown) {
                if (this.traverser.canMoveDown()) {
                    if (!this.traverser.moveDownToLast().hasValue()) continue;
                    return true;
                }
            } else {
                this.canGoDown = true;
            }
            if (this.traverser.canMoveLeft()) {
                INode node = this.traverser.moveLeft();
                if (this.traverser.canMoveDown() || !node.hasValue()) continue;
                return true;
            }
            if (!this.retreat()) break;
        }
        return false;
    }

    private boolean advance() {
        while (this.traverser.canMoveUp()) {
            if (this.traverser.canMoveRight()) {
                return true;
            }
            this.traverser.moveUp();
            this.canGoDown = false;
        }
        return this.traverser.canMoveRight();
    }

    private boolean retreat() {
        while (this.traverser.canMoveUp()) {
            if (this.traverser.canMoveLeft()) {
                return true;
            }
            this.traverser.moveUp();
            this.canGoDown = false;
        }
        return this.traverser.canMoveLeft();
    }
}

