/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.util.FormatUtils;

public class StandardValidators {
    public static final Validator ATTRIBUTE_KEY_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            ValidationResult.Builder builder = new ValidationResult.Builder();
            builder.subject(subject).input(input);
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return builder.valid(true).explanation("Contains Expression Language").build();
            }
            try {
                FlowFile.KeyValidator.validateKey((String)input);
                builder.valid(true);
            }
            catch (IllegalArgumentException e) {
                builder.valid(false).explanation(e.getMessage());
            }
            return builder.build();
        }
    };
    public static final Validator ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            ValidationResult.Builder builder = new ValidationResult.Builder();
            builder.subject("Property Name").input(subject);
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return builder.valid(true).explanation("Contains Expression Language").build();
            }
            try {
                FlowFile.KeyValidator.validateKey((String)subject);
                builder.valid(true);
            }
            catch (IllegalArgumentException e) {
                builder.valid(false).explanation(e.getMessage());
            }
            return builder.build();
        }
    };
    public static final Validator POSITIVE_INTEGER_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
                return new ValidationResult.Builder().subject(subject).input(value).explanation("Expression Language Present").valid(true).build();
            }
            String reason = null;
            try {
                int intVal = Integer.parseInt(value);
                if (intVal <= 0) {
                    reason = "not a positive value";
                }
            }
            catch (NumberFormatException e) {
                reason = "not a valid integer";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    };
    public static final Validator POSITIVE_LONG_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
                return new ValidationResult.Builder().subject(subject).input(value).explanation("Expression Language Present").valid(true).build();
            }
            String reason = null;
            try {
                long longVal = Long.parseLong(value);
                if (longVal <= 0L) {
                    reason = "not a positive value";
                }
            }
            catch (NumberFormatException e) {
                reason = "not a valid 64-bit integer";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    };
    public static final Validator NUMBER_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
                return new ValidationResult.Builder().subject(subject).input(value).explanation("Expression Language Present").valid(true).build();
            }
            String reason = null;
            try {
                NumberFormat.getInstance().parse(value);
            }
            catch (ParseException e) {
                reason = "not a valid Number";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    };
    public static final Validator PORT_VALIDATOR = StandardValidators.createLongValidator(0L, 65535L, true);
    public static final Validator NON_EMPTY_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            return new ValidationResult.Builder().subject(subject).input(value).valid(value != null && !value.isEmpty()).explanation(subject + " cannot be empty").build();
        }
    };
    public static final Validator NON_EMPTY_EL_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
            }
            return NON_EMPTY_VALIDATOR.validate(subject, input, context);
        }
    };
    public static final Validator HOSTNAME_PORT_LIST_VALIDATOR = new Validator(){
        private final Validator NON_ZERO_PORT_VALIDATOR = StandardValidators.createLongValidator(1L, 65535L, true);

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            String[] hostnamePortList;
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
            }
            ValidationResult nonEmptyValidatorResult = NON_EMPTY_VALIDATOR.validate(subject, input, context);
            if (!nonEmptyValidatorResult.isValid()) {
                return nonEmptyValidatorResult;
            }
            for (String hostnamePort : hostnamePortList = input.split(",")) {
                String[] addresses = hostnamePort.split(":");
                if (addresses.length != 2) {
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Must be in hostname:port form (no scheme such as http://").valid(false).build();
                }
                String port = addresses[1].trim();
                ValidationResult portValidatorResult = this.NON_ZERO_PORT_VALIDATOR.validate(subject, port, context);
                if (portValidatorResult.isValid()) continue;
                return portValidatorResult;
            }
            return new ValidationResult.Builder().subject(subject).input(input).explanation("Valid cluster definition").valid(true).build();
        }
    };
    public static final Validator NON_BLANK_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            return new ValidationResult.Builder().subject(subject).input(value).valid(value != null && !value.trim().isEmpty()).explanation(subject + " must contain at least one character that is not white space").build();
        }
    };
    public static final Validator BOOLEAN_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
                return new ValidationResult.Builder().subject(subject).input(value).explanation("Expression Language Present").valid(true).build();
            }
            boolean valid = "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
            String explanation = valid ? null : "Value must be 'true' or 'false'";
            return new ValidationResult.Builder().subject(subject).input(value).valid(valid).explanation(explanation).build();
        }
    };
    public static final Validator INTEGER_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
                return new ValidationResult.Builder().subject(subject).input(value).explanation("Expression Language Present").valid(true).build();
            }
            String reason = null;
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                reason = "not a valid integer";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    };
    public static final Validator LONG_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
                return new ValidationResult.Builder().subject(subject).input(value).explanation("Expression Language Present").valid(true).build();
            }
            String reason = null;
            try {
                Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                reason = "not a valid Long";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    };
    public static final Validator ISO8601_INSTANT_VALIDATOR;
    @Deprecated
    public static final Validator ISO8061_INSTANT_VALIDATOR;
    public static final Validator NON_NEGATIVE_INTEGER_VALIDATOR;
    public static final Validator CHARACTER_SET_VALIDATOR;
    public static final Validator CHARACTER_SET_VALIDATOR_WITH_EVALUATION;
    public static final Validator SINGLE_CHAR_VALIDATOR;
    public static final Validator URL_VALIDATOR;
    public static final Validator URI_VALIDATOR;
    public static final Validator URI_LIST_VALIDATOR;
    public static final Validator REGULAR_EXPRESSION_VALIDATOR;
    public static final Validator REGULAR_EXPRESSION_WITH_EL_VALIDATOR;
    public static final Validator ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR;
    public static final Validator TIME_PERIOD_VALIDATOR;
    public static final Validator DATA_SIZE_VALIDATOR;
    public static final Validator FILE_EXISTS_VALIDATOR;

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static Validator createDirectoryExistsValidator(boolean allowExpressionLanguage, boolean createDirectoryIfMissing) {
        return new DirectoryExistsValidator(allowExpressionLanguage, createDirectoryIfMissing);
    }

    private static Validator createURLValidator() {
        return new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
                }
                try {
                    String evaluatedInput = context.newPropertyValue(input).evaluateAttributeExpressions().getValue();
                    URI.create(evaluatedInput).toURL();
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Valid URL").valid(true).build();
                }
                catch (Exception e) {
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Not a valid URL").valid(false).build();
                }
            }
        };
    }

    @Deprecated
    public static Validator createURLorFileValidator() {
        return (subject, input, context) -> {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
            }
            try {
                PropertyValue propertyValue = context.newPropertyValue(input);
                String evaluatedInput = propertyValue == null ? input : propertyValue.evaluateAttributeExpressions().getValue();
                boolean validUrl = true;
                try {
                    URI.create(evaluatedInput).toURL();
                }
                catch (IllegalArgumentException | MalformedURLException mue) {
                    validUrl = false;
                }
                boolean validFile = true;
                if (!validUrl) {
                    File file = new File(evaluatedInput);
                    validFile = file.exists();
                }
                boolean valid = validUrl || validFile;
                String reason = valid ? "Valid URL or file" : "Not a valid URL or file";
                return new ValidationResult.Builder().subject(subject).input(input).explanation(reason).valid(valid).build();
            }
            catch (Exception e) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Not a valid URL or file").valid(false).build();
            }
        };
    }

    public static Validator createListValidator(boolean trimEntries, boolean excludeEmptyEntries, Validator elementValidator) {
        return StandardValidators.createListValidator(trimEntries, excludeEmptyEntries, elementValidator, false);
    }

    public static Validator createListValidator(boolean trimEntries, boolean excludeEmptyEntries, Validator validator, boolean ensureElementValidation) {
        return (subject, input, context) -> {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
            }
            try {
                String[] list;
                if (input == null) {
                    return new ValidationResult.Builder().subject(subject).input(null).explanation("List must have at least one non-empty element").valid(false).build();
                }
                String[] stringArray = list = ensureElementValidation ? input.split(",", -1) : input.split(",");
                if (list.length == 0) {
                    return new ValidationResult.Builder().subject(subject).input(null).explanation("List must have at least one non-empty element").valid(false).build();
                }
                for (String item : list) {
                    ValidationResult result;
                    String itemToValidate;
                    String string = itemToValidate = trimEntries ? item.trim() : item;
                    if (StandardValidators.isEmpty(itemToValidate) && excludeEmptyEntries || (result = validator.validate(subject, itemToValidate, context)).isValid()) continue;
                    return result;
                }
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Valid List").valid(true).build();
            }
            catch (Exception e) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Not a valid list").valid(false).build();
            }
        };
    }

    public static Validator createTimePeriodValidator(long minTime, TimeUnit minTimeUnit, long maxTime, TimeUnit maxTimeUnit) {
        return new TimePeriodValidator(minTime, minTimeUnit, maxTime, maxTimeUnit);
    }

    public static Validator createAttributeExpressionLanguageValidator(AttributeExpression.ResultType expectedResultType) {
        return StandardValidators.createAttributeExpressionLanguageValidator(expectedResultType, true);
    }

    public static Validator createDataSizeBoundsValidator(final long minBytesInclusive, final long maxBytesInclusive) {
        return new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
                }
                ValidationResult vr = DATA_SIZE_VALIDATOR.validate(subject, input, context);
                if (!vr.isValid()) {
                    return vr;
                }
                long dataSizeBytes = DataUnit.parseDataSize((String)input, (DataUnit)DataUnit.B).longValue();
                if (dataSizeBytes < minBytesInclusive) {
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Cannot be smaller than " + minBytesInclusive + " bytes").build();
                }
                if (dataSizeBytes > maxBytesInclusive) {
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Cannot be larger than " + maxBytesInclusive + " bytes").build();
                }
                return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
            }
        };
    }

    public static Validator createRegexMatchingValidator(Pattern pattern) {
        return StandardValidators.createRegexMatchingValidator(pattern, false, "Value does not match regular expression: " + pattern.pattern());
    }

    public static Validator createRegexMatchingValidator(final Pattern pattern, final boolean evaluateExpressions, final String validationMessage) {
        return new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                String value = input;
                if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                    if (evaluateExpressions) {
                        try {
                            value = context.newPropertyValue(input).evaluateAttributeExpressions().getValue();
                        }
                        catch (Exception e) {
                            return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Failed to evaluate the Attribute Expression Language due to " + e.toString()).build();
                        }
                    } else {
                        return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
                    }
                }
                boolean matches = value != null && pattern.matcher(value).matches();
                return new ValidationResult.Builder().input(input).subject(subject).valid(matches).explanation(matches ? null : validationMessage).build();
            }
        };
    }

    public static Validator createRegexMatchingValidator(Pattern pattern, boolean evaluateExpressions) {
        return StandardValidators.createRegexMatchingValidator(pattern, evaluateExpressions, "Value does not match regular expression: " + pattern.pattern());
    }

    public static Validator createRegexValidator(final int minCapturingGroups, final int maxCapturingGroups, final boolean supportAttributeExpressionLanguage) {
        return new Validator(){

            public ValidationResult validate(String subject, String value, ValidationContext context) {
                try {
                    String substituted;
                    if (supportAttributeExpressionLanguage) {
                        try {
                            substituted = context.newPropertyValue(value).evaluateAttributeExpressions().getValue();
                        }
                        catch (Exception e) {
                            return new ValidationResult.Builder().subject(subject).input(value).valid(false).explanation("Failed to evaluate the Attribute Expression Language due to " + e.toString()).build();
                        }
                    } else {
                        substituted = value;
                    }
                    Pattern pattern = Pattern.compile(substituted);
                    int numGroups = pattern.matcher("").groupCount();
                    if (numGroups < minCapturingGroups || numGroups > maxCapturingGroups) {
                        return new ValidationResult.Builder().subject(subject).input(value).valid(false).explanation("RegEx is required to have between " + minCapturingGroups + " and " + maxCapturingGroups + " Capturing Groups but has " + numGroups).build();
                    }
                    return new ValidationResult.Builder().subject(subject).input(value).valid(true).build();
                }
                catch (Exception e) {
                    return new ValidationResult.Builder().subject(subject).input(value).valid(false).explanation("Not a valid Java Regular Expression").build();
                }
            }
        };
    }

    public static Validator createAttributeExpressionLanguageValidator(final AttributeExpression.ResultType expectedResultType, final boolean allowExtraCharacters) {
        return new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                AttributeExpression.ResultType resultType;
                String syntaxError = context.newExpressionLanguageCompiler().validateExpression(input, allowExtraCharacters);
                if (syntaxError != null) {
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(syntaxError).build();
                }
                AttributeExpression.ResultType resultType2 = resultType = allowExtraCharacters ? AttributeExpression.ResultType.STRING : context.newExpressionLanguageCompiler().getResultType(input);
                if (!resultType.equals((Object)expectedResultType)) {
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Expected Attribute Query to return type " + expectedResultType + " but query returns type " + resultType).build();
                }
                return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
            }
        };
    }

    public static Validator createLongValidator(final long minimum, final long maximum, final boolean inclusive) {
        return new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
                }
                String reason = null;
                try {
                    long longVal = Long.parseLong(input);
                    if (longVal < minimum || (!inclusive && longVal == minimum) | longVal > maximum || !inclusive && longVal == maximum) {
                        reason = "Value must be between " + minimum + " and " + maximum + " (" + (inclusive ? "inclusive" : "exclusive") + ")";
                    }
                }
                catch (NumberFormatException e) {
                    reason = "not a valid integer";
                }
                return new ValidationResult.Builder().subject(subject).input(input).explanation(reason).valid(reason == null).build();
            }
        };
    }

    static {
        ISO8061_INSTANT_VALIDATOR = ISO8601_INSTANT_VALIDATOR = new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                try {
                    Instant.parse(input);
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Valid ISO 8601 Instant Date").valid(true).build();
                }
                catch (Exception e) {
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Not a valid ISO 8601 Instant Date, please enter in UTC time").valid(false).build();
                }
            }
        };
        NON_NEGATIVE_INTEGER_VALIDATOR = new Validator(){

            public ValidationResult validate(String subject, String value, ValidationContext context) {
                if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
                    return new ValidationResult.Builder().subject(subject).input(value).explanation("Expression Language Present").valid(true).build();
                }
                String reason = null;
                try {
                    int intVal = Integer.parseInt(value);
                    if (intVal < 0) {
                        reason = "value is negative";
                    }
                }
                catch (NumberFormatException e) {
                    reason = "value is not a valid integer";
                }
                return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
            }
        };
        CHARACTER_SET_VALIDATOR = new Validator(){

            public ValidationResult validate(String subject, String value, ValidationContext context) {
                if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
                    AttributeExpression.ResultType resultType = context.newExpressionLanguageCompiler().getResultType(value);
                    if (!resultType.equals((Object)AttributeExpression.ResultType.STRING)) {
                        return new ValidationResult.Builder().subject(subject).input(value).valid(false).explanation("Expected Attribute Query to return type " + AttributeExpression.ResultType.STRING + " but query returns type " + resultType).build();
                    }
                    return new ValidationResult.Builder().subject(subject).input(value).explanation("Expression Language Present").valid(true).build();
                }
                String reason = null;
                try {
                    if (!Charset.isSupported(value)) {
                        reason = "Character Set is not supported by this JVM.";
                    }
                }
                catch (UnsupportedCharsetException uce) {
                    reason = "Character Set is not supported by this JVM.";
                }
                catch (IllegalArgumentException iae) {
                    reason = "Character Set value cannot be null.";
                }
                return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
            }
        };
        CHARACTER_SET_VALIDATOR_WITH_EVALUATION = new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                String evaluatedInput = input;
                if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                    try {
                        PropertyValue propertyValue = context.newPropertyValue(input);
                        evaluatedInput = propertyValue == null ? input : propertyValue.evaluateAttributeExpressions().getValue();
                    }
                    catch (Exception e) {
                        return new ValidationResult.Builder().subject(subject).input(input).explanation("Not a valid expression").valid(false).build();
                    }
                }
                String reason = null;
                try {
                    if (!Charset.isSupported(evaluatedInput)) {
                        reason = "Character Set is not supported by this JVM.";
                    }
                }
                catch (IllegalArgumentException iae) {
                    reason = "Character Set value is null or is not supported by this JVM.";
                }
                return new ValidationResult.Builder().subject(subject).input(evaluatedInput).explanation(reason).valid(reason == null).build();
            }
        };
        SINGLE_CHAR_VALIDATOR = (subject, input, context) -> {
            if (input == null) {
                return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Input is null for this property").build();
            }
            if (input.length() != 1) {
                return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Value must be exactly 1 character but was " + input.length() + " in length").build();
            }
            return new ValidationResult.Builder().input(input).subject(subject).valid(true).build();
        };
        URL_VALIDATOR = StandardValidators.createURLValidator();
        URI_VALIDATOR = new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
                }
                try {
                    new URI(input);
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Valid URI").valid(true).build();
                }
                catch (Exception e) {
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Not a valid URI").valid(false).build();
                }
            }
        };
        URI_LIST_VALIDATOR = (subject, input, context) -> {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
            }
            if (input == null || input.isEmpty()) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Not a valid URI, value is missing or empty").valid(false).build();
            }
            Optional<ValidationResult> invalidUri = Arrays.stream(input.split(",")).filter(uri -> uri != null && !uri.trim().isEmpty()).map(String::trim).map(uri -> URI_VALIDATOR.validate(subject, uri, context)).filter(uri -> !uri.isValid()).findFirst();
            return invalidUri.orElseGet(() -> new ValidationResult.Builder().subject(subject).input(input).explanation("Valid URI(s)").valid(true).build());
        };
        REGULAR_EXPRESSION_VALIDATOR = StandardValidators.createRegexValidator(0, Integer.MAX_VALUE, false);
        REGULAR_EXPRESSION_WITH_EL_VALIDATOR = StandardValidators.createRegexValidator(0, Integer.MAX_VALUE, true);
        ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR = new Validator(){

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                    try {
                        String result = context.newExpressionLanguageCompiler().validateExpression(input, true);
                        if (!StandardValidators.isEmpty(result)) {
                            return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(result).build();
                        }
                    }
                    catch (Exception e) {
                        return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(e.getMessage()).build();
                    }
                }
                return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
            }
        };
        TIME_PERIOD_VALIDATOR = new Validator(){
            private final Pattern TIME_DURATION_PATTERN = Pattern.compile(FormatUtils.TIME_DURATION_REGEX);

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
                }
                if (input == null) {
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Time Period cannot be null").build();
                }
                if (this.TIME_DURATION_PATTERN.matcher(input.toLowerCase()).matches()) {
                    return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
                }
                return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Must be of format <duration> <TimeUnit> where <duration> is a non-negative integer and TimeUnit is a supported Time Unit, such as: nanos, millis, secs, mins, hrs, days").build();
            }
        };
        DATA_SIZE_VALIDATOR = new Validator(){
            private final Pattern DATA_SIZE_PATTERN = Pattern.compile("(\\d+(?:\\.\\d+)?)\\s*(B|KB|MB|GB|TB)");

            public ValidationResult validate(String subject, String input, ValidationContext context) {
                if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                    return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
                }
                if (input == null) {
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Data Size cannot be null").build();
                }
                if (this.DATA_SIZE_PATTERN.matcher(input.toUpperCase()).matches()) {
                    return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
                }
                return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Must be of format <Data Size> <Data Unit> where <Data Size> is a non-negative integer and <Data Unit> is a supported Data Unit, such as: B, KB, MB, GB, TB").build();
            }
        };
        FILE_EXISTS_VALIDATOR = new FileExistsValidator(true);
    }

    public static class DirectoryExistsValidator
    implements Validator {
        private final boolean allowEL;
        private final boolean create;

        public DirectoryExistsValidator(boolean allowExpressionLanguage, boolean create) {
            this.allowEL = allowExpressionLanguage;
            this.create = create;
        }

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            String substituted;
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
                return new ValidationResult.Builder().subject(subject).input(value).explanation("Expression Language Present").valid(true).build();
            }
            if (this.allowEL) {
                try {
                    substituted = context.newPropertyValue(value).evaluateAttributeExpressions().getValue();
                }
                catch (Exception e) {
                    return new ValidationResult.Builder().subject(subject).input(value).valid(false).explanation("Not a valid Expression Language value: " + e.getMessage()).build();
                }
                if (substituted.trim().isEmpty() && !value.trim().isEmpty()) {
                    return new ValidationResult.Builder().subject(subject).input(value).valid(true).build();
                }
            } else {
                substituted = value;
            }
            String reason = null;
            try {
                File file = new File(substituted);
                if (!file.exists()) {
                    if (!this.create) {
                        reason = "Directory does not exist";
                    } else if (!file.mkdirs()) {
                        reason = "Directory does not exist and could not be created";
                    }
                } else if (!file.isDirectory()) {
                    reason = "Path does not point to a directory";
                }
            }
            catch (Exception e) {
                reason = "Value is not a valid directory name";
            }
            return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
        }
    }

    public static class StringLengthValidator
    implements Validator {
        private final int minimum;
        private final int maximum;

        public StringLengthValidator(int minimum, int maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            if (value.length() < this.minimum || value.length() > this.maximum) {
                return new ValidationResult.Builder().subject(subject).valid(false).input(value).explanation(String.format("String length invalid [min: %d, max: %d]", this.minimum, this.maximum)).build();
            }
            return new ValidationResult.Builder().valid(true).input(value).subject(subject).build();
        }
    }

    public static class FileExistsValidator
    implements Validator {
        private final boolean allowEL;
        private final boolean allowFileOnly;

        public FileExistsValidator(boolean allowExpressionLanguage) {
            this(allowExpressionLanguage, false);
        }

        public FileExistsValidator(boolean allowExpressionLanguage, boolean fileOnly) {
            this.allowEL = allowExpressionLanguage;
            this.allowFileOnly = fileOnly;
        }

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            String substituted;
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
                return new ValidationResult.Builder().subject(subject).input(value).explanation("Expression Language Present").valid(true).build();
            }
            if (this.allowEL) {
                try {
                    substituted = context.newPropertyValue(value).evaluateAttributeExpressions().getValue();
                }
                catch (Exception e) {
                    return new ValidationResult.Builder().subject(subject).input(value).valid(false).explanation("Not a valid Expression Language value: " + e.getMessage()).build();
                }
            } else {
                substituted = value;
            }
            File file = new File(substituted);
            if (!file.exists()) {
                return new ValidationResult.Builder().subject(subject).input(value).valid(false).explanation("File " + file + " does not exist").build();
            }
            if (this.allowFileOnly && !file.isFile()) {
                return new ValidationResult.Builder().subject(subject).input(value).valid(false).explanation(file + " is not a file").build();
            }
            return new ValidationResult.Builder().subject(subject).input(value).valid(true).build();
        }
    }

    static class TimePeriodValidator
    implements Validator {
        private static final Pattern pattern = Pattern.compile(FormatUtils.TIME_DURATION_REGEX);
        private final long minNanos;
        private final long maxNanos;
        private final String minValueEnglish;
        private final String maxValueEnglish;

        public TimePeriodValidator(long minValue, TimeUnit minTimeUnit, long maxValue, TimeUnit maxTimeUnit) {
            this.minNanos = TimeUnit.NANOSECONDS.convert(minValue, minTimeUnit);
            this.maxNanos = TimeUnit.NANOSECONDS.convert(maxValue, maxTimeUnit);
            this.minValueEnglish = minValue + " " + minTimeUnit.toString();
            this.maxValueEnglish = maxValue + " " + maxTimeUnit.toString();
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
            }
            if (input == null) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Time Period cannot be null").build();
            }
            String lowerCase = input.toLowerCase();
            boolean validSyntax = pattern.matcher(lowerCase).matches();
            ValidationResult.Builder builder = new ValidationResult.Builder();
            if (validSyntax) {
                long nanos = FormatUtils.getTimeDuration(lowerCase, TimeUnit.NANOSECONDS);
                if (nanos < this.minNanos || nanos > this.maxNanos) {
                    builder.subject(subject).input(input).valid(false).explanation("Must be in the range of " + this.minValueEnglish + " to " + this.maxValueEnglish);
                } else {
                    builder.subject(subject).input(input).valid(true);
                }
            } else {
                builder.subject(subject).input(input).valid(false).explanation("Must be of format <duration> <TimeUnit> where <duration> is a non-negative integer and TimeUnit is a supported Time Unit, such as: nanos, millis, secs, mins, hrs, days");
            }
            return builder.build();
        }
    }
}

