/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.LongLongHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.Uuid;

public final class CountDistinctUuidGroupByFunction
extends LongFunction
implements UnaryFunction,
GroupByFunction {
    private final Function arg;
    private final ObjList<LongLongHashSet> sets = new ObjList();
    private int setIndex;
    private int valueIndex;

    public CountDistinctUuidGroupByFunction(Function arg) {
        this.arg = arg;
    }

    @Override
    public void clear() {
        this.sets.clear();
        this.setIndex = 0;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        LongLongHashSet set;
        if (this.sets.size() <= this.setIndex) {
            set = new LongLongHashSet(16, 0.6, Long.MIN_VALUE, LongLongHashSet.UUID_STRATEGY);
            this.sets.extendAndSet(this.setIndex, set);
        } else {
            set = this.sets.getQuick(this.setIndex);
        }
        set.clear();
        long lo = this.arg.getLong128Lo(record);
        long hi = this.arg.getLong128Hi(record);
        if (!Uuid.isNull(lo, hi)) {
            set.add(lo, hi);
            mapValue.putLong(this.valueIndex, 1L);
        } else {
            mapValue.putLong(this.valueIndex, 0L);
        }
        mapValue.putInt(this.valueIndex + 1, this.setIndex++);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        long hi;
        LongLongHashSet set = this.sets.getQuick(mapValue.getInt(this.valueIndex + 1));
        long lo = this.arg.getLong128Lo(record);
        if (!Uuid.isNull(lo, hi = this.arg.getLong128Hi(record))) {
            int index = set.keySlot(lo, hi);
            if (index < 0) {
                return;
            }
            set.addAt(index, lo, hi);
            mapValue.addLong(this.valueIndex, 1L);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public long getLong(Record rec) {
        return rec.getLong(this.valueIndex);
    }

    @Override
    public String getName() {
        return "count_distinct";
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isReadThreadSafe() {
        return false;
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
        columnTypes.add(5);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
    }

    @Override
    public void toTop() {
        UnaryFunction.super.toTop();
        this.setIndex = 0;
    }
}

