/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.cutlass.text.types.TimestampCompatibleAdapter;
import io.questdb.griffin.SqlKeywords;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.DirectByteCharSequence;

public final class LongAdapter
extends AbstractTypeAdapter
implements TimestampCompatibleAdapter {
    public static final LongAdapter INSTANCE = new LongAdapter();

    private LongAdapter() {
    }

    public long getLong(DirectByteCharSequence value) throws Exception {
        return Numbers.parseLong(value);
    }

    @Override
    public long getTimestamp(DirectByteCharSequence value) throws Exception {
        return this.getLong(value);
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public boolean probe(DirectByteCharSequence text) {
        if (text.length() > 2 && text.charAt(0) == '0' && text.charAt(1) != '.') {
            return false;
        }
        try {
            Numbers.parseLong(text);
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectByteCharSequence value) throws Exception {
        row.putLong(column, SqlKeywords.isNullKeyword(value) ? Long.MIN_VALUE : this.getLong(value));
    }
}

