/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.VersionsClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.entity.VersionControlInformationEntity;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataEntity;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataSetEntity;
import org.apache.nifi.web.api.entity.VersionedFlowUpdateRequestEntity;

public class PGChangeVersion
extends AbstractNiFiCommand<VoidResult> {
    public PGChangeVersion() {
        super("pg-change-version", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Changes the version for a version controlled process group. This can be used to upgrade to a new version, or revert to a previous version. If no version is specified, the latest version will be used.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.FLOW_VERSION.createOption());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        VersionsClient versionsClient = client.getVersionsClient();
        VersionControlInformationEntity existingVersionControlInfo = versionsClient.getVersionControlInfo(pgId);
        VersionControlInformationDTO existingVersionControlDTO = existingVersionControlInfo.getVersionControlInformation();
        if (existingVersionControlDTO == null) {
            throw new NiFiClientException("Process group is not under version control");
        }
        Integer newVersion = this.getIntArg(properties, CommandOption.FLOW_VERSION);
        if (newVersion == null && (newVersion = Integer.valueOf(this.getLatestVersion(client, existingVersionControlDTO))).intValue() == existingVersionControlDTO.getVersion().intValue()) {
            throw new NiFiClientException("Process group already at latest version");
        }
        existingVersionControlDTO.setVersion(newVersion);
        VersionedFlowUpdateRequestEntity initialUpdateRequest = versionsClient.updateVersionControlInfo(pgId, existingVersionControlInfo);
        String updateRequestId = initialUpdateRequest.getRequest().getRequestId();
        try {
            boolean completed = false;
            for (int i = 0; i < 30; ++i) {
                VersionedFlowUpdateRequestEntity updateRequest = versionsClient.getUpdateRequest(updateRequestId);
                if (updateRequest != null && updateRequest.getRequest().isComplete()) {
                    completed = true;
                    break;
                }
                try {
                    if (this.getContext().isInteractive()) {
                        this.println("Waiting for update request to complete...");
                    }
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!completed) {
                throw new NiFiClientException("Unable to change version of process group, cancelling request");
            }
        }
        finally {
            versionsClient.deleteUpdateRequest(updateRequestId);
        }
        return VoidResult.getInstance();
    }

    private int getLatestVersion(NiFiClient client, VersionControlInformationDTO existingVersionControlDTO) throws NiFiClientException, IOException {
        String flowId;
        String bucketId;
        String registryId;
        FlowClient flowClient = client.getFlowClient();
        VersionedFlowSnapshotMetadataSetEntity versions = flowClient.getVersions(registryId = existingVersionControlDTO.getRegistryId(), bucketId = existingVersionControlDTO.getBucketId(), flowId = existingVersionControlDTO.getFlowId());
        if (versions.getVersionedFlowSnapshotMetadataSet() == null || versions.getVersionedFlowSnapshotMetadataSet().isEmpty()) {
            throw new NiFiClientException("No versions available");
        }
        int latestVersion = 1;
        for (VersionedFlowSnapshotMetadataEntity version : versions.getVersionedFlowSnapshotMetadataSet()) {
            if (version.getVersionedFlowSnapshotMetadata().getVersion() <= latestVersion) continue;
            latestVersion = version.getVersionedFlowSnapshotMetadata().getVersion();
        }
        return latestVersion;
    }
}

