/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.Algorithm;
import com.azure.security.keyvault.keys.cryptography.AlgorithmResolver;
import com.azure.security.keyvault.keys.cryptography.AsymmetricEncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientImpl;
import com.azure.security.keyvault.keys.cryptography.HashAlgorithm;
import com.azure.security.keyvault.keys.cryptography.ICryptoTransform;
import com.azure.security.keyvault.keys.cryptography.LocalKeyCryptographyClient;
import com.azure.security.keyvault.keys.cryptography.SignatureHashResolver;
import com.azure.security.keyvault.keys.cryptography.models.DecryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptParameters;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import reactor.core.publisher.Mono;

class RsaKeyCryptographyClient
extends LocalKeyCryptographyClient {
    private static final ClientLogger LOGGER = new ClientLogger(RsaKeyCryptographyClient.class);
    private KeyPair keyPair;

    RsaKeyCryptographyClient(CryptographyClientImpl serviceClient) {
        super(serviceClient);
    }

    RsaKeyCryptographyClient(JsonWebKey key, CryptographyClientImpl serviceClient) {
        super(serviceClient);
        this.keyPair = key.toRsa(key.hasPrivateKey());
    }

    private KeyPair getKeyPair(JsonWebKey key) {
        if (this.keyPair == null) {
            this.keyPair = key.toRsa(key.hasPrivateKey());
        }
        return this.keyPair;
    }

    @Override
    Mono<EncryptResult> encryptAsync(EncryptionAlgorithm algorithm, byte[] plaintext, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null.");
        this.keyPair = this.getKeyPair(jsonWebKey);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.encryptAsync(algorithm, plaintext, context);
            }
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.keyPair.getPublic() == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.encryptAsync(algorithm, plaintext, context);
            }
            return Mono.error((Throwable)new IllegalArgumentException("Public portion of the key not available to perform encrypt operation"));
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.createEncryptor(this.keyPair);
            return Mono.just((Object)new EncryptResult(transform.doFinal(plaintext), algorithm, jsonWebKey.getId()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    EncryptResult encrypt(EncryptionAlgorithm algorithm, byte[] plaintext, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plaintext cannot be null.");
        this.keyPair = this.getKeyPair(jsonWebKey);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.encrypt(algorithm, plaintext, context);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        if (this.keyPair.getPublic() == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.encrypt(algorithm, plaintext, context);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Public portion of the key not available to perform encrypt operation"));
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.createEncryptor(this.keyPair);
            return new EncryptResult(transform.doFinal(plaintext), algorithm, jsonWebKey.getId());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    Mono<EncryptResult> encryptAsync(EncryptParameters encryptParameters, JsonWebKey jsonWebKey, Context context) {
        try {
            EncryptResult encryptResult = this.encrypt(encryptParameters, jsonWebKey, context);
            return Mono.just((Object)encryptResult);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    EncryptResult encrypt(EncryptParameters encryptParameters, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(encryptParameters, "Encrypt parameters cannot be null.");
        return this.encrypt(encryptParameters.getAlgorithm(), encryptParameters.getPlainText(), jsonWebKey, context);
    }

    @Override
    Mono<DecryptResult> decryptAsync(EncryptionAlgorithm algorithm, byte[] ciphertext, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null.");
        this.keyPair = this.getKeyPair(jsonWebKey);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.decryptAsync(algorithm, ciphertext, context);
            }
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.keyPair.getPrivate() == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.decryptAsync(algorithm, ciphertext, context);
            }
            return Mono.error((Throwable)new IllegalArgumentException("Private portion of the key not available to perform decrypt operation"));
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.createDecryptor(this.keyPair);
            return Mono.just((Object)new DecryptResult(transform.doFinal(ciphertext), algorithm, jsonWebKey.getId()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    DecryptResult decrypt(EncryptionAlgorithm algorithm, byte[] ciphertext, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(ciphertext, "Ciphertext cannot be null.");
        this.keyPair = this.getKeyPair(jsonWebKey);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.decrypt(algorithm, ciphertext, context);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        if (this.keyPair.getPrivate() == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.decrypt(algorithm, ciphertext, context);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Private portion of the key not available to perform decrypt operation"));
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.createDecryptor(this.keyPair);
            return new DecryptResult(transform.doFinal(ciphertext), algorithm, jsonWebKey.getId());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    Mono<DecryptResult> decryptAsync(DecryptParameters decryptParameters, JsonWebKey jsonWebKey, Context context) {
        try {
            DecryptResult decryptResult = this.decrypt(decryptParameters, jsonWebKey, context);
            return Mono.just((Object)decryptResult);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    DecryptResult decrypt(DecryptParameters decryptParameters, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(decryptParameters, "Decrypt parameters cannot be null.");
        return this.decrypt(decryptParameters.getAlgorithm(), decryptParameters.getCipherText(), jsonWebKey, context);
    }

    @Override
    Mono<SignResult> signAsync(SignatureAlgorithm algorithm, byte[] digest, JsonWebKey key, Context context) {
        if (this.serviceClientAvailable()) {
            return this.serviceClient.signAsync(algorithm, digest, context);
        }
        return Mono.error((Throwable)new UnsupportedOperationException("Sign operation on Local RSA key is not supported currently."));
    }

    @Override
    SignResult sign(SignatureAlgorithm algorithm, byte[] digest, JsonWebKey key, Context context) {
        if (this.serviceClientAvailable()) {
            return this.serviceClient.sign(algorithm, digest, context);
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Sign operation on Local RSA key is not supported currently."));
    }

    @Override
    Mono<VerifyResult> verifyAsync(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, JsonWebKey key, Context context) {
        if (this.serviceClientAvailable()) {
            return this.serviceClient.verifyAsync(algorithm, digest, signature, context);
        }
        return Mono.error((Throwable)new UnsupportedOperationException("Verify operation on Local RSA key is not supported currently."));
    }

    @Override
    VerifyResult verify(SignatureAlgorithm algorithm, byte[] digest, byte[] signature, JsonWebKey key, Context context) {
        if (this.serviceClientAvailable()) {
            return this.serviceClient.verify(algorithm, digest, signature, context);
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Verify operation on Local RSA key is not supported currently."));
    }

    @Override
    Mono<WrapResult> wrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] key, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(key, "Key content to be wrapped cannot be null.");
        this.keyPair = this.getKeyPair(jsonWebKey);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.wrapKeyAsync(algorithm, key, context);
            }
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.keyPair.getPublic() == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.wrapKeyAsync(algorithm, key, context);
            }
            return Mono.error((Throwable)new IllegalArgumentException("Public portion of the key not available to perform wrap key operation"));
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.createEncryptor(this.keyPair);
            return Mono.just((Object)new WrapResult(transform.doFinal(key), algorithm, jsonWebKey.getId()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    WrapResult wrapKey(KeyWrapAlgorithm algorithm, byte[] key, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(key, "Key content to be wrapped cannot be null.");
        this.keyPair = this.getKeyPair(jsonWebKey);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.wrapKey(algorithm, key, context);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        if (this.keyPair.getPublic() == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.wrapKey(algorithm, key, context);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Public portion of the key not available to perform wrap key operation"));
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.createEncryptor(this.keyPair);
            return new WrapResult(transform.doFinal(key), algorithm, jsonWebKey.getId());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    Mono<UnwrapResult> unwrapKeyAsync(KeyWrapAlgorithm algorithm, byte[] encryptedKey, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(encryptedKey, "Encrypted key content to be unwrapped cannot be null.");
        this.keyPair = this.getKeyPair(jsonWebKey);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.unwrapKeyAsync(algorithm, encryptedKey, context);
            }
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            return Mono.error((Throwable)new NoSuchAlgorithmException(algorithm.toString()));
        }
        if (this.keyPair.getPrivate() == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.unwrapKeyAsync(algorithm, encryptedKey, context);
            }
            return Mono.error((Throwable)new IllegalArgumentException("Private portion of the key not available to perform unwrap operation"));
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.createDecryptor(this.keyPair);
            return Mono.just((Object)new UnwrapResult(transform.doFinal(encryptedKey), algorithm, jsonWebKey.getId()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    UnwrapResult unwrapKey(KeyWrapAlgorithm algorithm, byte[] encryptedKey, JsonWebKey jsonWebKey, Context context) {
        Objects.requireNonNull(algorithm, "Key wrap algorithm cannot be null.");
        Objects.requireNonNull(encryptedKey, "Encrypted key content to be unwrapped cannot be null.");
        this.keyPair = this.getKeyPair(jsonWebKey);
        Algorithm baseAlgorithm = AlgorithmResolver.DEFAULT.get(algorithm.toString());
        if (baseAlgorithm == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.unwrapKey(algorithm, encryptedKey, context);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        if (!(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw LOGGER.logExceptionAsError(new RuntimeException(new NoSuchAlgorithmException(algorithm.toString())));
        }
        if (this.keyPair.getPrivate() == null) {
            if (this.serviceClientAvailable()) {
                return this.serviceClient.unwrapKey(algorithm, encryptedKey, context);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Private portion of the key not available to perform unwrap operation"));
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.createDecryptor(this.keyPair);
            return new UnwrapResult(transform.doFinal(encryptedKey), algorithm, jsonWebKey.getId());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    Mono<SignResult> signDataAsync(SignatureAlgorithm algorithm, byte[] data, JsonWebKey key, Context context) {
        try {
            return this.signAsync(algorithm, this.calculateDigest(algorithm, data), key, context);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    SignResult signData(SignatureAlgorithm algorithm, byte[] data, JsonWebKey key, Context context) {
        try {
            return this.sign(algorithm, this.calculateDigest(algorithm, data), key, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    Mono<VerifyResult> verifyDataAsync(SignatureAlgorithm algorithm, byte[] data, byte[] signature, JsonWebKey key, Context context) {
        try {
            return this.verifyAsync(algorithm, this.calculateDigest(algorithm, data), signature, key, context);
        }
        catch (NoSuchAlgorithmException e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    VerifyResult verifyData(SignatureAlgorithm algorithm, byte[] data, byte[] signature, JsonWebKey key, Context context) {
        try {
            return this.verify(algorithm, this.calculateDigest(algorithm, data), signature, key, context);
        }
        catch (NoSuchAlgorithmException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    private byte[] calculateDigest(SignatureAlgorithm algorithm, byte[] data) throws NoSuchAlgorithmException {
        HashAlgorithm hashAlgorithm = SignatureHashResolver.DEFAULT.get(algorithm);
        MessageDigest md = MessageDigest.getInstance(hashAlgorithm.toString());
        md.update(data);
        return md.digest();
    }

    private boolean serviceClientAvailable() {
        return this.serviceClient != null;
    }
}

