/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.connect.validators;

import java.io.File;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class ConnectDirectoryExistsValidator
implements ConfigDef.Validator {
    public void ensureValid(String name, Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof String)) {
            throw new ConfigException("Invalid value for property " + name + ": The configured value is expected to be the path to a directory");
        }
        File file = new File((String)value);
        if (!file.exists()) {
            throw new ConfigException("The value " + value + " configured for the property " + name + " is not valid because no directory exists at " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new ConfigException("The value " + value + " configured for the property " + name + " is not valid because " + file.getAbsolutePath() + " is not a directory");
        }
        File[] files = file.listFiles();
        if (files == null) {
            throw new ConfigException("The value " + value + " configured for the property " + name + " is not valid because could not obtain a listing of files in directory " + file.getAbsolutePath());
        }
    }
}

