/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.authorization.Tenant;
import org.apache.nifi.registry.authorization.UserGroup;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;

public class UserGroupsResult
extends AbstractWritableResult<List<UserGroup>> {
    private final List<UserGroup> userGroups;

    public UserGroupsResult(ResultType resultType, List<UserGroup> userGroups) {
        super(resultType);
        this.userGroups = userGroups;
        Validate.notNull(userGroups);
    }

    @Override
    public List<UserGroup> getResult() {
        return this.userGroups;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        if (this.userGroups.isEmpty()) {
            return;
        }
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 20, 36, true).column("Id", 36, 36, false).column("Users", 36, 200, false).build();
        for (int userIndex = 0; userIndex < this.userGroups.size(); ++userIndex) {
            UserGroup userGroup = this.userGroups.get(userIndex);
            table.addRow(String.valueOf(userIndex + 1), userGroup.getIdentity(), userGroup.getIdentifier(), this.joinTenantIdentities(userGroup.getUsers()));
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    private String joinTenantIdentities(Set<Tenant> tenants) {
        return tenants.stream().map(tenant -> tenant.getIdentity()).collect(Collectors.joining("; "));
    }
}

