/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.extension.repo.ExtensionRepoVersionSummary;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;

public class ExtensionRepoVersionSummariesResult
extends AbstractWritableResult<List<ExtensionRepoVersionSummary>> {
    private final List<ExtensionRepoVersionSummary> bundleVersions;

    public ExtensionRepoVersionSummariesResult(ResultType resultType, List<ExtensionRepoVersionSummary> bundleVersions) {
        super(resultType);
        this.bundleVersions = bundleVersions;
        Validate.notNull(this.bundleVersions);
        this.bundleVersions.sort(Comparator.comparing(ExtensionRepoVersionSummary::getBucketName).thenComparing(ExtensionRepoVersionSummary::getGroupId).thenComparing(ExtensionRepoVersionSummary::getArtifactId).thenComparing(ExtensionRepoVersionSummary::getVersion));
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        if (this.bundleVersions.isEmpty()) {
            return;
        }
        Table table = new Table.Builder().column("#", 3, 3, false).column("Bucket", 40, 400, false).column("Group", 40, 200, false).column("Artifact", 40, 200, false).column("Version", 8, 100, false).build();
        for (int i = 0; i < this.bundleVersions.size(); ++i) {
            ExtensionRepoVersionSummary version = this.bundleVersions.get(i);
            table.addRow(String.valueOf(i + 1), version.getBucketName(), version.getGroupId(), version.getArtifactId(), version.getVersion());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public List<ExtensionRepoVersionSummary> getResult() {
        return this.bundleVersions;
    }
}

