/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.TenantDTO;
import org.apache.nifi.web.api.dto.UserGroupDTO;
import org.apache.nifi.web.api.entity.UserGroupsEntity;

public class UserGroupsResult
extends AbstractWritableResult<UserGroupsEntity> {
    private final UserGroupsEntity userGroupsEntity;

    public UserGroupsResult(ResultType resultType, UserGroupsEntity userGroupsEntity) {
        super(resultType);
        this.userGroupsEntity = userGroupsEntity;
        Validate.notNull((Object)this.userGroupsEntity);
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Collection userGroupEntities = this.userGroupsEntity.getUserGroups();
        if (userGroupEntities == null) {
            return;
        }
        List userGroupDTOS = userGroupEntities.stream().map(s -> s.getComponent()).collect(Collectors.toList());
        Collections.sort(userGroupDTOS, Comparator.comparing(TenantDTO::getIdentity));
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 5, 40, false).column("ID", 36, 36, false).column("Members", 20, 40, true).build();
        for (int i = 0; i < userGroupDTOS.size(); ++i) {
            UserGroupDTO userGroupDTO = (UserGroupDTO)userGroupDTOS.get(i);
            table.addRow(String.valueOf(i + 1), userGroupDTO.getIdentity(), userGroupDTO.getId(), userGroupDTO.getUsers().stream().map(u -> u.getComponent().getIdentity()).collect(Collectors.joining(", ")));
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public UserGroupsEntity getResult() {
        return this.userGroupsEntity;
    }
}

