/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.PrintStream;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.web.api.entity.ClusteSummaryEntity;

public class ClusterSummaryEntityResult
extends AbstractWritableResult<ClusteSummaryEntity> {
    private final ClusteSummaryEntity clusteSummaryEntity;

    public ClusterSummaryEntityResult(ResultType resultType, ClusteSummaryEntity clusteSummaryEntity) {
        super(resultType);
        this.clusteSummaryEntity = clusteSummaryEntity;
        Validate.notNull((Object)this.clusteSummaryEntity);
    }

    @Override
    public ClusteSummaryEntity getResult() {
        return this.clusteSummaryEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        output.printf("Total node count: %d\nConnected node count: %d\nClustered: %s\nConnected to cluster: %s\n", this.clusteSummaryEntity.getClusterSummary().getTotalNodeCount(), this.clusteSummaryEntity.getClusterSummary().getConnectedNodeCount(), this.clusteSummaryEntity.getClusterSummary().getClustered(), this.clusteSummaryEntity.getClusterSummary().getConnectedToCluster());
    }
}

