/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.api.WritableResult;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;

public class ExportParamContext
extends AbstractNiFiCommand<ExportedParamContextResult> {
    public ExportParamContext() {
        super("export-param-context", ExportedParamContextResult.class);
    }

    @Override
    public String getDescription() {
        return "Exports a given parameter context to a json representation, with the option of writing to a file. ";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
        this.addOption(CommandOption.OUTPUT_FILE.createOption());
    }

    @Override
    public ExportedParamContextResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        String outputFilename = this.getArg(properties, CommandOption.OUTPUT_FILE);
        ParamContextClient paramContextClient = client.getParamContextClient();
        ParameterContextEntity parameterContextEntity = paramContextClient.getParamContext(paramContextId, false);
        ParameterContextDTO parameterContext = parameterContextEntity.getComponent();
        parameterContext.setId(null);
        parameterContext.setBoundProcessGroups(null);
        for (ParameterEntity parameterEntity : parameterContext.getParameters()) {
            ParameterDTO parameterDTO = parameterEntity.getParameter();
            parameterDTO.setReferencingComponents(null);
            if (parameterDTO.getSensitive().booleanValue()) {
                parameterDTO.setValue(null);
            }
            parameterEntity.setCanWrite(null);
            parameterDTO.setParameterContext(null);
        }
        if (parameterContext.getInheritedParameterContexts() != null) {
            for (ParameterContextReferenceEntity ref : parameterContext.getInheritedParameterContexts()) {
                ref.setId(null);
                ref.setPermissions(null);
                ref.getComponent().setId(null);
            }
        }
        Comparator entityComparator = (p1, p2) -> {
            String p1Name = p1.getParameter().getName();
            String p2Name = p2.getParameter().getName();
            return p1Name.compareTo(p2Name);
        };
        TreeSet sortedEntities = new TreeSet(entityComparator);
        sortedEntities.addAll(parameterContext.getParameters());
        parameterContext.setParameters(sortedEntities);
        return new ExportedParamContextResult(parameterContext, outputFilename);
    }

    public static class ExportedParamContextResult
    implements WritableResult<ParameterContextDTO> {
        private final ParameterContextDTO parameterContext;
        private final String outputFilename;

        public ExportedParamContextResult(ParameterContextDTO parameterContext, String outputFilename) {
            this.parameterContext = parameterContext;
            this.outputFilename = outputFilename;
            Validate.notNull((Object)this.parameterContext);
        }

        @Override
        public void write(PrintStream output) throws IOException {
            if (this.outputFilename != null) {
                try (FileOutputStream resultOut = new FileOutputStream(this.outputFilename);){
                    JacksonUtils.write(this.parameterContext, resultOut);
                }
            } else {
                JacksonUtils.write(this.parameterContext, output);
            }
        }

        @Override
        public ParameterContextDTO getResult() {
            return this.parameterContext;
        }
    }
}

