/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.admin;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.admin.RepositoryUtils;
import org.apache.nifi.h2.database.migration.H2DatabaseUpdater;
import org.apache.nifi.util.NiFiProperties;
import org.h2.jdbcx.JdbcConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class AuditDataSourceFactoryBean
implements FactoryBean {
    private static final Logger logger = LoggerFactory.getLogger(AuditDataSourceFactoryBean.class);
    private static final String NF_USERNAME_PASSWORD = "nf";
    private static final int MAX_CONNECTIONS = 5;
    private static final String AUDIT_DATABASE_FILE_NAME = "nifi-flow-audit";
    private static final String CREATE_ACTION_TABLE = "CREATE TABLE ACTION (ID INT NOT NULL PRIMARY KEY AUTO_INCREMENT, IDENTITY VARCHAR2(4096) NOT NULL, SOURCE_ID VARCHAR2(100) NOT NULL, SOURCE_NAME VARCHAR2(1000) NOT NULL, SOURCE_TYPE VARCHAR2(1000) NOT NULL, OPERATION VARCHAR2(50) NOT NULL, ACTION_TIMESTAMP TIMESTAMP NOT NULL )";
    private static final String CREATE_PROCESSOR_DETAILS_TABLE = "CREATE TABLE PROCESSOR_DETAILS (ACTION_ID INT NOT NULL PRIMARY KEY, TYPE VARCHAR2(1000) NOT NULL, FOREIGN KEY (ACTION_ID) REFERENCES ACTION(ID))";
    private static final String CREATE_REMOTE_PROCESS_GROUP_DETAILS_TABLE = "CREATE TABLE REMOTE_PROCESS_GROUP_DETAILS (ACTION_ID INT NOT NULL PRIMARY KEY, URI VARCHAR2(2500) NOT NULL, FOREIGN KEY (ACTION_ID) REFERENCES ACTION(ID))";
    private static final String CREATE_MOVE_DETAILS_TABLE = "CREATE TABLE MOVE_DETAILS (ACTION_ID INT NOT NULL PRIMARY KEY, GROUP_ID VARCHAR2(100) NOT NULL, GROUP_NAME VARCHAR2(1000) NOT NULL, PREVIOUS_GROUP_ID VARCHAR2(100) NOT NULL, PREVIOUS_GROUP_NAME VARCHAR2(1000) NOT NULL, FOREIGN KEY (ACTION_ID) REFERENCES ACTION(ID))";
    private static final String CREATE_CONFIGURE_DETAILS_TABLE = "CREATE TABLE CONFIGURE_DETAILS (ACTION_ID INT NOT NULL PRIMARY KEY, NAME VARCHAR2(1000) NOT NULL, \"VALUE\" VARCHAR2(5000), PREVIOUS_VALUE VARCHAR2(5000), FOREIGN KEY (ACTION_ID) REFERENCES ACTION(ID))";
    private static final String CREATE_CONNECT_DETAILS_TABLE = "CREATE TABLE CONNECT_DETAILS (ACTION_ID INT NOT NULL PRIMARY KEY, SOURCE_ID VARCHAR2(100) NOT NULL, SOURCE_NAME VARCHAR2(1000), SOURCE_TYPE VARCHAR2(1000) NOT NULL, RELATIONSHIP VARCHAR2(1000), DESTINATION_ID VARCHAR2(100) NOT NULL, DESTINATION_NAME VARCHAR2(1000), DESTINATION_TYPE VARCHAR2(1000) NOT NULL, FOREIGN KEY (ACTION_ID) REFERENCES ACTION(ID))";
    private static final String CREATE_PURGE_DETAILS_TABLE = "CREATE TABLE PURGE_DETAILS (ACTION_ID INT NOT NULL PRIMARY KEY, END_DATE TIMESTAMP NOT NULL, FOREIGN KEY (ACTION_ID) REFERENCES ACTION(ID))";
    private JdbcConnectionPool connectionPool;
    private NiFiProperties properties;

    public Object getObject() throws Exception {
        if (this.connectionPool == null) {
            String repositoryDirectoryPath = this.properties.getProperty("nifi.database.directory");
            if (repositoryDirectoryPath == null) {
                throw new NullPointerException("Database directory must be specified.");
            }
            File repositoryDirectory = new File(repositoryDirectoryPath);
            File dbFileNoExtension = new File(repositoryDirectory, AUDIT_DATABASE_FILE_NAME);
            String databaseUrl = "jdbc:h2:" + dbFileNoExtension + ";AUTOCOMMIT=OFF;DB_CLOSE_ON_EXIT=FALSE;LOCK_MODE=3";
            String databaseUrlAppend = this.properties.getProperty("nifi.h2.url.append");
            if (StringUtils.isNotBlank((CharSequence)databaseUrlAppend)) {
                databaseUrl = databaseUrl + databaseUrlAppend;
            }
            String migrationDbUrl = "jdbc:h2:" + dbFileNoExtension + ";LOCK_MODE=3";
            H2DatabaseUpdater.checkAndPerformMigration((String)dbFileNoExtension.getAbsolutePath(), (String)migrationDbUrl, (String)NF_USERNAME_PASSWORD, (String)NF_USERNAME_PASSWORD);
            this.connectionPool = JdbcConnectionPool.create((String)databaseUrl, (String)NF_USERNAME_PASSWORD, (String)NF_USERNAME_PASSWORD);
            this.connectionPool.setMaxConnections(5);
            Connection connection = null;
            ResultSet rs = null;
            Statement statement = null;
            try {
                connection = this.connectionPool.getConnection();
                connection.setAutoCommit(false);
                statement = connection.createStatement();
                rs = connection.getMetaData().getTables(null, null, "ACTION", null);
                if (!rs.next()) {
                    logger.info("Database not built for repository: " + databaseUrl + ".  Building now...");
                    RepositoryUtils.closeQuietly(rs);
                    statement.execute(CREATE_ACTION_TABLE);
                    statement.execute(CREATE_PROCESSOR_DETAILS_TABLE);
                    statement.execute(CREATE_REMOTE_PROCESS_GROUP_DETAILS_TABLE);
                    statement.execute(CREATE_MOVE_DETAILS_TABLE);
                    statement.execute(CREATE_CONFIGURE_DETAILS_TABLE);
                    statement.execute(CREATE_CONNECT_DETAILS_TABLE);
                    statement.execute(CREATE_PURGE_DETAILS_TABLE);
                }
                connection.commit();
            }
            catch (SQLException sqle) {
                try {
                    RepositoryUtils.rollback(connection, logger);
                    throw sqle;
                }
                catch (Throwable throwable) {
                    RepositoryUtils.closeQuietly(rs);
                    RepositoryUtils.closeQuietly(statement);
                    RepositoryUtils.closeQuietly(connection);
                    throw throwable;
                }
            }
            RepositoryUtils.closeQuietly(rs);
            RepositoryUtils.closeQuietly(statement);
            RepositoryUtils.closeQuietly(connection);
        }
        return this.connectionPool;
    }

    public Class getObjectType() {
        return JdbcConnectionPool.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void shutdown() {
        block3: {
            if (this.connectionPool != null) {
                try {
                    this.connectionPool.dispose();
                }
                catch (Exception e) {
                    logger.warn("Unable to dispose of connection pool: " + e.getMessage());
                    if (!logger.isDebugEnabled()) break block3;
                    logger.warn("", (Throwable)e);
                }
            }
        }
    }
}

