/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.kafkamigrator.service;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.kafkamigrator.MigratorConfiguration;
import org.apache.nifi.toolkit.kafkamigrator.descriptor.KafkaProcessorType;
import org.apache.nifi.toolkit.kafkamigrator.migrator.Migrator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public interface KafkaMigrationService {
    public static final String REGEX_FOR_REPLACEABLE_PROCESSOR_NAMES = "(Get|Put|Consume|Publish)Kafka(Record)?(_0_1\\d)?";
    public static final boolean IS_VERSION_EIGHT_PROCESSOR = Boolean.TRUE;
    public static final boolean IS_NOT_VERSION_EIGHT_PROCESSOR = Boolean.FALSE;

    public String getPathForProcessors();

    public String getPathForClass();

    public Migrator createPublishMigrator(MigratorConfiguration.MigratorConfigurationBuilder var1);

    public Migrator createConsumeMigrator(MigratorConfiguration.MigratorConfigurationBuilder var1);

    public Migrator createVersionEightPublishMigrator(MigratorConfiguration.MigratorConfigurationBuilder var1);

    public Migrator createVersionEightConsumeMigrator(MigratorConfiguration.MigratorConfigurationBuilder var1);

    default public void replaceKafkaProcessors(Document document, MigratorConfiguration.MigratorConfigurationBuilder configurationBuilder) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList processors = (NodeList)xPath.evaluate(this.getPathForProcessors(), document, XPathConstants.NODESET);
        for (int i = 0; i < processors.getLength(); ++i) {
            Node processor = processors.item(i);
            Element className = (Element)xPath.evaluate(this.getPathForClass(), processor, XPathConstants.NODE);
            String processorName = StringUtils.substringAfterLast((String)className.getTextContent(), (String)".");
            if (!processorName.matches(REGEX_FOR_REPLACEABLE_PROCESSOR_NAMES)) continue;
            Migrator migrator = processorName.contains(KafkaProcessorType.PUBLISH.getProcessorType()) ? this.createPublishMigrator(configurationBuilder) : (processorName.contains(KafkaProcessorType.PUT.getProcessorType()) ? this.createVersionEightPublishMigrator(configurationBuilder) : (processorName.contains(KafkaProcessorType.CONSUME.getProcessorType()) ? this.createConsumeMigrator(configurationBuilder) : this.createVersionEightConsumeMigrator(configurationBuilder)));
            migrator.migrate(className, processor);
        }
    }
}

