/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.nifi.security.util.CertificateUtils;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.toolkit.tls.configuration.InstanceDefinition;
import org.apache.nifi.toolkit.tls.configuration.StandaloneConfig;
import org.apache.nifi.toolkit.tls.configuration.TlsClientConfig;
import org.apache.nifi.toolkit.tls.manager.TlsCertificateAuthorityManager;
import org.apache.nifi.toolkit.tls.manager.TlsClientManager;
import org.apache.nifi.toolkit.tls.manager.writer.NifiPropertiesTlsClientConfigWriter;
import org.apache.nifi.toolkit.tls.properties.NiFiPropertiesWriterFactory;
import org.apache.nifi.toolkit.tls.util.OutputStreamFactory;
import org.apache.nifi.toolkit.tls.util.TlsHelper;
import org.apache.nifi.util.StringUtils;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsToolkitStandalone {
    public static final String NIFI_KEY = "nifi-key";
    public static final String NIFI_CERT = "nifi-cert";
    public static final String NIFI_PROPERTIES = "nifi.properties";
    private final Logger logger = LoggerFactory.getLogger(TlsToolkitStandalone.class);
    private final OutputStreamFactory outputStreamFactory;

    public TlsToolkitStandalone() {
        this(FileOutputStream::new);
    }

    public TlsToolkitStandalone(OutputStreamFactory outputStreamFactory) {
        this.outputStreamFactory = outputStreamFactory;
    }

    public void splitKeystore(StandaloneConfig standaloneConfig) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new FileInputStream(standaloneConfig.getKeyStore()), standaloneConfig.getKeyStorePassword().toCharArray());
        if (keyStore.size() == 0) {
            throw new KeyStoreException("Provided keystore " + standaloneConfig.getKeyStore() + " was empty. No cert/key pairs to output to file.");
        }
        if (standaloneConfig.getKeyPassword() == null || standaloneConfig.getKeyPassword().isEmpty()) {
            this.splitKeystore(keyStore, standaloneConfig.getKeyStorePassword().toCharArray(), standaloneConfig.getBaseDir());
        } else {
            this.splitKeystore(keyStore, standaloneConfig.getKeyPassword().toCharArray(), standaloneConfig.getBaseDir());
        }
    }

    private void splitKeystore(KeyStore keyStore, char[] keyPassphrase, File outputDirectory) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        HashMap<String, Certificate> certificates = TlsHelper.extractCerts(keyStore);
        HashMap<String, Key> keys = TlsHelper.extractKeys(keyStore, keyPassphrase);
        TlsHelper.outputCertsAsPem(certificates, outputDirectory, ".crt");
        TlsHelper.outputKeysAsPem(keys, outputDirectory, ".key");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createNifiKeystoresAndTrustStores(StandaloneConfig standaloneConfig) throws GeneralSecurityException, IOException {
        Object pemEncodedCACertificate;
        KeyPair caKeyPair;
        X509Certificate certificate;
        File baseDir = standaloneConfig.getBaseDir();
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            throw new IOException(baseDir + " doesn't exist and unable to create it.");
        }
        if (!baseDir.isDirectory()) {
            throw new IOException("Expected directory to output to");
        }
        String signingAlgorithm = standaloneConfig.getSigningAlgorithm();
        int days = standaloneConfig.getDays();
        String keyPairAlgorithm = standaloneConfig.getKeyPairAlgorithm();
        int keySize = standaloneConfig.getKeySize();
        File nifiCert = new File(baseDir, "nifi-cert.pem");
        File nifiKey = new File(baseDir, "nifi-key.key");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Running standalone certificate generation with output directory " + baseDir);
        }
        if (nifiCert.exists()) {
            if (!nifiKey.exists()) {
                throw new IOException(nifiCert + " exists already, but " + nifiKey + " does not, we need both certificate and key to continue with an existing CA.");
            }
            try (FileReader pemEncodedCertificate = new FileReader(nifiCert);){
                certificate = TlsHelper.parseCertificate(pemEncodedCertificate);
            }
            var12_10 = null;
            try (FileReader pemEncodedKeyPair = new FileReader(nifiKey);){
                caKeyPair = TlsHelper.parseKeyPairFromReader(pemEncodedKeyPair);
            }
            catch (Throwable throwable) {
                var12_10 = throwable;
                throw throwable;
            }
            ArrayList<X509Certificate> signingCertificates = new ArrayList<X509Certificate>();
            if (!StringUtils.isBlank((String)standaloneConfig.getAdditionalCACertificate())) {
                X509Certificate signingCertificate;
                File additionalCACertFile = new File(standaloneConfig.getAdditionalCACertificate());
                if (!additionalCACertFile.exists()) {
                    throw new IOException("The additional CA certificate does not exist at " + additionalCACertFile.getAbsolutePath());
                }
                pemEncodedCACertificate = new FileReader(additionalCACertFile);
                Object object = null;
                try {
                    signingCertificate = TlsHelper.parseCertificate((Reader)pemEncodedCACertificate);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (pemEncodedCACertificate != null) {
                        if (object != null) {
                            try {
                                ((InputStreamReader)pemEncodedCACertificate).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStreamReader)pemEncodedCACertificate).close();
                        }
                    }
                }
                signingCertificates.add(signingCertificate);
            }
            signingCertificates.add(certificate);
            boolean signatureValid = TlsHelper.verifyCertificateSignature(certificate, signingCertificates);
            if (!signatureValid) {
                throw new SignatureException("The signing certificate was not signed by any known certificates");
            }
            if (!caKeyPair.getPublic().equals(certificate.getPublicKey())) {
                throw new IOException("Expected " + nifiKey + " to correspond to CA certificate at " + nifiCert);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Using existing CA certificate " + nifiCert + " and key " + nifiKey);
            }
        } else {
            if (nifiKey.exists()) {
                throw new IOException(nifiKey + " exists already, but " + nifiCert + " does not, we need both certificate and key to continue with an existing CA.");
            }
            TlsCertificateAuthorityManager tlsCertificateAuthorityManager = new TlsCertificateAuthorityManager(standaloneConfig);
            KeyStore.PrivateKeyEntry privateKeyEntry = tlsCertificateAuthorityManager.getOrGenerateCertificateAuthority();
            certificate = (X509Certificate)privateKeyEntry.getCertificateChain()[0];
            caKeyPair = new KeyPair(certificate.getPublicKey(), privateKeyEntry.getPrivateKey());
            PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(this.outputStreamFactory.create(nifiCert)));
            pemEncodedCACertificate = null;
            try {
                pemWriter.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)certificate));
            }
            catch (Throwable throwable) {
                pemEncodedCACertificate = throwable;
                throw throwable;
            }
            finally {
                if (pemWriter != null) {
                    if (pemEncodedCACertificate != null) {
                        try {
                            pemWriter.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)pemEncodedCACertificate).addSuppressed(throwable);
                        }
                    } else {
                        pemWriter.close();
                    }
                }
            }
            pemWriter = new PemWriter((Writer)new OutputStreamWriter(this.outputStreamFactory.create(nifiKey)));
            pemEncodedCACertificate = null;
            try {
                pemWriter.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)caKeyPair));
            }
            catch (Throwable throwable) {
                pemEncodedCACertificate = throwable;
                throw throwable;
            }
            finally {
                if (pemWriter != null) {
                    if (pemEncodedCACertificate != null) {
                        try {
                            pemWriter.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)pemEncodedCACertificate).addSuppressed(throwable);
                        }
                    } else {
                        pemWriter.close();
                    }
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Generated new CA certificate " + nifiCert + " and key " + nifiKey);
            }
        }
        NiFiPropertiesWriterFactory niFiPropertiesWriterFactory = standaloneConfig.getNiFiPropertiesWriterFactory();
        boolean overwrite = standaloneConfig.isOverwrite();
        List<InstanceDefinition> instanceDefinitions = standaloneConfig.getInstanceDefinitions();
        if (instanceDefinitions.isEmpty() && this.logger.isInfoEnabled()) {
            this.logger.info("No hostnames specified, not generating any host certificates or configuration.");
        }
        List<String> domainAlternativeNames = standaloneConfig.getDomainAlternativeNames();
        for (Integer instanceIndex : IntStream.range(0, instanceDefinitions.size()).boxed().collect(Collectors.toList())) {
            InstanceDefinition instanceDefinition = instanceDefinitions.get(instanceIndex);
            String hostname = instanceDefinition.getHostname();
            int hostIdentifierNumber = instanceDefinition.getInstanceIdentifier().getNumber();
            File hostDir = hostIdentifierNumber == 1 ? new File(baseDir, hostname) : new File(baseDir, hostname + "_" + hostIdentifierNumber);
            TlsClientConfig tlsClientConfig = new TlsClientConfig(standaloneConfig);
            File keystore = new File(hostDir, "keystore." + tlsClientConfig.getKeyStoreType().toLowerCase());
            File truststore = new File(hostDir, "truststore." + tlsClientConfig.getTrustStoreType().toLowerCase());
            if (domainAlternativeNames.size() == 1) {
                tlsClientConfig.setDomainAlternativeNames(Collections.singletonList(domainAlternativeNames.get(0)));
            } else if (domainAlternativeNames.size() == instanceDefinitions.size()) {
                tlsClientConfig.setDomainAlternativeNames(Collections.singletonList(domainAlternativeNames.get(instanceIndex)));
                this.logger.info("Using alternate name " + domainAlternativeNames.get(instanceIndex) + " with hostname " + hostname + ".");
            } else if (domainAlternativeNames.size() > 0) {
                this.logger.warn("Hostname count does not match given alternate name count. Verify names in resulting certificate.");
            }
            if (hostDir.exists()) {
                if (!hostDir.isDirectory()) {
                    throw new IOException(hostDir + " exists but is not a directory.");
                }
                if (!overwrite) throw new IOException(hostDir + " exists and overwrite is not set.");
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Overwriting any existing ssl configuration in " + hostDir);
                }
                keystore.delete();
                if (keystore.exists()) {
                    throw new IOException("Keystore " + keystore + " already exists and couldn't be deleted.");
                }
                truststore.delete();
                if (truststore.exists()) {
                    throw new IOException("Truststore " + truststore + " already exists and couldn't be deleted.");
                }
            } else {
                if (!hostDir.mkdirs()) {
                    throw new IOException("Unable to make directory: " + hostDir.getAbsolutePath());
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Writing new ssl configuration to " + hostDir);
                }
            }
            tlsClientConfig.setKeyStore(keystore.getAbsolutePath());
            tlsClientConfig.setKeyStorePassword(instanceDefinition.getKeyStorePassword());
            tlsClientConfig.setKeyPassword(instanceDefinition.getKeyPassword());
            tlsClientConfig.setTrustStore(truststore.getAbsolutePath());
            tlsClientConfig.setTrustStorePassword(instanceDefinition.getTrustStorePassword());
            TlsClientManager tlsClientManager = new TlsClientManager(tlsClientConfig);
            KeyPair keyPair = TlsHelper.generateKeyPair(keyPairAlgorithm, keySize);
            Extensions sanDnsExtensions = TlsHelper.createDomainAlternativeNamesExtensions(tlsClientConfig.getDomainAlternativeNames(), tlsClientConfig.calcDefaultDn(hostname));
            tlsClientManager.addPrivateKeyToKeyStore(keyPair, NIFI_KEY, CertificateUtils.generateIssuedCertificate((String)tlsClientConfig.calcDefaultDn(hostname), (PublicKey)keyPair.getPublic(), (Extensions)sanDnsExtensions, (X509Certificate)certificate, (KeyPair)caKeyPair, (String)signingAlgorithm, (int)days), certificate);
            tlsClientManager.setCertificateEntry(NIFI_CERT, certificate);
            tlsClientManager.addClientConfigurationWriter(new NifiPropertiesTlsClientConfigWriter(niFiPropertiesWriterFactory, new File(hostDir, NIFI_PROPERTIES), hostname, instanceDefinition.getNumber()));
            tlsClientManager.write(this.outputStreamFactory);
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("Successfully generated TLS configuration for " + hostname + " " + hostIdentifierNumber + " in " + hostDir);
        }
        List<String> clientDns = standaloneConfig.getClientDns();
        if (standaloneConfig.getClientDns().isEmpty() && this.logger.isInfoEnabled()) {
            this.logger.info("No clientCertDn specified, not generating any client certificates.");
        }
        List<String> clientPasswords = standaloneConfig.getClientPasswords();
        for (int i = 0; i < clientDns.size(); ++i) {
            String reorderedDn = CertificateUtils.reorderDn((String)clientDns.get(i));
            String clientDnFile = TlsHelper.escapeFilename(reorderedDn);
            File clientCertFile = new File(baseDir, clientDnFile + ".p12");
            if (clientCertFile.exists()) {
                if (!overwrite) throw new IOException(clientCertFile + " exists and overwrite is not set.");
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Overwriting existing client cert " + clientCertFile);
                }
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info("Generating new client certificate " + clientCertFile);
            }
            KeyPair keyPair = TlsHelper.generateKeyPair(keyPairAlgorithm, keySize);
            X509Certificate clientCert = CertificateUtils.generateIssuedCertificate((String)reorderedDn, (PublicKey)keyPair.getPublic(), null, (X509Certificate)certificate, (KeyPair)caKeyPair, (String)signingAlgorithm, (int)days);
            String keyStorePassword = clientPasswords.get(i);
            KeyStore keyStore = this.setClientKeyStore(keyStorePassword, keyPair.getPrivate(), clientCert, certificate);
            String password = TlsHelper.writeKeyStore(keyStore, this.outputStreamFactory, clientCertFile, keyStorePassword, standaloneConfig.isClientPasswordsGenerated());
            try (FileWriter fileWriter = new FileWriter(new File(baseDir, clientDnFile + ".password"));){
                fileWriter.write(password);
            }
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("Successfully generated client certificate " + clientCertFile);
        }
        if (!this.logger.isInfoEnabled()) return;
        this.logger.info("tls-toolkit standalone completed successfully");
    }

    protected KeyStore setClientKeyStore(String keyStorePassword, PrivateKey privateKey, X509Certificate clientCertificate, X509Certificate issuerCertificate) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStoreUtils.getKeyStore((String)KeystoreType.PKCS12.toString());
        keyStore.load(null, null);
        char[] keyPassword = keyStorePassword.toCharArray();
        Certificate[] certificates = new X509Certificate[]{clientCertificate, issuerCertificate};
        keyStore.setKeyEntry(NIFI_KEY, privateKey, keyPassword, certificates);
        return keyStore;
    }
}

