/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.std.Unsafe;
import java.io.Closeable;

public abstract class SuspendEvent
implements Closeable {
    private static final long REF_COUNT_OFFSET = Unsafe.getFieldOffset(SuspendEvent.class, "refCount");
    private long deadline = Long.MAX_VALUE;
    private volatile int refCount = 2;

    public abstract void _close();

    public abstract boolean checkTriggered();

    @Override
    public void close() {
        int prevRefCount = Unsafe.getUnsafe().getAndAddInt(this, REF_COUNT_OFFSET, -1);
        if (prevRefCount == 1) {
            this._close();
        }
    }

    public long getDeadline() {
        return this.deadline;
    }

    public abstract int getFd();

    public boolean isClosedByAtLeastOneSide() {
        return this.refCount <= 1;
    }

    public boolean isDeadlineMet(long timestamp) {
        return this.deadline > 0L && this.deadline <= timestamp;
    }

    public void setDeadline(long deadline) {
        this.deadline = deadline;
    }

    public abstract void trigger();
}

