/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore;

import java.net.URI;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;

@SdkPublicApi
public abstract class AwsServiceClientConfiguration
extends SdkServiceClientConfiguration {
    private final Region region;

    protected AwsServiceClientConfiguration(Builder builder) {
        super((SdkServiceClientConfiguration.Builder)builder);
        this.region = builder.region();
    }

    public Region region() {
        return this.region;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AwsServiceClientConfiguration serviceClientConfiguration = (AwsServiceClientConfiguration)((Object)o);
        return Objects.equals(this.region, serviceClientConfiguration.region);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        return result;
    }

    protected static abstract class BuilderImpl
    implements Builder {
        protected ClientOverrideConfiguration overrideConfiguration;
        protected Region region;
        protected URI endpointOverride;
        protected EndpointProvider endpointProvider;

        protected BuilderImpl() {
        }

        protected BuilderImpl(AwsServiceClientConfiguration awsServiceClientConfiguration) {
            this.overrideConfiguration = awsServiceClientConfiguration.overrideConfiguration();
            this.region = awsServiceClientConfiguration.region();
            this.endpointOverride = awsServiceClientConfiguration.endpointOverride().orElse(null);
            this.endpointProvider = awsServiceClientConfiguration.endpointProvider().orElse(null);
        }

        public final ClientOverrideConfiguration overrideConfiguration() {
            return this.overrideConfiguration;
        }

        @Override
        public final Region region() {
            return this.region;
        }

        public final URI endpointOverride() {
            return this.endpointOverride;
        }

        public final EndpointProvider endpointProvider() {
            return this.endpointProvider;
        }
    }

    public static interface Builder
    extends SdkServiceClientConfiguration.Builder {
        public Region region();

        public Builder region(Region var1);

        public Builder overrideConfiguration(ClientOverrideConfiguration var1);

        public Builder endpointOverride(URI var1);

        public Builder endpointProvider(EndpointProvider var1);

        public AwsServiceClientConfiguration build();
    }
}

