/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import java.util.Arrays;

class ByteExtensions {
    ByteExtensions() {
    }

    static byte[] or(byte[] self, byte[] other) {
        return ByteExtensions.or(self, other, 0);
    }

    static byte[] or(byte[] self, byte[] other, int offset) {
        if (self == null) {
            throw new IllegalArgumentException("self");
        }
        if (other == null) {
            throw new IllegalArgumentException("other");
        }
        if (self.length > other.length - offset) {
            throw new IllegalArgumentException("self and other lengths do not match");
        }
        byte[] result = new byte[self.length];
        for (int i = 0; i < self.length; ++i) {
            result[i] = (byte)(self[i] | other[offset + i]);
        }
        return result;
    }

    static byte[] xor(byte[] self, byte[] other) {
        return ByteExtensions.xor(self, other, 0);
    }

    static byte[] xor(byte[] self, byte[] other, int offset) {
        if (self == null) {
            throw new IllegalArgumentException("self");
        }
        if (other == null) {
            throw new IllegalArgumentException("other");
        }
        if (self.length > other.length - offset) {
            throw new IllegalArgumentException("self and other lengths do not match");
        }
        byte[] result = new byte[self.length];
        for (int i = 0; i < self.length; ++i) {
            result[i] = (byte)(self[i] ^ other[offset + i]);
        }
        return result;
    }

    static void zero(byte[] self) {
        if (self != null) {
            Arrays.fill(self, (byte)0);
        }
    }

    static boolean sequenceEqualConstantTime(byte[] self, byte[] other) {
        if (self == null) {
            throw new IllegalArgumentException("self");
        }
        if (other == null) {
            throw new IllegalArgumentException("other");
        }
        long difference = (long)self.length & 0xFFFFFFFFL ^ (long)other.length & 0xFFFFFFFFL;
        for (int i = 0; i < self.length && i < other.length; ++i) {
            difference |= (long)(self[i] ^ other[i]) & 0xFFFFFFFFL;
        }
        return difference == 0L;
    }
}

