/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.service.extension;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.extension.ExtensionFilterParams;
import org.apache.nifi.extension.ExtensionMetadata;
import org.apache.nifi.extension.TagCount;
import org.apache.nifi.extension.manifest.Extension;
import org.apache.nifi.extension.manifest.ProvidedServiceAPI;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.bundle.extract.BundleExtractor;
import org.apache.nifi.registry.bundle.model.BundleDetails;
import org.apache.nifi.registry.bundle.model.BundleIdentifier;
import org.apache.nifi.registry.db.entity.BucketEntity;
import org.apache.nifi.registry.db.entity.BundleEntity;
import org.apache.nifi.registry.db.entity.BundleVersionDependencyEntity;
import org.apache.nifi.registry.db.entity.BundleVersionEntity;
import org.apache.nifi.registry.db.entity.ExtensionAdditionalDetailsEntity;
import org.apache.nifi.registry.db.entity.ExtensionEntity;
import org.apache.nifi.registry.exception.ResourceNotFoundException;
import org.apache.nifi.registry.extension.BundleCoordinate;
import org.apache.nifi.registry.extension.BundlePersistenceContext;
import org.apache.nifi.registry.extension.BundlePersistenceProvider;
import org.apache.nifi.registry.extension.BundleVersionCoordinate;
import org.apache.nifi.registry.extension.BundleVersionType;
import org.apache.nifi.registry.extension.bundle.BuildInfo;
import org.apache.nifi.registry.extension.bundle.Bundle;
import org.apache.nifi.registry.extension.bundle.BundleFilterParams;
import org.apache.nifi.registry.extension.bundle.BundleType;
import org.apache.nifi.registry.extension.bundle.BundleVersion;
import org.apache.nifi.registry.extension.bundle.BundleVersionDependency;
import org.apache.nifi.registry.extension.bundle.BundleVersionFilterParams;
import org.apache.nifi.registry.extension.bundle.BundleVersionMetadata;
import org.apache.nifi.registry.extension.repo.ExtensionRepoArtifact;
import org.apache.nifi.registry.extension.repo.ExtensionRepoBucket;
import org.apache.nifi.registry.extension.repo.ExtensionRepoGroup;
import org.apache.nifi.registry.extension.repo.ExtensionRepoVersionSummary;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.provider.extension.StandardBundleCoordinate;
import org.apache.nifi.registry.provider.extension.StandardBundlePersistenceContext;
import org.apache.nifi.registry.provider.extension.StandardBundleVersionCoordinate;
import org.apache.nifi.registry.security.authorization.user.NiFiUserUtils;
import org.apache.nifi.registry.serialization.Serializer;
import org.apache.nifi.registry.service.MetadataService;
import org.apache.nifi.registry.service.extension.ExtensionService;
import org.apache.nifi.registry.service.extension.docs.ExtensionDocWriter;
import org.apache.nifi.registry.service.mapper.BucketMappings;
import org.apache.nifi.registry.service.mapper.ExtensionMappings;
import org.apache.nifi.registry.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StandardExtensionService
implements ExtensionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardExtensionService.class);
    static final String SNAPSHOT_VERSION_SUFFIX = "SNAPSHOT";
    private final Serializer<Extension> extensionSerializer;
    private final ExtensionDocWriter extensionDocWriter;
    private final MetadataService metadataService;
    private final Map<BundleType, BundleExtractor> extractors;
    private final BundlePersistenceProvider bundlePersistenceProvider;
    private final Validator validator;
    private final File extensionsWorkingDir;

    @Autowired
    public StandardExtensionService(Serializer<Extension> extensionSerializer, ExtensionDocWriter extensionDocWriter, MetadataService metadataService, Map<BundleType, BundleExtractor> extractors, BundlePersistenceProvider bundlePersistenceProvider, Validator validator, NiFiRegistryProperties properties) {
        this.extensionSerializer = extensionSerializer;
        this.extensionDocWriter = extensionDocWriter;
        this.metadataService = metadataService;
        this.extractors = extractors;
        this.bundlePersistenceProvider = bundlePersistenceProvider;
        this.validator = validator;
        this.extensionsWorkingDir = properties.getExtensionsWorkingDirectory();
        Validate.notNull(this.extensionSerializer);
        Validate.notNull((Object)this.metadataService);
        Validate.notNull(this.extractors);
        Validate.notNull((Object)this.bundlePersistenceProvider);
        Validate.notNull((Object)this.validator);
        Validate.notNull((Object)this.extensionsWorkingDir);
    }

    private <T> void validate(T t, String invalidMessage) {
        Set violations = this.validator.validate(t, new Class[0]);
        if (violations.size() > 0) {
            throw new ConstraintViolationException(invalidMessage, violations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleVersion createBundleVersion(String bucketIdentifier, BundleType bundleType, InputStream inputStream, String clientSha256) throws IOException {
        BundleVersion bundleVersion;
        block54: {
            if (StringUtils.isBlank((CharSequence)bucketIdentifier)) {
                throw new IllegalArgumentException("Bucket identifier cannot be null or blank");
            }
            if (bundleType == null) {
                throw new IllegalArgumentException("Bundle type cannot be null");
            }
            if (inputStream == null) {
                throw new IllegalArgumentException("Extension bundle input stream cannot be null");
            }
            if (!this.extractors.containsKey(bundleType)) {
                throw new IllegalArgumentException("No metadata extractor is registered for bundle-type: " + bundleType);
            }
            BucketEntity existingBucket = this.getBucketEntity(bucketIdentifier);
            FileUtils.ensureDirectoryExistAndCanReadAndWrite((File)this.extensionsWorkingDir);
            String extensionWorkingFilename = UUID.randomUUID().toString();
            File extensionWorkingFile = new File(this.extensionsWorkingDir, extensionWorkingFilename);
            LOGGER.debug("Writing bundle contents to working directory at {}", new Object[]{extensionWorkingFile.getAbsolutePath()});
            try {
                BundleDetails bundleDetails;
                boolean sha256Supplied;
                MessageDigest sha256Digest = DigestUtils.getSha256Digest();
                try (DigestInputStream digestInputStream = new DigestInputStream(inputStream, sha256Digest);
                     FileOutputStream out = new FileOutputStream(extensionWorkingFile);){
                    IOUtils.copy((InputStream)digestInputStream, (OutputStream)out);
                }
                String sha256Hex = Hex.encodeHexString((byte[])sha256Digest.digest());
                boolean bl = sha256Supplied = !StringUtils.isBlank((CharSequence)clientSha256);
                if (sha256Supplied && !sha256Hex.equalsIgnoreCase(clientSha256)) {
                    LOGGER.error("Client provided SHA-256 of '{}', but server calculated '{}'", new Object[]{clientSha256, sha256Hex});
                    throw new IllegalStateException("The SHA-256 of the received extension bundle does not match the SHA-256 provided by the client");
                }
                try (FileInputStream in = new FileInputStream(extensionWorkingFile);){
                    BundleExtractor extractor = this.extractors.get(bundleType);
                    bundleDetails = extractor.extract((InputStream)in);
                }
                BundleIdentifier bundleIdentifier = bundleDetails.getBundleIdentifier();
                BuildInfo buildInfo = bundleDetails.getBuildInfo();
                String groupId = bundleIdentifier.getGroupId();
                String artifactId = bundleIdentifier.getArtifactId();
                String version = bundleIdentifier.getVersion();
                boolean isSnapshotVersion = version.endsWith(SNAPSHOT_VERSION_SUFFIX);
                boolean overwriteBundleVersion = isSnapshotVersion || existingBucket.isAllowExtensionBundleRedeploy();
                LOGGER.debug("Extracted bundle details - '{}:{}:{}'", new Object[]{groupId, artifactId, version});
                List<BundleVersionEntity> allExistingVersions = this.metadataService.getBundleVersionsGlobal(groupId, artifactId, version);
                for (BundleVersionEntity existingVersionEntity : allExistingVersions) {
                    if (existingVersionEntity.getSha256Hex().equals(sha256Hex) || isSnapshotVersion) continue;
                    throw new IllegalStateException("Found existing extension bundle with same group, artifact, and version, but different SHA-256 checksums");
                }
                long currentTime = System.currentTimeMillis();
                BundleEntity bundleEntity = this.getOrCreateExtensionBundle(bucketIdentifier, groupId, artifactId, bundleType, currentTime);
                BundleVersionEntity existingVersion = this.metadataService.getBundleVersion(bucketIdentifier, groupId, artifactId, version);
                if (existingVersion != null) {
                    if (overwriteBundleVersion) {
                        LOGGER.debug("Bundle overwriting allowed, deleting existing version...");
                        this.metadataService.deleteBundleVersion(existingVersion);
                    } else {
                        LOGGER.warn("The specified version [{}] already exists for extension bundle [{}].", new Object[]{version, bundleEntity.getId()});
                        throw new IllegalStateException("The specified version already exists for the given extension bundle");
                    }
                }
                String userIdentity = NiFiUserUtils.getNiFiUserIdentity();
                BundleVersionMetadata versionMetadata = new BundleVersionMetadata();
                versionMetadata.setId(UUID.randomUUID().toString());
                versionMetadata.setBundleId(bundleEntity.getId());
                versionMetadata.setBucketId(bucketIdentifier);
                versionMetadata.setVersion(version);
                versionMetadata.setTimestamp(currentTime);
                versionMetadata.setAuthor(userIdentity);
                versionMetadata.setSha256(sha256Hex);
                versionMetadata.setSha256Supplied(Boolean.valueOf(sha256Supplied));
                versionMetadata.setContentSize(extensionWorkingFile.length());
                versionMetadata.setSystemApiVersion(bundleDetails.getSystemApiVersion());
                versionMetadata.setBuildInfo(buildInfo);
                this.validate(versionMetadata, "Cannot create extension bundle version");
                BundleVersionEntity versionEntity = ExtensionMappings.map(versionMetadata);
                this.metadataService.createBundleVersion(versionEntity);
                Set<BundleVersionDependencyEntity> dependencyEntities = this.getDependencyEntities(versionEntity, bundleDetails);
                dependencyEntities.forEach(d -> this.metadataService.createDependency((BundleVersionDependencyEntity)d));
                Set<ExtensionEntity> extensionEntities = this.getExtensionEntities(versionEntity, bundleDetails);
                extensionEntities.forEach(e -> this.metadataService.createExtension((ExtensionEntity)e));
                this.persistBundleVersionContent(bundleType, bundleEntity, versionEntity, extensionWorkingFile, overwriteBundleVersion);
                BundleEntity updatedBundle = this.metadataService.getBundle(bucketIdentifier, groupId, artifactId);
                BundleVersion bundleVersion2 = new BundleVersion();
                bundleVersion2.setVersionMetadata(versionMetadata);
                bundleVersion2.setBundle(ExtensionMappings.map(existingBucket, updatedBundle));
                bundleVersion2.setBucket(BucketMappings.map(existingBucket));
                HashSet dependencies = new HashSet();
                dependencyEntities.forEach(d -> dependencies.add(ExtensionMappings.map(d)));
                bundleVersion2.setDependencies(dependencies);
                LOGGER.debug("Created bundle - '{}:{}:{}'", new Object[]{groupId, artifactId, version});
                bundleVersion = bundleVersion2;
                if (!extensionWorkingFile.exists()) break block54;
            }
            catch (Throwable throwable) {
                if (extensionWorkingFile.exists()) {
                    try {
                        extensionWorkingFile.delete();
                    }
                    catch (Exception e2) {
                        LOGGER.warn("Error removing temporary extension bundle file at {}", new Object[]{extensionWorkingFile.getAbsolutePath()});
                    }
                }
                throw throwable;
            }
            try {
                extensionWorkingFile.delete();
            }
            catch (Exception e3) {
                LOGGER.warn("Error removing temporary extension bundle file at {}", new Object[]{extensionWorkingFile.getAbsolutePath()});
            }
        }
        return bundleVersion;
    }

    private Set<BundleVersionDependencyEntity> getDependencyEntities(BundleVersionEntity versionEntity, BundleDetails bundleDetails) {
        Set dependencyCoordinates = bundleDetails.getDependencies();
        if (dependencyCoordinates == null) {
            return Collections.emptySet();
        }
        HashSet<BundleVersionDependencyEntity> versionDependencies = new HashSet<BundleVersionDependencyEntity>();
        for (BundleIdentifier dependencyCoordinate : dependencyCoordinates) {
            BundleVersionDependency versionDependency = new BundleVersionDependency();
            versionDependency.setGroupId(dependencyCoordinate.getGroupId());
            versionDependency.setArtifactId(dependencyCoordinate.getArtifactId());
            versionDependency.setVersion(dependencyCoordinate.getVersion());
            this.validate(versionDependency, "Cannot create extension bundle version dependency");
            BundleVersionDependencyEntity versionDependencyEntity = ExtensionMappings.map(versionDependency);
            versionDependencyEntity.setId(UUID.randomUUID().toString());
            versionDependencyEntity.setExtensionBundleVersionId(versionEntity.getId());
            versionDependencies.add(versionDependencyEntity);
        }
        return versionDependencies;
    }

    private Set<ExtensionEntity> getExtensionEntities(BundleVersionEntity versionEntity, BundleDetails bundleDetails) {
        Set extensions = bundleDetails.getExtensions();
        if (extensions == null) {
            return Collections.emptySet();
        }
        HashSet<ExtensionEntity> extensionEntities = new HashSet<ExtensionEntity>();
        Map additionalDetails = bundleDetails.getAdditionalDetails();
        for (Extension extension : extensions) {
            this.validate(extension, "Invalid extension due to one or more constraint violations");
            ExtensionEntity extensionEntity = ExtensionMappings.map(extension, this.extensionSerializer);
            extensionEntity.setId(UUID.randomUUID().toString());
            extensionEntity.setBundleVersionId(versionEntity.getId());
            if (extensionEntity.getRestrictions() != null) {
                extensionEntity.getRestrictions().forEach(r -> {
                    r.setId(UUID.randomUUID().toString());
                    r.setExtensionId(extensionEntity.getId());
                });
            }
            extensionEntity.getProvidedServiceApis().forEach(p -> {
                p.setId(UUID.randomUUID().toString());
                p.setExtensionId(extensionEntity.getId());
            });
            String additionalDetailsContent = (String)additionalDetails.get(extensionEntity.getName());
            if (!StringUtils.isBlank((CharSequence)additionalDetailsContent)) {
                LOGGER.debug("Found additional details documentation for extension '{}'", new Object[]{extensionEntity.getName()});
                extensionEntity.setAdditionalDetails(additionalDetailsContent);
            }
            extensionEntities.add(extensionEntity);
        }
        return extensionEntities;
    }

    private BundleEntity getOrCreateExtensionBundle(String bucketId, String groupId, String artifactId, BundleType bundleType, long currentTime) {
        BundleEntity existingBundleEntity = this.metadataService.getBundle(bucketId, groupId, artifactId);
        if (existingBundleEntity == null) {
            Bundle bundle = new Bundle();
            bundle.setIdentifier(UUID.randomUUID().toString());
            bundle.setBucketIdentifier(bucketId);
            bundle.setName(groupId + ":" + artifactId);
            bundle.setGroupId(groupId);
            bundle.setArtifactId(artifactId);
            bundle.setBundleType(bundleType);
            bundle.setCreatedTimestamp(currentTime);
            bundle.setModifiedTimestamp(currentTime);
            this.validate(bundle, "Cannot create extension bundle");
            existingBundleEntity = this.metadataService.createBundle(ExtensionMappings.map(bundle));
        } else if (bundleType != existingBundleEntity.getBundleType()) {
            throw new IllegalStateException("A bundle already exists with the same group id and artifact id, but a different bundle type");
        }
        return existingBundleEntity;
    }

    private void persistBundleVersionContent(BundleType bundleType, BundleEntity bundle, BundleVersionEntity bundleVersion, File extensionWorkingFile, boolean overwriteBundleVersion) throws IOException {
        StandardBundleVersionCoordinate versionCoordinate = new StandardBundleVersionCoordinate.Builder().bucketId(bundle.getBucketId()).groupId(bundle.getGroupId()).artifactId(bundle.getArtifactId()).version(bundleVersion.getVersion()).type(this.getProviderBundleType(bundleType)).build();
        StandardBundlePersistenceContext context = new StandardBundlePersistenceContext.Builder().coordinate(versionCoordinate).bundleSize(bundleVersion.getContentSize()).author(bundleVersion.getCreatedBy()).timestamp(bundleVersion.getCreated().getTime()).build();
        try (FileInputStream in = new FileInputStream(extensionWorkingFile);
             BufferedInputStream bufIn = new BufferedInputStream(in);){
            if (overwriteBundleVersion) {
                this.bundlePersistenceProvider.updateBundleVersion((BundlePersistenceContext)context, (InputStream)bufIn);
                LOGGER.debug("Bundle version updated in persistence provider - {}", new Object[]{versionCoordinate.toString()});
            } else {
                this.bundlePersistenceProvider.createBundleVersion((BundlePersistenceContext)context, (InputStream)bufIn);
                LOGGER.debug("Bundle version created in persistence provider - {}", new Object[]{versionCoordinate.toString()});
            }
        }
    }

    private BundleVersionType getProviderBundleType(BundleType bundleType) {
        switch (bundleType) {
            case NIFI_NAR: {
                return BundleVersionType.NIFI_NAR;
            }
            case MINIFI_CPP: {
                return BundleVersionType.MINIFI_CPP;
            }
        }
        throw new IllegalArgumentException("Unknown bundle type: " + bundleType.toString());
    }

    @Override
    public List<Bundle> getBundles(Set<String> bucketIdentifiers, BundleFilterParams filterParams) {
        if (bucketIdentifiers == null) {
            throw new IllegalArgumentException("Bucket identifiers cannot be null");
        }
        List<BundleEntity> bundleEntities = this.metadataService.getBundles(bucketIdentifiers, filterParams == null ? BundleFilterParams.empty() : filterParams);
        return bundleEntities.stream().map(b -> ExtensionMappings.map(null, b)).collect(Collectors.toList());
    }

    @Override
    public List<Bundle> getBundlesByBucket(String bucketIdentifier) {
        if (StringUtils.isBlank((CharSequence)bucketIdentifier)) {
            throw new IllegalArgumentException("Bucket identifier cannot be null or blank");
        }
        BucketEntity existingBucket = this.getBucketEntity(bucketIdentifier);
        List<BundleEntity> bundleEntities = this.metadataService.getBundlesByBucket(bucketIdentifier);
        return bundleEntities.stream().map(b -> ExtensionMappings.map(existingBucket, b)).collect(Collectors.toList());
    }

    @Override
    public Bundle getBundle(String bundleIdentifier) {
        if (StringUtils.isBlank((CharSequence)bundleIdentifier)) {
            throw new IllegalArgumentException("Bundle identifier cannot be null or blank");
        }
        BundleEntity existingBundle = this.getBundleEntity(bundleIdentifier);
        BucketEntity existingBucket = this.getBucketEntity(existingBundle.getBucketId());
        return ExtensionMappings.map(existingBucket, existingBundle);
    }

    @Override
    public Bundle deleteBundle(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Extension bundle cannot be null");
        }
        this.metadataService.deleteBundle(bundle.getIdentifier());
        StandardBundleCoordinate bundleCoordinate = new StandardBundleCoordinate.Builder().bucketId(bundle.getBucketIdentifier()).groupId(bundle.getGroupId()).artifactId(bundle.getArtifactId()).build();
        this.bundlePersistenceProvider.deleteAllBundleVersions((BundleCoordinate)bundleCoordinate);
        return bundle;
    }

    @Override
    public SortedSet<BundleVersionMetadata> getBundleVersions(Set<String> bucketIdentifiers, BundleVersionFilterParams filterParams) {
        if (bucketIdentifiers == null) {
            throw new IllegalArgumentException("Bucket identifiers cannot be null");
        }
        TreeSet<BundleVersionMetadata> sortedVersions = new TreeSet<BundleVersionMetadata>(Comparator.comparing(BundleVersionMetadata::getBundleId).thenComparing(BundleVersionMetadata::getVersion));
        List<BundleVersionEntity> bundleVersionEntities = this.metadataService.getBundleVersions(bucketIdentifiers, filterParams == null ? BundleVersionFilterParams.empty() : filterParams);
        if (bundleVersionEntities != null) {
            bundleVersionEntities.forEach(bv -> sortedVersions.add(ExtensionMappings.map(bv)));
        }
        return sortedVersions;
    }

    @Override
    public SortedSet<BundleVersionMetadata> getBundleVersions(String bundleIdentifier) {
        if (StringUtils.isBlank((CharSequence)bundleIdentifier)) {
            throw new IllegalArgumentException("Extension bundle identifier cannot be null or blank");
        }
        BundleEntity existingBundle = this.getBundleEntity(bundleIdentifier);
        return this.getExtensionBundleVersionsSet(existingBundle);
    }

    private SortedSet<BundleVersionMetadata> getExtensionBundleVersionsSet(BundleEntity existingBundle) {
        TreeSet<BundleVersionMetadata> sortedVersions = new TreeSet<BundleVersionMetadata>(Collections.reverseOrder());
        List<BundleVersionEntity> existingVersions = this.metadataService.getBundleVersions(existingBundle.getId());
        if (existingVersions != null) {
            existingVersions.stream().forEach(s -> sortedVersions.add(ExtensionMappings.map(s)));
        }
        return sortedVersions;
    }

    @Override
    public BundleVersion getBundleVersion(String bucketId, String bundleId, String version) {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)bundleId)) {
            throw new IllegalArgumentException("Bundle id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        BucketEntity existingBucket = this.getBucketEntity(bucketId);
        BundleEntity existingBundle = this.getBundleEntity(bundleId);
        if (!existingBucket.getId().equals(existingBundle.getBucketId())) {
            throw new IllegalStateException("The requested bundle is not located in the given bucket");
        }
        BundleVersionEntity existingVersion = this.metadataService.getBundleVersion(bundleId, version);
        if (existingVersion == null) {
            LOGGER.warn("The specified version [{}] does not exist for extension bundle [{}].", new Object[]{version, bundleId});
            throw new ResourceNotFoundException("The specified extension bundle version does not exist.");
        }
        return this.getBundleVersion(existingBucket, existingBundle, existingVersion);
    }

    @Override
    public BundleVersion getBundleVersion(String bucketId, String groupId, String artifactId, String version) {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new IllegalArgumentException("Group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)artifactId)) {
            throw new IllegalArgumentException("Artifact id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("Version cannot be null or blank");
        }
        BucketEntity existingBucket = this.getBucketEntity(bucketId);
        BundleEntity existingBundle = this.metadataService.getBundle(bucketId, groupId, artifactId);
        if (existingBundle == null) {
            LOGGER.warn("The specified extension bundle [{}-{}-{}] does not exist.", new Object[]{bucketId, groupId, artifactId});
            throw new ResourceNotFoundException("The specified extension bundle does not exist in this bucket.");
        }
        BundleVersionEntity existingVersion = this.metadataService.getBundleVersion(bucketId, groupId, artifactId, version);
        if (existingVersion == null) {
            LOGGER.warn("The specified extension bundle version [{}-{}-{}-{}] does not exist.", new Object[]{bucketId, groupId, artifactId, version});
            throw new ResourceNotFoundException("The specified extension bundle version does not exist in this bucket.");
        }
        return this.getBundleVersion(existingBucket, existingBundle, existingVersion);
    }

    private BundleVersion getBundleVersion(BucketEntity existingBucket, BundleEntity existingBundle, BundleVersionEntity existingVersion) {
        List<BundleVersionDependencyEntity> existingVersionDependencies = this.metadataService.getDependenciesForBundleVersion(existingVersion.getId());
        Set dependencies = existingVersionDependencies.stream().map(d -> ExtensionMappings.map(d)).collect(Collectors.toSet());
        BundleVersion bundleVersion = new BundleVersion();
        bundleVersion.setVersionMetadata(ExtensionMappings.map(existingVersion));
        bundleVersion.setBundle(ExtensionMappings.map(existingBucket, existingBundle));
        bundleVersion.setBucket(BucketMappings.map(existingBucket));
        bundleVersion.setDependencies(dependencies);
        return bundleVersion;
    }

    @Override
    public void writeBundleVersionContent(BundleVersion bundleVersion, OutputStream out) {
        BundleVersionCoordinate versionCoordinate = this.getVersionCoordinate(bundleVersion);
        this.bundlePersistenceProvider.getBundleVersionContent(versionCoordinate, out);
    }

    @Override
    public BundleVersion deleteBundleVersion(BundleVersion bundleVersion) {
        if (bundleVersion == null) {
            throw new IllegalArgumentException("Extension bundle version cannot be null");
        }
        String extensionBundleVersionId = bundleVersion.getVersionMetadata().getId();
        this.metadataService.deleteBundleVersion(extensionBundleVersionId);
        BundleVersionCoordinate versionCoordinate = this.getVersionCoordinate(bundleVersion);
        this.bundlePersistenceProvider.deleteBundleVersion(versionCoordinate);
        return bundleVersion;
    }

    @Override
    public SortedSet<ExtensionMetadata> getExtensionMetadata(Set<String> bucketIdentifiers, ExtensionFilterParams filterParams) {
        if (bucketIdentifiers == null) {
            throw new IllegalArgumentException("Bucket identifiers cannot be null");
        }
        List<ExtensionEntity> extensionEntities = this.metadataService.getExtensions(bucketIdentifiers, filterParams);
        return this.getExtensionMetadata(extensionEntities);
    }

    @Override
    public SortedSet<ExtensionMetadata> getExtensionMetadata(Set<String> bucketIdentifiers, ProvidedServiceAPI serviceAPI) {
        if (bucketIdentifiers == null) {
            throw new IllegalArgumentException("Bucket identifiers cannot be null");
        }
        if (serviceAPI == null || StringUtils.isBlank((CharSequence)serviceAPI.getClassName()) || StringUtils.isBlank((CharSequence)serviceAPI.getGroupId()) || StringUtils.isBlank((CharSequence)serviceAPI.getArtifactId()) || StringUtils.isBlank((CharSequence)serviceAPI.getVersion())) {
            throw new IllegalArgumentException("Provided service API must be specified with a class, group, artifact, and version");
        }
        List<ExtensionEntity> extensionEntities = this.metadataService.getExtensionsByProvidedServiceApi(bucketIdentifiers, serviceAPI);
        return this.getExtensionMetadata(extensionEntities);
    }

    private SortedSet<ExtensionMetadata> getExtensionMetadata(List<ExtensionEntity> extensionEntities) {
        TreeSet<ExtensionMetadata> extensions = new TreeSet<ExtensionMetadata>();
        extensionEntities.forEach(e -> {
            ExtensionMetadata metadata = ExtensionMappings.mapToMetadata(e, this.extensionSerializer);
            extensions.add(metadata);
        });
        return extensions;
    }

    @Override
    public SortedSet<ExtensionMetadata> getExtensionMetadata(BundleVersion bundleVersion) {
        if (bundleVersion == null) {
            throw new IllegalArgumentException("Extension bundle version cannot be null");
        }
        BundleVersionEntity existingBundleVersion = this.metadataService.getBundleVersion(bundleVersion.getVersionMetadata().getBucketId(), bundleVersion.getBundle().getGroupId(), bundleVersion.getBundle().getArtifactId(), bundleVersion.getVersionMetadata().getVersion());
        if (existingBundleVersion == null) {
            LOGGER.warn("The specified extension bundle version does not exist for [{}] - [{}] - [{}] - [{}]", new Object[]{bundleVersion.getVersionMetadata().getBucketId(), bundleVersion.getBundle().getGroupId(), bundleVersion.getBundle().getArtifactId(), bundleVersion.getVersionMetadata().getVersion()});
            throw new ResourceNotFoundException("The specified extension bundle version does not exist.");
        }
        List<ExtensionEntity> extensionEntities = this.metadataService.getExtensionsByBundleVersionId(existingBundleVersion.getId());
        TreeSet<ExtensionMetadata> extensions = new TreeSet<ExtensionMetadata>();
        extensionEntities.forEach(e -> extensions.add(ExtensionMappings.mapToMetadata(e, this.extensionSerializer)));
        return extensions;
    }

    @Override
    public Extension getExtension(BundleVersion bundleVersion, String name) {
        if (bundleVersion == null) {
            throw new IllegalArgumentException("Bundle version cannot be null");
        }
        if (bundleVersion.getVersionMetadata() == null || StringUtils.isBlank((CharSequence)bundleVersion.getVersionMetadata().getId())) {
            throw new IllegalArgumentException("Bundle version must contain a version metadata with a bundle version id");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name cannot be null or blank");
        }
        ExtensionEntity entity = this.metadataService.getExtensionByName(bundleVersion.getVersionMetadata().getId(), name);
        if (entity == null) {
            LOGGER.warn("The specified extension [{}] does not exist in the specified bundle version [{}].", new Object[]{name, bundleVersion.getVersionMetadata().getId()});
            throw new ResourceNotFoundException("The specified extension does not exist in this registry.");
        }
        return ExtensionMappings.map(entity, this.extensionSerializer);
    }

    @Override
    public void writeExtensionDocs(BundleVersion bundleVersion, String name, OutputStream outputStream) throws IOException {
        if (bundleVersion == null) {
            throw new IllegalArgumentException("Bundle version cannot be null");
        }
        if (bundleVersion.getVersionMetadata() == null || StringUtils.isBlank((CharSequence)bundleVersion.getVersionMetadata().getId())) {
            throw new IllegalArgumentException("Bundle version must contain a version metadata with a bundle version id");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name cannot be null or blank");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream cannot be null");
        }
        ExtensionEntity entity = this.metadataService.getExtensionByName(bundleVersion.getVersionMetadata().getId(), name);
        if (entity == null) {
            LOGGER.warn("The specified extension [{}] does not exist in the specified bundle version [{}].", new Object[]{name, bundleVersion.getVersionMetadata().getId()});
            throw new ResourceNotFoundException("The specified extension does not exist in this registry.");
        }
        ExtensionMetadata extensionMetadata = ExtensionMappings.mapToMetadata(entity, this.extensionSerializer);
        Extension extension = ExtensionMappings.map(entity, this.extensionSerializer);
        this.extensionDocWriter.write(extensionMetadata, extension, outputStream);
    }

    @Override
    public void writeAdditionalDetailsDocs(BundleVersion bundleVersion, String name, OutputStream outputStream) throws IOException {
        if (bundleVersion == null) {
            throw new IllegalArgumentException("Bundle version cannot be null");
        }
        if (bundleVersion.getVersionMetadata() == null || StringUtils.isBlank((CharSequence)bundleVersion.getVersionMetadata().getId())) {
            throw new IllegalArgumentException("Bundle version must contain a version metadata with a bundle version id");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name cannot be null or blank");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream cannot be null");
        }
        ExtensionAdditionalDetailsEntity additionalDetailsEntity = this.metadataService.getExtensionAdditionalDetails(bundleVersion.getVersionMetadata().getId(), name);
        if (additionalDetailsEntity == null) {
            LOGGER.warn("The specified extension [{}] does not exist in the specified bundle version [{}].", new Object[]{name, bundleVersion.getVersionMetadata().getId()});
            throw new ResourceNotFoundException("The specified extension does not exist in this registry.");
        }
        if (!additionalDetailsEntity.getAdditionalDetails().isPresent()) {
            LOGGER.warn("The specified extension [{}] does not have additional details in the specified bundle version [{}].", new Object[]{name, bundleVersion.getVersionMetadata().getId()});
            throw new IllegalStateException("The specified extension does not have additional details.");
        }
        String additionalDetailsContent = additionalDetailsEntity.getAdditionalDetails().get();
        String componentUsageCssRef = "/nifi-registry-docs/css/component-usage.css";
        String updatedContent = additionalDetailsContent.replace("../../../../../css/component-usage.css", "/nifi-registry-docs/css/component-usage.css");
        IOUtils.write((String)updatedContent, (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public SortedSet<TagCount> getExtensionTags() {
        TreeSet<TagCount> tagCounts = new TreeSet<TagCount>();
        this.metadataService.getAllExtensionTags().forEach(tc -> tagCounts.add(ExtensionMappings.map(tc)));
        return tagCounts;
    }

    @Override
    public SortedSet<ExtensionRepoBucket> getExtensionRepoBuckets(Set<String> bucketIds) {
        if (bucketIds == null) {
            throw new IllegalArgumentException("Bucket ids cannot be null");
        }
        if (bucketIds.isEmpty()) {
            return new TreeSet<ExtensionRepoBucket>();
        }
        TreeSet<ExtensionRepoBucket> repoBuckets = new TreeSet<ExtensionRepoBucket>();
        List<BucketEntity> buckets = this.metadataService.getBuckets(bucketIds);
        buckets.forEach(b -> {
            ExtensionRepoBucket repoBucket = new ExtensionRepoBucket();
            repoBucket.setBucketName(b.getName());
            repoBuckets.add(repoBucket);
        });
        return repoBuckets;
    }

    @Override
    public SortedSet<ExtensionRepoGroup> getExtensionRepoGroups(Bucket bucket) {
        if (bucket == null) {
            throw new IllegalArgumentException("Bucket cannot be null");
        }
        TreeSet<ExtensionRepoGroup> repoGroups = new TreeSet<ExtensionRepoGroup>();
        List<BundleEntity> bundleEntities = this.metadataService.getBundlesByBucket(bucket.getIdentifier());
        bundleEntities.forEach(b -> {
            ExtensionRepoGroup repoGroup = new ExtensionRepoGroup();
            repoGroup.setBucketName(bucket.getName());
            repoGroup.setGroupId(b.getGroupId());
            repoGroups.add(repoGroup);
        });
        return repoGroups;
    }

    @Override
    public SortedSet<ExtensionRepoArtifact> getExtensionRepoArtifacts(Bucket bucket, String groupId) {
        if (bucket == null) {
            throw new IllegalArgumentException("Bucket cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new IllegalArgumentException("Group id cannot be null or blank");
        }
        TreeSet<ExtensionRepoArtifact> repoArtifacts = new TreeSet<ExtensionRepoArtifact>();
        List<BundleEntity> bundleEntities = this.metadataService.getBundlesByBucketAndGroup(bucket.getIdentifier(), groupId);
        bundleEntities.forEach(b -> {
            ExtensionRepoArtifact repoArtifact = new ExtensionRepoArtifact();
            repoArtifact.setBucketName(bucket.getName());
            repoArtifact.setGroupId(b.getGroupId());
            repoArtifact.setArtifactId(b.getArtifactId());
            repoArtifacts.add(repoArtifact);
        });
        return repoArtifacts;
    }

    @Override
    public SortedSet<ExtensionRepoVersionSummary> getExtensionRepoVersions(Bucket bucket, String groupId, String artifactId) {
        if (bucket == null) {
            throw new IllegalArgumentException("Bucket cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new IllegalArgumentException("Group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)artifactId)) {
            throw new IllegalArgumentException("Artifact id cannot be null or blank");
        }
        TreeSet<ExtensionRepoVersionSummary> repoVersions = new TreeSet<ExtensionRepoVersionSummary>();
        List<BundleVersionEntity> versionEntities = this.metadataService.getBundleVersions(bucket.getIdentifier(), groupId, artifactId);
        if (!versionEntities.isEmpty()) {
            BundleEntity bundleEntity = this.metadataService.getBundle(bucket.getIdentifier(), groupId, artifactId);
            if (bundleEntity == null) {
                throw new ResourceNotFoundException("The specified extension bundle does not exist in this bucket");
            }
            versionEntities.forEach(v -> {
                ExtensionRepoVersionSummary repoVersion = new ExtensionRepoVersionSummary();
                repoVersion.setBucketName(bucket.getName());
                repoVersion.setGroupId(bundleEntity.getGroupId());
                repoVersion.setArtifactId(bundleEntity.getArtifactId());
                repoVersion.setVersion(v.getVersion());
                repoVersion.setAuthor(v.getCreatedBy());
                repoVersion.setTimestamp(v.getCreated().getTime());
                repoVersions.add(repoVersion);
            });
        }
        return repoVersions;
    }

    private BundleVersionCoordinate getVersionCoordinate(BundleVersion bundleVersion) {
        return this.getVersionCoordinate(bundleVersion.getBundle(), bundleVersion.getVersionMetadata());
    }

    private BundleVersionCoordinate getVersionCoordinate(Bundle bundle, BundleVersionMetadata bundleVersionMetadata) {
        StandardBundleVersionCoordinate versionCoordinate = new StandardBundleVersionCoordinate.Builder().bucketId(bundle.getBucketIdentifier()).groupId(bundle.getGroupId()).artifactId(bundle.getArtifactId()).version(bundleVersionMetadata.getVersion()).type(this.getProviderBundleType(bundle.getBundleType())).build();
        return versionCoordinate;
    }

    private BucketEntity getBucketEntity(String bucketIdentifier) {
        BucketEntity existingBucket = this.metadataService.getBucketById(bucketIdentifier);
        if (existingBucket == null) {
            LOGGER.warn("The specified bucket id [{}] does not exist.", (Object)bucketIdentifier);
            throw new ResourceNotFoundException("The specified bucket ID does not exist in this registry.");
        }
        return existingBucket;
    }

    private BundleEntity getBundleEntity(String bundleId) {
        BundleEntity existingBundle = this.metadataService.getBundle(bundleId);
        if (existingBundle == null) {
            LOGGER.warn("The specified extension bundle id [{}] does not exist.", (Object)bundleId);
            throw new ResourceNotFoundException("The specified extension bundle ID does not exist.");
        }
        return existingBundle;
    }
}

